/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.reliability.pcm2markov;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.palladiosimulator.solver.models.PCMInstance;
import org.palladiosimulator.solver.reliability.pcm2markov.MarkovTransformation;
import org.palladiosimulator.solver.reliability.pcm2markov.MarkovTransformationResult;
import org.palladiosimulator.solver.reliability.reporting.MarkovReporting;
import org.palladiosimulator.solver.reliability.sensitivity.MarkovSensitivity;
import org.palladiosimulator.solver.reliability.sensitivity.MarkovSensitivityBuilder;
import org.palladiosimulator.solver.reliability.visualisation.MarkovHtmlGenerator;
import org.palladiosimulator.solver.reliability.visualisation.MarkovResultEditorInput;
import org.palladiosimulator.solver.runconfig.PCMSolverWorkflowRunConfiguration;
import org.palladiosimulator.solver.transformations.EMFHelper;
import org.palladiosimulator.solver.transformations.SolverStrategy;

public class Pcm2MarkovStrategy
implements SolverStrategy {
    private PCMSolverWorkflowRunConfiguration configuration;
    private List<MarkovTransformationResult> markovResults;
    private MarkovSensitivity markovSensitivity;

    public Pcm2MarkovStrategy(PCMSolverWorkflowRunConfiguration configuration) {
        this.configuration = configuration;
        this.markovSensitivity = this.initSensitivityAnalysis();
    }

    public MarkovTransformationResult getSolvedValue() {
        return this.markovResults.size() > 0 ? this.markovResults.get(0) : null;
    }

    public List<MarkovTransformationResult> getAllSolvedValues() {
        return this.markovResults;
    }

    private MarkovSensitivity initSensitivityAnalysis() {
        if (this.configuration.isSensitivityModelEnabled()) {
            MarkovSensitivityBuilder builder = new MarkovSensitivityBuilder();
            return builder.buildSensitivity(this.resolveFile(this.configuration.getSensitivityModelFileName()), this.resolveFile(this.configuration.getSensitivityLogFileName()));
        }
        return null;
    }

    public void loadTransformedModel(String fileName) {
        throw new UnsupportedOperationException();
    }

    private String resolveFile(String fileURL) {
        if (fileURL.startsWith("platform:")) {
            try {
                URL solvedURL = FileLocator.resolve((URL)new URL(fileURL));
                fileURL = solvedURL.getPath();
            }
            catch (Exception e) {
                e.printStackTrace();
                return "";
            }
        }
        return fileURL;
    }

    private void saveResultsToFile(String htmlCode) {
        BufferedWriter out = null;
        String filePath = this.resolveFile(this.configuration.getSaveFile());
        try {
            try {
                File f = new File(filePath);
                if (f.exists()) {
                    f.delete();
                    f.createNewFile();
                }
                out = new BufferedWriter(new FileWriter(filePath, true));
                out.append(htmlCode.toString());
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    if (out != null) {
                        out.flush();
                        out.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (out != null) {
                    out.flush();
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void showResults(final String htmlCode) {
        if (this.markovResults != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    if (page != null) {
                        try {
                            page.openEditor((IEditorInput)new MarkovResultEditorInput(htmlCode), "org.palladiosimulator.reliability.solver.pcm2markov.MarkovResultEditor");
                        }
                        catch (PartInitException e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
        }
    }

    public void solve() {
    }

    public void storeTransformedModel(String fileName) {
        MarkovTransformationResult result;
        MarkovTransformationResult markovTransformationResult = result = this.markovResults.size() > 0 ? this.markovResults.get(0) : null;
        if (result != null) {
            EMFHelper.saveToXMIFile((EObject)result.getResultChain(), (String)this.resolveFile(fileName));
        }
    }

    public void transform(PCMInstance model) {
        this.markovResults = new MarkovTransformation().runTransform(model, this.configuration, this.markovSensitivity);
        if (this.configuration.isMarkovModelStorageEnabled()) {
            this.storeTransformedModel(this.configuration.getMarkovModelFile());
        }
        String htmlCode = new MarkovHtmlGenerator(new MarkovReporting(this.markovResults, this.configuration)).getHtml();
        if (this.configuration.isSaveResultsToFileEnabled()) {
            this.saveResultsToFile(htmlCode);
        }
        if (this.configuration.isShowHtmlResults()) {
            this.showResults(htmlCode);
        }
    }
}

