/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.reliability.reporting;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;
import org.palladiosimulator.reliability.MarkovEvaluationType;
import org.palladiosimulator.reliability.MarkovFailureType;
import org.palladiosimulator.reliability.MarkovHardwareInducedFailureType;
import org.palladiosimulator.reliability.MarkovNetworkInducedFailureType;
import org.palladiosimulator.reliability.MarkovSoftwareInducedFailureType;
import org.palladiosimulator.solver.reliability.pcm2markov.MarkovResultApproximation;
import org.palladiosimulator.solver.reliability.pcm2markov.MarkovTransformationResult;
import org.palladiosimulator.solver.reliability.reporting.ClassesFailureProbabilityAggregation;
import org.palladiosimulator.solver.reliability.reporting.FailureAnalysisFailureType;
import org.palladiosimulator.solver.reliability.reporting.ImpactAnalysisFailureProbabilityAggregation;
import org.palladiosimulator.solver.reliability.reporting.ImpactAnalysisFailureType;
import org.palladiosimulator.solver.reliability.reporting.MarkovReportItem;
import org.palladiosimulator.solver.reliability.reporting.MarkovReportingTable;
import org.palladiosimulator.solver.reliability.reporting.TypesFailureProbabilityAggregation;
import org.palladiosimulator.solver.runconfig.PCMSolverWorkflowRunConfiguration;

public class MarkovReporting {
    PCMSolverWorkflowRunConfiguration configuration;
    List<ImpactAnalysisFailureProbabilityAggregation> failureProbabilityAggregations;
    List<MarkovReportItem> markovReportItems;
    private List<MarkovTransformationResult> markovResults;

    public MarkovReporting(List<MarkovTransformationResult> markovResults, PCMSolverWorkflowRunConfiguration configuration) {
        this.markovResults = markovResults;
        this.configuration = configuration;
        this.markovReportItems = new ArrayList<MarkovReportItem>();
        this.createMarkovReportItems();
    }

    private void calculateComponentsInternalActionFailureProbabilities(Map<MarkovFailureType, Double> cumulatedFailureTypeProbabilities) {
        for (MarkovFailureType failureType : cumulatedFailureTypeProbabilities.keySet()) {
            if (failureType.isSystemExternal() || !(failureType instanceof MarkovSoftwareInducedFailureType)) continue;
            MarkovSoftwareInducedFailureType softwareInducedFailureType = (MarkovSoftwareInducedFailureType)failureType;
            boolean foundEntry = false;
            ArrayList<String> identifiers = new ArrayList<String>(1);
            identifiers.add(softwareInducedFailureType.getComponentId());
            ArrayList<String> nameParts = new ArrayList<String>(1);
            nameParts.add(softwareInducedFailureType.getComponentName());
            for (ImpactAnalysisFailureProbabilityAggregation aggregation : this.failureProbabilityAggregations) {
                if (!aggregation.compareToIdentifier(ImpactAnalysisFailureType.COMPONENTS_INTERNAL_ACTIONS, identifiers)) continue;
                aggregation.addToFailureProbabilityBy(cumulatedFailureTypeProbabilities.get(failureType));
                foundEntry = true;
                break;
            }
            if (foundEntry) continue;
            this.failureProbabilityAggregations.add(new ImpactAnalysisFailureProbabilityAggregation(ImpactAnalysisFailureType.COMPONENTS_INTERNAL_ACTIONS, identifiers, nameParts, cumulatedFailureTypeProbabilities.get(failureType)));
        }
    }

    private void calculateComponentsServiceFailureProbabilities(Map<MarkovFailureType, Double> cumulatedFailureTypeProbabilities) {
        for (MarkovFailureType failureType : cumulatedFailureTypeProbabilities.keySet()) {
            if (failureType.isSystemExternal() || !(failureType instanceof MarkovSoftwareInducedFailureType)) continue;
            MarkovSoftwareInducedFailureType softwareInducedFailureType = (MarkovSoftwareInducedFailureType)failureType;
            boolean foundEntry = false;
            ArrayList<String> identifiers = new ArrayList<String>(2);
            identifiers.add(softwareInducedFailureType.getComponentId());
            identifiers.add(softwareInducedFailureType.getInterfaceId());
            ArrayList<String> nameParts = new ArrayList<String>(2);
            nameParts.add(softwareInducedFailureType.getComponentName());
            nameParts.add(softwareInducedFailureType.getInterfaceName());
            for (ImpactAnalysisFailureProbabilityAggregation aggregation : this.failureProbabilityAggregations) {
                if (!aggregation.compareToIdentifier(ImpactAnalysisFailureType.COMPONENTS_SERVICES, identifiers)) continue;
                aggregation.addToFailureProbabilityBy(cumulatedFailureTypeProbabilities.get(failureType));
                foundEntry = true;
                break;
            }
            if (foundEntry) continue;
            this.failureProbabilityAggregations.add(new ImpactAnalysisFailureProbabilityAggregation(ImpactAnalysisFailureType.COMPONENTS_SERVICES, identifiers, nameParts, cumulatedFailureTypeProbabilities.get(failureType)));
        }
    }

    private void calculateComponentsServiceOperationFailureProbabilities(Map<MarkovFailureType, Double> cumulatedFailureTypeProbabilities) {
        for (MarkovFailureType failureType : cumulatedFailureTypeProbabilities.keySet()) {
            if (failureType.isSystemExternal() || !(failureType instanceof MarkovSoftwareInducedFailureType)) continue;
            MarkovSoftwareInducedFailureType softwareInducedFailureType = (MarkovSoftwareInducedFailureType)failureType;
            boolean foundEntry = false;
            ArrayList<String> identifiers = new ArrayList<String>(3);
            identifiers.add(softwareInducedFailureType.getComponentId());
            identifiers.add(softwareInducedFailureType.getInterfaceId());
            identifiers.add(softwareInducedFailureType.getSignatureId());
            ArrayList<String> nameParts = new ArrayList<String>(3);
            nameParts.add(softwareInducedFailureType.getComponentName());
            nameParts.add(softwareInducedFailureType.getInterfaceName());
            nameParts.add(softwareInducedFailureType.getSignatureName());
            for (ImpactAnalysisFailureProbabilityAggregation aggregation : this.failureProbabilityAggregations) {
                if (!aggregation.compareToIdentifier(ImpactAnalysisFailureType.COMPONENTS_SERVICE_OPERATIONS, identifiers)) continue;
                aggregation.addToFailureProbabilityBy(cumulatedFailureTypeProbabilities.get(failureType));
                foundEntry = true;
                break;
            }
            if (foundEntry) continue;
            this.failureProbabilityAggregations.add(new ImpactAnalysisFailureProbabilityAggregation(ImpactAnalysisFailureType.COMPONENTS_SERVICE_OPERATIONS, identifiers, nameParts, cumulatedFailureTypeProbabilities.get(failureType)));
        }
    }

    private void calculateExternalServiceFailureProbabilities(Map<MarkovFailureType, Double> cumulatedFailureTypeProbabilities) {
        for (MarkovFailureType failureType : cumulatedFailureTypeProbabilities.keySet()) {
            if (!failureType.isSystemExternal()) continue;
            boolean foundEntry = false;
            ArrayList<String> identifiers = new ArrayList<String>(2);
            identifiers.add(failureType.getRoleId());
            identifiers.add(failureType.getInterfaceId());
            ArrayList<String> nameParts = new ArrayList<String>(2);
            nameParts.add(failureType.getRoleName());
            nameParts.add(failureType.getInterfaceName());
            for (ImpactAnalysisFailureProbabilityAggregation aggregation : this.failureProbabilityAggregations) {
                if (!aggregation.compareToIdentifier(ImpactAnalysisFailureType.EXTERNAL_SERVICES, identifiers)) continue;
                aggregation.addToFailureProbabilityBy(cumulatedFailureTypeProbabilities.get(failureType));
                foundEntry = true;
                break;
            }
            if (foundEntry) continue;
            this.failureProbabilityAggregations.add(new ImpactAnalysisFailureProbabilityAggregation(ImpactAnalysisFailureType.EXTERNAL_SERVICES, identifiers, nameParts, cumulatedFailureTypeProbabilities.get(failureType)));
        }
    }

    private void calculateExternalServiceOperationFailureProbabilities(Map<MarkovFailureType, Double> cumulatedFailureTypeProbabilities) {
        for (MarkovFailureType failureType : cumulatedFailureTypeProbabilities.keySet()) {
            if (!failureType.isSystemExternal()) continue;
            boolean foundEntry = false;
            ArrayList<String> identifiers = new ArrayList<String>(3);
            identifiers.add(failureType.getRoleId());
            identifiers.add(failureType.getInterfaceId());
            identifiers.add(failureType.getSignatureId());
            ArrayList<String> nameParts = new ArrayList<String>(3);
            nameParts.add(failureType.getRoleName());
            nameParts.add(failureType.getInterfaceName());
            nameParts.add(failureType.getSignatureName());
            for (ImpactAnalysisFailureProbabilityAggregation aggregation : this.failureProbabilityAggregations) {
                if (!aggregation.compareToIdentifier(ImpactAnalysisFailureType.EXTERNAL_SERVICE_OPERATIONS, identifiers)) continue;
                aggregation.addToFailureProbabilityBy(cumulatedFailureTypeProbabilities.get(failureType));
                foundEntry = true;
                break;
            }
            if (foundEntry) continue;
            this.failureProbabilityAggregations.add(new ImpactAnalysisFailureProbabilityAggregation(ImpactAnalysisFailureType.EXTERNAL_SERVICE_OPERATIONS, identifiers, nameParts, cumulatedFailureTypeProbabilities.get(failureType)));
        }
    }

    private void createClassesFailureAnalysisTable(Map<MarkovFailureType, Double> cumulatedFailureTypeProbabilities, double cumulatedPhysicalStateProbability, boolean doApproximate, MarkovReportItem markovReportItem) {
        MarkovReportingTable failureCategoryTable = new MarkovReportingTable("Failure mode categories");
        ArrayList<String> failureCategoryTableHeaderRow = new ArrayList<String>(2);
        failureCategoryTableHeaderRow.add("Category");
        failureCategoryTableHeaderRow.add("Failure Mode Probability");
        failureCategoryTable.setHeaderRow(failureCategoryTableHeaderRow);
        ClassesFailureProbabilityAggregation softwareInducedFailureAggregation = new ClassesFailureProbabilityAggregation(FailureAnalysisFailureType.SOFTWARE_INDUCED);
        ClassesFailureProbabilityAggregation hardwareInducedFailureAggregation = new ClassesFailureProbabilityAggregation(FailureAnalysisFailureType.HARDWARE_INDUCED);
        ClassesFailureProbabilityAggregation networkInducedFailureAggregation = new ClassesFailureProbabilityAggregation(FailureAnalysisFailureType.NETWORK_INDUCED);
        for (MarkovFailureType type : cumulatedFailureTypeProbabilities.keySet()) {
            if (type.isSystemExternal()) continue;
            if (type instanceof MarkovSoftwareInducedFailureType) {
                softwareInducedFailureAggregation.addToFailureProbabilityBy(cumulatedFailureTypeProbabilities.get(type));
                continue;
            }
            if (type instanceof MarkovHardwareInducedFailureType) {
                hardwareInducedFailureAggregation.addToFailureProbabilityBy(cumulatedFailureTypeProbabilities.get(type));
                continue;
            }
            if (!(type instanceof MarkovNetworkInducedFailureType)) continue;
            networkInducedFailureAggregation.addToFailureProbabilityBy(cumulatedFailureTypeProbabilities.get(type));
        }
        ArrayList<String> row = new ArrayList<String>(failureCategoryTableHeaderRow.size());
        row.add("Software-induced failure");
        double failureProbability = softwareInducedFailureAggregation.getFailureProbability();
        row.add(String.valueOf(doApproximate ? this.getFormattedProbabilityAsString(failureProbability, failureProbability + 1.0 - cumulatedPhysicalStateProbability) : this.getFormattedProbabilityAsString(failureProbability)));
        if (failureProbability > 0.0) {
            failureCategoryTable.addRow(row);
        }
        row = new ArrayList(failureCategoryTableHeaderRow.size());
        row.add("Hardware-induced failure");
        failureProbability = hardwareInducedFailureAggregation.getFailureProbability();
        row.add(String.valueOf(doApproximate ? this.getFormattedProbabilityAsString(failureProbability, failureProbability + 1.0 - cumulatedPhysicalStateProbability) : this.getFormattedProbabilityAsString(failureProbability)));
        if (failureProbability > 0.0) {
            failureCategoryTable.addRow(row);
        }
        row = new ArrayList(failureCategoryTableHeaderRow.size());
        row.add("Network-induced failure");
        failureProbability = networkInducedFailureAggregation.getFailureProbability();
        row.add(String.valueOf(doApproximate ? this.getFormattedProbabilityAsString(failureProbability, failureProbability + 1.0 - cumulatedPhysicalStateProbability) : this.getFormattedProbabilityAsString(failureProbability)));
        if (failureProbability > 0.0) {
            failureCategoryTable.addRow(row);
        }
        if (failureCategoryTable.getRows().size() > 0) {
            markovReportItem.addFailureModeTable(failureCategoryTable);
        }
    }

    private void createFailureAnalysisTables(Map<MarkovFailureType, Double> cumulatedFailureTypeProbabilities, double cumulatedPhysicalStateProbability, boolean doApproximate, MarkovReportItem markovReportItem, MarkovEvaluationType mode) {
        switch (mode) {
            case SINGLE: {
                break;
            }
            case CLASSES: {
                this.createClassesFailureAnalysisTable(cumulatedFailureTypeProbabilities, cumulatedPhysicalStateProbability, doApproximate, markovReportItem);
                break;
            }
            case TYPES: {
                this.createTypesFailureAnalysisTable(cumulatedFailureTypeProbabilities, cumulatedPhysicalStateProbability, doApproximate, markovReportItem);
                break;
            }
            case POINTSOFFAILURE: {
                this.createPointsOfFailureAnalysisTable(cumulatedFailureTypeProbabilities, cumulatedPhysicalStateProbability, doApproximate, markovReportItem);
                break;
            }
        }
    }

    private void createImpactAnalysisTables(double cumulatedPhysicalStateProbability, boolean doApproximate, MarkovReportItem markovReportItem) {
        MarkovReportingTable componentsInternalActionFailureProbabilitiesTable = new MarkovReportingTable("Component failure impacts");
        ArrayList<String> componentsInternalActionFailureProbabilitiesTableHeaderRow = new ArrayList<String>(3);
        componentsInternalActionFailureProbabilitiesTableHeaderRow.add("Component");
        componentsInternalActionFailureProbabilitiesTableHeaderRow.add("Aggregated Failure Mode Probability");
        componentsInternalActionFailureProbabilitiesTable.setHeaderRow(componentsInternalActionFailureProbabilitiesTableHeaderRow);
        MarkovReportingTable componentsServiceFailureProbabilitiesTable = new MarkovReportingTable("Component service failure impacts");
        ArrayList<String> componentsServiceFailureProbabilitiesTableHeaderRow = new ArrayList<String>(3);
        componentsServiceFailureProbabilitiesTableHeaderRow.add("Component");
        componentsServiceFailureProbabilitiesTableHeaderRow.add("Interface");
        componentsServiceFailureProbabilitiesTableHeaderRow.add("Aggregated Failure Mode Probability");
        componentsServiceFailureProbabilitiesTable.setHeaderRow(componentsServiceFailureProbabilitiesTableHeaderRow);
        MarkovReportingTable componentsServiceOperationFailureProbabilitiesTable = new MarkovReportingTable("Component operation failure impacts");
        ArrayList<String> componentsServiceOperationFailureProbabilitiesTableHeaderRow = new ArrayList<String>(4);
        componentsServiceOperationFailureProbabilitiesTableHeaderRow.add("Component");
        componentsServiceOperationFailureProbabilitiesTableHeaderRow.add("Interface");
        componentsServiceOperationFailureProbabilitiesTableHeaderRow.add("Signature");
        componentsServiceOperationFailureProbabilitiesTableHeaderRow.add("Aggregated Failure Mode Probability");
        componentsServiceOperationFailureProbabilitiesTable.setHeaderRow(componentsServiceOperationFailureProbabilitiesTableHeaderRow);
        MarkovReportingTable externalServiceFailureProbabilitiesTable = new MarkovReportingTable("External service failure impacts");
        ArrayList<String> externalServiceFailureProbabilitiesTableHeaderRow = new ArrayList<String>(4);
        externalServiceFailureProbabilitiesTableHeaderRow.add("System-required Role");
        externalServiceFailureProbabilitiesTableHeaderRow.add("Interface");
        externalServiceFailureProbabilitiesTableHeaderRow.add("Aggregated Failure Mode Probability");
        externalServiceFailureProbabilitiesTable.setHeaderRow(externalServiceFailureProbabilitiesTableHeaderRow);
        MarkovReportingTable externalServiceOperationFailureProbabilitiesTable = new MarkovReportingTable("External operation failure impacts");
        ArrayList<String> externalServiceOperationFailureProbabilitiesTableHeaderRow = new ArrayList<String>(4);
        externalServiceOperationFailureProbabilitiesTableHeaderRow.add("System-required Role");
        externalServiceOperationFailureProbabilitiesTableHeaderRow.add("Interface");
        externalServiceOperationFailureProbabilitiesTableHeaderRow.add("Signature");
        externalServiceOperationFailureProbabilitiesTableHeaderRow.add("Aggregated Failure Mode Probability");
        externalServiceOperationFailureProbabilitiesTable.setHeaderRow(externalServiceOperationFailureProbabilitiesTableHeaderRow);
        for (ImpactAnalysisFailureProbabilityAggregation aggregation : this.failureProbabilityAggregations) {
            double failureProbability = aggregation.getFailureProbability();
            if (!(failureProbability > 0.0)) continue;
            switch (aggregation.getType()) {
                case COMPONENTS_INTERNAL_ACTIONS: {
                    ArrayList<String> componentsInternalActionFailureProbabilitiesTableRow = new ArrayList<String>(componentsInternalActionFailureProbabilitiesTableHeaderRow.size());
                    for (String entityNamePart : aggregation.getEntityNameParts()) {
                        componentsInternalActionFailureProbabilitiesTableRow.add(entityNamePart);
                    }
                    componentsInternalActionFailureProbabilitiesTableRow.add(doApproximate ? this.getFormattedProbabilityAsString(failureProbability, failureProbability + 1.0 - cumulatedPhysicalStateProbability) : this.getFormattedProbabilityAsString(failureProbability));
                    componentsInternalActionFailureProbabilitiesTable.addRow(componentsInternalActionFailureProbabilitiesTableRow);
                    break;
                }
                case COMPONENTS_SERVICES: {
                    ArrayList<String> componentsServicesFailureProbabilitiesTableRow = new ArrayList<String>(componentsServiceFailureProbabilitiesTableHeaderRow.size());
                    for (String entityNamePart : aggregation.getEntityNameParts()) {
                        componentsServicesFailureProbabilitiesTableRow.add(entityNamePart);
                    }
                    componentsServicesFailureProbabilitiesTableRow.add(doApproximate ? this.getFormattedProbabilityAsString(failureProbability, failureProbability + 1.0 - cumulatedPhysicalStateProbability) : this.getFormattedProbabilityAsString(failureProbability));
                    componentsServiceFailureProbabilitiesTable.addRow(componentsServicesFailureProbabilitiesTableRow);
                    break;
                }
                case COMPONENTS_SERVICE_OPERATIONS: {
                    ArrayList<String> componentsServiceOperationFailureProbabilitiesTableRow = new ArrayList<String>(componentsServiceOperationFailureProbabilitiesTableHeaderRow.size());
                    for (String entityNamePart : aggregation.getEntityNameParts()) {
                        componentsServiceOperationFailureProbabilitiesTableRow.add(entityNamePart);
                    }
                    componentsServiceOperationFailureProbabilitiesTableRow.add(doApproximate ? this.getFormattedProbabilityAsString(failureProbability, failureProbability + 1.0 - cumulatedPhysicalStateProbability) : this.getFormattedProbabilityAsString(failureProbability));
                    componentsServiceOperationFailureProbabilitiesTable.addRow(componentsServiceOperationFailureProbabilitiesTableRow);
                    break;
                }
                case EXTERNAL_SERVICES: {
                    ArrayList<String> externalServiceFailureProbabilitiesTableRow = new ArrayList<String>(externalServiceFailureProbabilitiesTableHeaderRow.size());
                    for (String entityNamePart : aggregation.getEntityNameParts()) {
                        externalServiceFailureProbabilitiesTableRow.add(entityNamePart);
                    }
                    externalServiceFailureProbabilitiesTableRow.add(doApproximate ? this.getFormattedProbabilityAsString(failureProbability, failureProbability + 1.0 - cumulatedPhysicalStateProbability) : this.getFormattedProbabilityAsString(failureProbability));
                    externalServiceFailureProbabilitiesTable.addRow(externalServiceFailureProbabilitiesTableRow);
                    break;
                }
                case EXTERNAL_SERVICE_OPERATIONS: {
                    ArrayList<String> externalServiceOperationFailureProbabilitiesTableRow = new ArrayList<String>(externalServiceFailureProbabilitiesTableHeaderRow.size());
                    for (String entityNamePart : aggregation.getEntityNameParts()) {
                        externalServiceOperationFailureProbabilitiesTableRow.add(entityNamePart);
                    }
                    externalServiceOperationFailureProbabilitiesTableRow.add(doApproximate ? this.getFormattedProbabilityAsString(failureProbability, failureProbability + 1.0 - cumulatedPhysicalStateProbability) : this.getFormattedProbabilityAsString(failureProbability));
                    externalServiceOperationFailureProbabilitiesTable.addRow(externalServiceOperationFailureProbabilitiesTableRow);
                    break;
                }
            }
        }
        if (componentsInternalActionFailureProbabilitiesTable.getRows().size() > 0) {
            markovReportItem.addImpactAnalysisTable(componentsInternalActionFailureProbabilitiesTable);
        }
        if (componentsServiceFailureProbabilitiesTable.getRows().size() > 0) {
            markovReportItem.addImpactAnalysisTable(componentsServiceFailureProbabilitiesTable);
        }
        if (componentsServiceOperationFailureProbabilitiesTable.getRows().size() > 0) {
            markovReportItem.addImpactAnalysisTable(componentsServiceOperationFailureProbabilitiesTable);
        }
        if (externalServiceFailureProbabilitiesTable.getRows().size() > 0) {
            markovReportItem.addImpactAnalysisTable(externalServiceFailureProbabilitiesTable);
        }
        if (externalServiceOperationFailureProbabilitiesTable.getRows().size() > 0) {
            markovReportItem.addImpactAnalysisTable(externalServiceOperationFailureProbabilitiesTable);
        }
    }

    private void createMarkovReportItems() {
        Map<MarkovFailureType, Double> cumulatedFailureTypeProbabilities = null;
        double cumulatedPhysicalStateProbability = 0.0;
        boolean doApproximate = false;
        double cumulatedSuccessProbability = -1.0;
        MarkovEvaluationType mode = MarkovEvaluationType.valueOf((String)this.configuration.getMarkovEvaluationMode());
        UsageScenario scenario = null;
        MarkovReportItem markovReportItem = null;
        for (MarkovTransformationResult markovResult : this.markovResults) {
            scenario = markovResult.getScenario();
            cumulatedFailureTypeProbabilities = markovResult.getCumulatedFailureTypeProbabilities();
            cumulatedPhysicalStateProbability = markovResult.getCumulatedPhysicalStateProbability();
            cumulatedSuccessProbability = markovResult.getSuccessProbability();
            doApproximate = markovResult.isDoApproximate();
            markovReportItem = doApproximate ? new MarkovReportItem(scenario.getEntityName(), scenario.getId(), this.getFormattedProbabilityAsString(cumulatedSuccessProbability, cumulatedSuccessProbability + 1.0 - cumulatedPhysicalStateProbability)) : new MarkovReportItem(scenario.getEntityName(), scenario.getId(), this.getFormattedProbabilityAsString(cumulatedSuccessProbability));
            this.createFailureAnalysisTables(cumulatedFailureTypeProbabilities, cumulatedPhysicalStateProbability, doApproximate, markovReportItem, mode);
            if (mode == MarkovEvaluationType.POINTSOFFAILURE) {
                this.failureProbabilityAggregations = new ArrayList<ImpactAnalysisFailureProbabilityAggregation>();
                this.calculateComponentsInternalActionFailureProbabilities(cumulatedFailureTypeProbabilities);
                this.calculateComponentsServiceFailureProbabilities(cumulatedFailureTypeProbabilities);
                this.calculateComponentsServiceOperationFailureProbabilities(cumulatedFailureTypeProbabilities);
                this.calculateExternalServiceFailureProbabilities(cumulatedFailureTypeProbabilities);
                this.calculateExternalServiceOperationFailureProbabilities(cumulatedFailureTypeProbabilities);
                this.createImpactAnalysisTables(cumulatedPhysicalStateProbability, doApproximate, markovReportItem);
            }
            this.markovReportItems.add(markovReportItem);
        }
    }

    private void createPointsOfFailureAnalysisTable(Map<MarkovFailureType, Double> cumulatedFailureTypeProbabilities, double cumulatedPhysicalStateProbability, boolean doApproximate, MarkovReportItem markovReportItem) {
        MarkovReportingTable internalSoftwareFailuresTable = new MarkovReportingTable("System-internal software-induced failure modes");
        ArrayList<String> internalSoftwareFailuresTableHeaderRow = new ArrayList<String>(6);
        internalSoftwareFailuresTableHeaderRow.add("Component");
        internalSoftwareFailuresTableHeaderRow.add("Interface");
        internalSoftwareFailuresTableHeaderRow.add("Signature");
        internalSoftwareFailuresTableHeaderRow.add("Internal Action");
        internalSoftwareFailuresTableHeaderRow.add("Internal Action id");
        internalSoftwareFailuresTableHeaderRow.add("Failure Type");
        internalSoftwareFailuresTableHeaderRow.add("Failure Mode Probability");
        internalSoftwareFailuresTable.setHeaderRow(internalSoftwareFailuresTableHeaderRow);
        MarkovReportingTable internalHardwareFailuresTable = new MarkovReportingTable("System-internal hardware-induced failure modes");
        ArrayList<String> internalHardwareFailuresTableHeaderRow = new ArrayList<String>(3);
        internalHardwareFailuresTableHeaderRow.add("Resource Container");
        internalHardwareFailuresTableHeaderRow.add("Resource Container id");
        internalHardwareFailuresTableHeaderRow.add("Resource Type");
        internalHardwareFailuresTableHeaderRow.add("Failure Mode Probablity");
        internalHardwareFailuresTable.setHeaderRow(internalHardwareFailuresTableHeaderRow);
        MarkovReportingTable internalNetworkFailuresTable = new MarkovReportingTable("System-internal network-induced failure modes");
        ArrayList<String> internalNetworkFailuresTableHeaderRow = new ArrayList<String>(3);
        internalNetworkFailuresTableHeaderRow.add("Communication Link");
        internalNetworkFailuresTableHeaderRow.add("Communication Link id");
        internalNetworkFailuresTableHeaderRow.add("Communication Resource Type");
        internalNetworkFailuresTableHeaderRow.add("Failure Mode Probablity");
        internalNetworkFailuresTable.setHeaderRow(internalNetworkFailuresTableHeaderRow);
        MarkovReportingTable externalSoftwareFailuresTable = new MarkovReportingTable("System-external software-induced failure modes");
        ArrayList<String> externalSoftwareFailuresTableHeaderRow = new ArrayList<String>(4);
        externalSoftwareFailuresTableHeaderRow.add("System-required Role");
        externalSoftwareFailuresTableHeaderRow.add("System-required Role id");
        externalSoftwareFailuresTableHeaderRow.add("Signature");
        externalSoftwareFailuresTableHeaderRow.add("Failure Type");
        externalSoftwareFailuresTableHeaderRow.add("Failure Mode Probability");
        externalSoftwareFailuresTable.setHeaderRow(externalSoftwareFailuresTableHeaderRow);
        MarkovReportingTable externalHardwareFailuresTable = new MarkovReportingTable("System-external hardware-induced failure modes");
        ArrayList<String> externalHardwareFailuresTableHeaderRow = new ArrayList<String>(4);
        externalHardwareFailuresTableHeaderRow.add("System-required Role");
        externalHardwareFailuresTableHeaderRow.add("System-required Role id");
        externalHardwareFailuresTableHeaderRow.add("Signature");
        externalHardwareFailuresTableHeaderRow.add("Communication Resource Type");
        externalHardwareFailuresTableHeaderRow.add("Failure Mode Probablity");
        externalHardwareFailuresTable.setHeaderRow(externalHardwareFailuresTableHeaderRow);
        MarkovReportingTable externalNetworkFailuresTable = new MarkovReportingTable("System-external network-induced failure modes");
        ArrayList<String> externalNetworkFailuresTableHeaderRow = new ArrayList<String>(4);
        externalNetworkFailuresTableHeaderRow.add("System-required Role");
        externalNetworkFailuresTableHeaderRow.add("System-required Role id");
        externalNetworkFailuresTableHeaderRow.add("Signature");
        externalNetworkFailuresTableHeaderRow.add("Communication Resource Type");
        externalNetworkFailuresTableHeaderRow.add("Failure Mode Probablity");
        externalNetworkFailuresTable.setHeaderRow(externalNetworkFailuresTableHeaderRow);
        TreeSet<MarkovFailureType> failureTypesSorted = this.getFailureTypesSorted(cumulatedFailureTypeProbabilities);
        for (MarkovFailureType failureType : failureTypesSorted) {
            MarkovNetworkInducedFailureType networkInducedFailureType;
            MarkovHardwareInducedFailureType hardwareInducedFailureType;
            MarkovSoftwareInducedFailureType softwareInducedFailureType;
            double failureProbability = this.getFailureTypeProbability(failureType, cumulatedFailureTypeProbabilities);
            if (!(failureProbability > 0.0)) continue;
            if (failureType.isSystemExternal()) {
                if (failureType instanceof MarkovSoftwareInducedFailureType) {
                    softwareInducedFailureType = (MarkovSoftwareInducedFailureType)failureType;
                    ArrayList<String> externalSoftwareFailuresTableRow = new ArrayList<String>(externalSoftwareFailuresTableHeaderRow.size());
                    externalSoftwareFailuresTableRow.add(softwareInducedFailureType.getRoleName());
                    externalSoftwareFailuresTableRow.add(softwareInducedFailureType.getRoleId());
                    externalSoftwareFailuresTableRow.add(softwareInducedFailureType.getSignatureName());
                    externalSoftwareFailuresTableRow.add(softwareInducedFailureType.getSoftwareFailureName());
                    externalSoftwareFailuresTableRow.add(doApproximate ? this.getFormattedProbabilityAsString(this.getFailureTypeProbability((MarkovFailureType)softwareInducedFailureType, cumulatedFailureTypeProbabilities), failureProbability + 1.0 - cumulatedPhysicalStateProbability) : this.getFormattedProbabilityAsString(failureProbability));
                    externalSoftwareFailuresTable.addRow(externalSoftwareFailuresTableRow);
                    continue;
                }
                if (failureType instanceof MarkovHardwareInducedFailureType) {
                    hardwareInducedFailureType = (MarkovHardwareInducedFailureType)failureType;
                    ArrayList<String> externalHardwareFailuresTableRow = new ArrayList<String>(externalHardwareFailuresTableHeaderRow.size());
                    externalHardwareFailuresTableRow.add(hardwareInducedFailureType.getRoleName());
                    externalHardwareFailuresTableRow.add(hardwareInducedFailureType.getRoleId());
                    externalHardwareFailuresTableRow.add(hardwareInducedFailureType.getSignatureName());
                    externalHardwareFailuresTableRow.add(hardwareInducedFailureType.getResourceTypeName());
                    externalHardwareFailuresTableRow.add(doApproximate ? this.getFormattedProbabilityAsString(failureProbability, failureProbability + 1.0 - cumulatedPhysicalStateProbability) : this.getFormattedProbabilityAsString(failureProbability));
                    externalHardwareFailuresTable.addRow(externalHardwareFailuresTableRow);
                    continue;
                }
                if (!(failureType instanceof MarkovNetworkInducedFailureType)) continue;
                networkInducedFailureType = (MarkovNetworkInducedFailureType)failureType;
                ArrayList<String> externalNetworkFailuresTableRow = new ArrayList<String>(externalNetworkFailuresTableHeaderRow.size());
                externalNetworkFailuresTableRow.add(networkInducedFailureType.getRoleName());
                externalNetworkFailuresTableRow.add(networkInducedFailureType.getRoleId());
                externalNetworkFailuresTableRow.add(networkInducedFailureType.getSignatureName());
                externalNetworkFailuresTableRow.add(networkInducedFailureType.getCommLinkResourceTypeName());
                externalNetworkFailuresTableRow.add(doApproximate ? this.getFormattedProbabilityAsString(failureProbability, failureProbability + 1.0 - cumulatedPhysicalStateProbability) : this.getFormattedProbabilityAsString(failureProbability));
                externalNetworkFailuresTable.addRow(externalNetworkFailuresTableRow);
                continue;
            }
            if (failureType instanceof MarkovSoftwareInducedFailureType) {
                softwareInducedFailureType = (MarkovSoftwareInducedFailureType)failureType;
                ArrayList<String> internalSoftwareFailuresTableRow = new ArrayList<String>(internalSoftwareFailuresTableHeaderRow.size());
                internalSoftwareFailuresTableRow.add(softwareInducedFailureType.getComponentName());
                internalSoftwareFailuresTableRow.add(softwareInducedFailureType.getInterfaceName());
                internalSoftwareFailuresTableRow.add(softwareInducedFailureType.getSignatureName());
                internalSoftwareFailuresTableRow.add(softwareInducedFailureType.getInternalActionName());
                internalSoftwareFailuresTableRow.add(softwareInducedFailureType.getInternalActionId());
                internalSoftwareFailuresTableRow.add(softwareInducedFailureType.getSoftwareFailureName());
                internalSoftwareFailuresTableRow.add(doApproximate ? this.getFormattedProbabilityAsString(failureProbability, failureProbability + 1.0 - cumulatedPhysicalStateProbability) : this.getFormattedProbabilityAsString(failureProbability));
                internalSoftwareFailuresTable.addRow(internalSoftwareFailuresTableRow);
                continue;
            }
            if (failureType instanceof MarkovHardwareInducedFailureType) {
                hardwareInducedFailureType = (MarkovHardwareInducedFailureType)failureType;
                ArrayList<String> internalHardwareFailuresTableRow = new ArrayList<String>(internalHardwareFailuresTableHeaderRow.size());
                internalHardwareFailuresTableRow.add(hardwareInducedFailureType.getResourceContainerName());
                internalHardwareFailuresTableRow.add(hardwareInducedFailureType.getResourceContainerId());
                internalHardwareFailuresTableRow.add(hardwareInducedFailureType.getResourceTypeName());
                internalHardwareFailuresTableRow.add(doApproximate ? this.getFormattedProbabilityAsString(failureProbability, failureProbability + 1.0 - cumulatedPhysicalStateProbability) : this.getFormattedProbabilityAsString(failureProbability));
                internalHardwareFailuresTable.addRow(internalHardwareFailuresTableRow);
                continue;
            }
            if (!(failureType instanceof MarkovNetworkInducedFailureType)) continue;
            networkInducedFailureType = (MarkovNetworkInducedFailureType)failureType;
            ArrayList<String> internalNetworkFailuresTableRow = new ArrayList<String>(internalNetworkFailuresTableHeaderRow.size());
            internalNetworkFailuresTableRow.add(networkInducedFailureType.getLinkingResourceName());
            internalNetworkFailuresTableRow.add(networkInducedFailureType.getLinkingResourceId());
            internalNetworkFailuresTableRow.add(networkInducedFailureType.getCommLinkResourceTypeName());
            internalNetworkFailuresTableRow.add(doApproximate ? this.getFormattedProbabilityAsString(failureProbability, failureProbability + 1.0 - cumulatedPhysicalStateProbability) : this.getFormattedProbabilityAsString(failureProbability));
            internalNetworkFailuresTable.addRow(internalNetworkFailuresTableRow);
        }
        if (internalSoftwareFailuresTable.getRows().size() > 0) {
            markovReportItem.addFailureModeTable(internalSoftwareFailuresTable);
        }
        if (internalHardwareFailuresTable.getRows().size() > 0) {
            markovReportItem.addFailureModeTable(internalHardwareFailuresTable);
        }
        if (internalNetworkFailuresTable.getRows().size() > 0) {
            markovReportItem.addFailureModeTable(internalNetworkFailuresTable);
        }
        if (externalSoftwareFailuresTable.getRows().size() > 0) {
            markovReportItem.addFailureModeTable(externalSoftwareFailuresTable);
        }
        if (externalHardwareFailuresTable.getRows().size() > 0) {
            markovReportItem.addFailureModeTable(externalHardwareFailuresTable);
        }
        if (externalNetworkFailuresTable.getRows().size() > 0) {
            markovReportItem.addFailureModeTable(externalNetworkFailuresTable);
        }
    }

    private void createTypesFailureAnalysisTable(Map<MarkovFailureType, Double> cumulatedFailureTypeProbabilities, double cumulatedPhysicalStateProbability, boolean doApproximate, MarkovReportItem markovReportItem) {
        MarkovReportingTable softwareInducedFailuresTable = new MarkovReportingTable("Software-induced failure modes");
        ArrayList<String> softwareInducedFailuresTableHeaderRow = new ArrayList<String>(2);
        softwareInducedFailuresTableHeaderRow.add("Failure Type");
        softwareInducedFailuresTableHeaderRow.add("Failure Mode Probability");
        softwareInducedFailuresTable.setHeaderRow(softwareInducedFailuresTableHeaderRow);
        MarkovReportingTable hardwareInducedFailuresTable = new MarkovReportingTable("Hardware-induced failure modes");
        ArrayList<String> hardwareInducedFailuresTableHeaderRow = new ArrayList<String>(2);
        hardwareInducedFailuresTableHeaderRow.add("Resource Type");
        hardwareInducedFailuresTableHeaderRow.add("Failure Mode Probability");
        hardwareInducedFailuresTable.setHeaderRow(hardwareInducedFailuresTableHeaderRow);
        MarkovReportingTable networkInducedFailuresTable = new MarkovReportingTable("Network-induced failure modes");
        ArrayList<String> networkInducedFailuresTableHeaderRow = new ArrayList<String>(2);
        networkInducedFailuresTableHeaderRow.add("Communication Resource Type");
        networkInducedFailuresTableHeaderRow.add("Failure Mode Probability");
        networkInducedFailuresTable.setHeaderRow(networkInducedFailuresTableHeaderRow);
        ArrayList<TypesFailureProbabilityAggregation> failureProbabilityAggregations = new ArrayList<TypesFailureProbabilityAggregation>();
        for (MarkovFailureType type : cumulatedFailureTypeProbabilities.keySet()) {
            boolean foundEntry;
            if (type.isSystemExternal()) continue;
            if (type instanceof MarkovSoftwareInducedFailureType) {
                MarkovSoftwareInducedFailureType softwareInducedFailureType = (MarkovSoftwareInducedFailureType)type;
                foundEntry = false;
                for (TypesFailureProbabilityAggregation aggregation : failureProbabilityAggregations) {
                    if (!aggregation.compareTo(FailureAnalysisFailureType.SOFTWARE_INDUCED, softwareInducedFailureType.getSoftwareFailureName())) continue;
                    aggregation.addToFailureProbability(cumulatedFailureTypeProbabilities.get(softwareInducedFailureType));
                    foundEntry = true;
                    break;
                }
                if (foundEntry) continue;
                failureProbabilityAggregations.add(new TypesFailureProbabilityAggregation(FailureAnalysisFailureType.SOFTWARE_INDUCED, softwareInducedFailureType.getSoftwareFailureName(), cumulatedFailureTypeProbabilities.get(softwareInducedFailureType)));
                continue;
            }
            if (type instanceof MarkovHardwareInducedFailureType) {
                MarkovHardwareInducedFailureType hardwareInducedFailureType = (MarkovHardwareInducedFailureType)type;
                foundEntry = false;
                for (TypesFailureProbabilityAggregation aggregation : failureProbabilityAggregations) {
                    if (!aggregation.compareTo(FailureAnalysisFailureType.HARDWARE_INDUCED, hardwareInducedFailureType.getResourceTypeName())) continue;
                    aggregation.addToFailureProbability(cumulatedFailureTypeProbabilities.get(hardwareInducedFailureType));
                    foundEntry = true;
                    break;
                }
                if (foundEntry) continue;
                failureProbabilityAggregations.add(new TypesFailureProbabilityAggregation(FailureAnalysisFailureType.HARDWARE_INDUCED, hardwareInducedFailureType.getResourceTypeName(), cumulatedFailureTypeProbabilities.get(hardwareInducedFailureType)));
                continue;
            }
            if (!(type instanceof MarkovNetworkInducedFailureType)) continue;
            MarkovNetworkInducedFailureType networkInducedFailureType = (MarkovNetworkInducedFailureType)type;
            foundEntry = false;
            for (TypesFailureProbabilityAggregation aggregation : failureProbabilityAggregations) {
                if (!aggregation.compareTo(FailureAnalysisFailureType.NETWORK_INDUCED, networkInducedFailureType.getCommLinkResourceTypeName())) continue;
                aggregation.addToFailureProbability(cumulatedFailureTypeProbabilities.get(networkInducedFailureType));
                foundEntry = true;
                break;
            }
            if (foundEntry) continue;
            failureProbabilityAggregations.add(new TypesFailureProbabilityAggregation(FailureAnalysisFailureType.NETWORK_INDUCED, networkInducedFailureType.getCommLinkResourceTypeName(), cumulatedFailureTypeProbabilities.get(networkInducedFailureType)));
        }
        for (TypesFailureProbabilityAggregation aggregation : failureProbabilityAggregations) {
            double failureProbability = aggregation.getFailureProbability();
            if (!(failureProbability > 0.0)) continue;
            switch (aggregation.getType()) {
                case SOFTWARE_INDUCED: {
                    ArrayList<String> softwareInducedFailuresTableRow = new ArrayList<String>(2);
                    softwareInducedFailuresTableRow.add(aggregation.getTypeIdentifier());
                    softwareInducedFailuresTableRow.add(String.valueOf(doApproximate ? this.getFormattedProbabilityAsString(failureProbability, failureProbability + 1.0 - cumulatedPhysicalStateProbability) : this.getFormattedProbabilityAsString(failureProbability)));
                    softwareInducedFailuresTable.addRow(softwareInducedFailuresTableRow);
                    break;
                }
                case HARDWARE_INDUCED: {
                    ArrayList<String> hardwareInducedFailuresTableRow = new ArrayList<String>(2);
                    hardwareInducedFailuresTableRow.add(aggregation.getTypeIdentifier());
                    hardwareInducedFailuresTableRow.add(String.valueOf(doApproximate ? this.getFormattedProbabilityAsString(failureProbability, failureProbability + 1.0 - cumulatedPhysicalStateProbability) : this.getFormattedProbabilityAsString(failureProbability)));
                    hardwareInducedFailuresTable.addRow(hardwareInducedFailuresTableRow);
                    break;
                }
                case NETWORK_INDUCED: {
                    ArrayList<String> networkInducedFailuresTableRow = new ArrayList<String>(2);
                    networkInducedFailuresTableRow.add(aggregation.getTypeIdentifier());
                    networkInducedFailuresTableRow.add(String.valueOf(doApproximate ? this.getFormattedProbabilityAsString(failureProbability, failureProbability + 1.0 - cumulatedPhysicalStateProbability) : this.getFormattedProbabilityAsString(failureProbability)));
                    networkInducedFailuresTable.addRow(networkInducedFailuresTableRow);
                    break;
                }
            }
        }
        if (softwareInducedFailuresTable.getRows().size() > 0) {
            markovReportItem.addFailureModeTable(softwareInducedFailuresTable);
        }
        if (hardwareInducedFailuresTable.getRows().size() > 0) {
            markovReportItem.addFailureModeTable(hardwareInducedFailuresTable);
        }
        if (networkInducedFailuresTable.getRows().size() > 0) {
            markovReportItem.addFailureModeTable(networkInducedFailuresTable);
        }
    }

    private double getFailureTypeProbability(MarkovFailureType failureType, Map<MarkovFailureType, Double> cumulatedFailureTypeProbabilities) {
        Double failureTypeProbability = cumulatedFailureTypeProbabilities.get(failureType);
        return failureTypeProbability == null ? 0.0 : failureTypeProbability;
    }

    private TreeSet<MarkovFailureType> getFailureTypesSorted(Map<MarkovFailureType, Double> cumulatedFailureTypeProbabilities) {
        TreeSet<MarkovFailureType> result = new TreeSet<MarkovFailureType>();
        for (MarkovFailureType failureType : cumulatedFailureTypeProbabilities.keySet()) {
            result.add(failureType);
        }
        return result;
    }

    private String getFormattedProbabilityAsString(double probability) {
        return String.format("%1$.11f", probability);
    }

    private String getFormattedProbabilityAsString(double lowerBound, double upperBound) {
        MarkovResultApproximation approximation = new MarkovResultApproximation(lowerBound, upperBound);
        int places = approximation.getAccuracy() + 1;
        return String.format("%1$." + places + "f - %2$." + places + "f", approximation.getAdjustedLowerBound(), approximation.getAdjustedUpperBound());
    }

    public List<MarkovReportItem> getMarkovReportItems() {
        return this.markovReportItems;
    }
}

