/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.reliability.sensitivity;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.resourceenvironment.CommunicationLinkResourceSpecification;
import org.palladiosimulator.pcm.resourceenvironment.ResourceEnvironment;
import org.palladiosimulator.pcm.resourceenvironment.ResourceenvironmentFactory;
import org.palladiosimulator.reliability.sensitivity.DoubleParameterVariation;
import org.palladiosimulator.reliability.sensitivity.SensitivityParameterVariation;
import org.palladiosimulator.solver.reliability.sensitivity.MarkovSensitivity;

public class NetworkSensitivity
extends MarkovSensitivity {
    private List<Double> baseValues = null;
    private List<CommunicationLinkResourceSpecification> resources = null;

    public NetworkSensitivity(String name, DoubleParameterVariation variation) {
        super(name, (SensitivityParameterVariation)variation);
    }

    @Override
    protected boolean alterModel() {
        int i = 0;
        while (i < this.resources.size()) {
            this.resources.get(i).setFailureProbability(this.calculator.calculateCurrentDoubleValue(this.getDoubleVariation(), this.getCurrentStepNumber(), this.baseValues.get(i)));
            ++i;
        }
        return true;
    }

    @Override
    protected void extractSensitivityInformation() {
        this.resources = new BasicEList();
        this.baseValues = new ArrayList<Double>();
        ResourceEnvironment resourceEnvironment = this.getModel().getResourceEnvironment();
        if (resourceEnvironment == null) {
            LOGGER.error((Object)"No PCM ResourceEnvironment found.");
            return;
        }
        EList commResources = this.helper.getElements((EObject)resourceEnvironment, ResourceenvironmentFactory.eINSTANCE.createCommunicationLinkResourceSpecification().eClass());
        for (EObject object : commResources) {
            this.resources.add((CommunicationLinkResourceSpecification)object);
            this.baseValues.add(((CommunicationLinkResourceSpecification)object).getFailureProbability());
        }
        if (this.resources.size() == 0) {
            LOGGER.error((Object)"Did not find any CommunicationLinkResourceSpecifications in the PCM ResourceEnvironment");
        }
    }

    @Override
    protected List<List<String>> getLogHeadingsMulti() {
        ArrayList<List<String>> resultList = new ArrayList<List<String>>();
        ArrayList<String> headings = new ArrayList<String>();
        headings.add("Network Failure Probabilities");
        resultList.add(headings);
        return resultList;
    }

    @Override
    protected List<String> getLogSingleResultsMulti() {
        ArrayList<String> resultList = new ArrayList<String>();
        resultList.add(this.calculator.getCurrentLogEntry((SensitivityParameterVariation)this.getDoubleVariation(), this.getCurrentStepNumber()));
        return resultList;
    }
}

