/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.reliability.sensitivity;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.resourceenvironment.ProcessingResourceSpecification;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.resourceenvironment.ResourceenvironmentFactory;
import org.palladiosimulator.reliability.sensitivity.DoubleParameterVariation;
import org.palladiosimulator.reliability.sensitivity.SensitivityParameterVariation;
import org.palladiosimulator.solver.reliability.sensitivity.MarkovSensitivity;

public class ResourceMTTFSensitivity
extends MarkovSensitivity {
    private double baseValue;
    private String processingResourceTypeId;
    private String resourceContainerId;
    private ProcessingResourceSpecification specification = null;

    public ResourceMTTFSensitivity(String name, String resourceContainerId, String processingResourceTypeId, DoubleParameterVariation variation) {
        super(name, (SensitivityParameterVariation)variation);
        this.resourceContainerId = resourceContainerId;
        this.processingResourceTypeId = processingResourceTypeId;
    }

    @Override
    protected boolean alterModel() {
        if (this.specification == null) {
            return false;
        }
        this.specification.setMTTF(this.calculator.calculateCurrentDoubleValue(this.getDoubleVariation(), this.getCurrentStepNumber(), this.baseValue));
        return true;
    }

    @Override
    protected void extractSensitivityInformation() {
        if (this.getModel().getResourceEnvironment() == null) {
            LOGGER.error((Object)"No PCM ResourceEnvironment found.");
            return;
        }
        ResourceContainer resourceContainer = null;
        EList resourceContainers = this.helper.getElements((EObject)this.getModel().getResourceEnvironment(), ResourceenvironmentFactory.eINSTANCE.createResourceContainer().eClass());
        for (EObject object : resourceContainers) {
            if (!((ResourceContainer)object).getId().equals(this.resourceContainerId)) continue;
            resourceContainer = (ResourceContainer)object;
            break;
        }
        if (resourceContainer == null) {
            LOGGER.error((Object)("Did not find any ResourceContainer with ID \"" + this.resourceContainerId + "\""));
            return;
        }
        for (ProcessingResourceSpecification resourceSpecification : resourceContainer.getActiveResourceSpecifications_ResourceContainer()) {
            if (!resourceSpecification.getActiveResourceType_ActiveResourceSpecification().getId().equals(this.processingResourceTypeId)) continue;
            this.specification = resourceSpecification;
            return;
        }
        if (this.specification == null) {
            LOGGER.error((Object)("Did not find any ProcessingResourceSpecification with ID \"" + this.processingResourceTypeId + "\""));
        }
    }

    @Override
    protected List<List<String>> getLogHeadingsMulti() {
        ArrayList<List<String>> resultList = new ArrayList<List<String>>();
        ArrayList<String> headings = new ArrayList<String>();
        headings.add("Resource Container Name");
        headings.add("Resource Container ID");
        headings.add("Resource Type Name");
        headings.add("Resourcce Type ID");
        headings.add("Mean Time To Failure");
        resultList.add(headings);
        return resultList;
    }

    @Override
    protected List<String> getLogSingleResultsMulti() {
        ArrayList<String> resultList = new ArrayList<String>();
        resultList.add(this.specification.getResourceContainer_ProcessingResourceSpecification().getEntityName());
        resultList.add(this.resourceContainerId);
        resultList.add(this.specification.getActiveResourceType_ActiveResourceSpecification().getEntityName());
        resultList.add(this.processingResourceTypeId);
        resultList.add(this.calculator.getCurrentLogEntry((SensitivityParameterVariation)this.getDoubleVariation(), this.getCurrentStepNumber()));
        return resultList;
    }
}

