/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.reliability.sensitivity;

import de.uka.ipd.sdq.stoex.AbstractNamedReference;
import de.uka.ipd.sdq.stoex.NamespaceReference;
import de.uka.ipd.sdq.stoex.VariableReference;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.core.PCMRandomVariable;
import org.palladiosimulator.pcm.parameter.VariableCharacterisation;
import org.palladiosimulator.pcm.parameter.VariableCharacterisationType;
import org.palladiosimulator.pcm.parameter.VariableUsage;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.repository.RepositoryFactory;
import org.palladiosimulator.pcm.usagemodel.EntryLevelSystemCall;
import org.palladiosimulator.pcm.usagemodel.UsagemodelFactory;
import org.palladiosimulator.reliability.sensitivity.SensitivityParameterVariation;
import org.palladiosimulator.reliability.sensitivity.StringParameterSequence;
import org.palladiosimulator.reliability.sensitivity.VariableUsageType;
import org.palladiosimulator.solver.reliability.sensitivity.MarkovSensitivity;

public class VariableUsageSensitivity
extends MarkovSensitivity {
    private VariableCharacterisationType characterisationType;
    private String elementId;
    private String elementName;
    private String parameterName;
    private VariableUsageType parameterType;
    private PCMRandomVariable variable = null;

    public VariableUsageSensitivity(String name, String elementId, String parameterName, VariableCharacterisationType characterisationType, VariableUsageType parameterType, StringParameterSequence sequence) {
        super(name, (SensitivityParameterVariation)sequence);
        this.elementId = elementId;
        this.parameterName = parameterName;
        this.characterisationType = characterisationType;
        this.parameterType = parameterType;
    }

    @Override
    protected boolean alterModel() {
        if (this.variable == null) {
            return false;
        }
        this.variable.setSpecification(this.calculator.calculateCurrentStringValue(this.getStringSequence(), this.getCurrentStepNumber()));
        return true;
    }

    private boolean checkParameterName(AbstractNamedReference reference, String[] paramName, int index) {
        if (!reference.getReferenceName().equals(paramName[index])) {
            return false;
        }
        if (reference instanceof VariableReference) {
            return paramName.length == index + 1;
        }
        return this.checkParameterName(((NamespaceReference)reference).getInnerReference_NamespaceReference(), paramName, index + 1);
    }

    private void extractComponentParameter() {
        List repositories = this.getModel().getRepositories();
        if (repositories.size() == 0) {
            LOGGER.error((Object)"No PCM Repositories found.");
            return;
        }
        BasicComponent component = null;
        for (Repository repository : repositories) {
            EList components = this.helper.getElements((EObject)repository, RepositoryFactory.eINSTANCE.createBasicComponent().eClass());
            for (EObject object : components) {
                if (!((BasicComponent)object).getId().equals(this.elementId)) continue;
                component = (BasicComponent)object;
                break;
            }
            if (component != null) break;
        }
        if (component == null) {
            LOGGER.error((Object)("No BasicComponent with ID \"" + this.elementId + "\" found."));
            return;
        }
        this.elementName = component.getEntityName();
        this.extractVariable((EList<VariableUsage>)component.getComponentParameterUsage_ImplementationComponentType());
    }

    @Override
    protected void extractSensitivityInformation() {
        switch (this.parameterType) {
            case SYSTEM_CALL_INPUT: {
                this.extractSystemCallInput();
                return;
            }
            case COMPONENT_CONFIGURATION: {
                this.extractComponentParameter();
                return;
            }
        }
    }

    private void extractSystemCallInput() {
        if (this.getModel().getUsageModel() == null) {
            LOGGER.error((Object)"No PCM UsageModel found.");
            return;
        }
        EntryLevelSystemCall systemCall = null;
        EList systemCalls = this.helper.getElements((EObject)this.getModel().getUsageModel(), UsagemodelFactory.eINSTANCE.createEntryLevelSystemCall().eClass());
        for (EObject object : systemCalls) {
            if (!((EntryLevelSystemCall)object).getId().equals(this.elementId)) continue;
            systemCall = (EntryLevelSystemCall)object;
            break;
        }
        if (systemCall == null) {
            LOGGER.error((Object)("No EntryLevelSystemCall with ID \"" + this.elementId + "\" found."));
            return;
        }
        this.elementName = systemCall.getEntityName();
        this.extractVariable((EList<VariableUsage>)systemCall.getInputParameterUsages_EntryLevelSystemCall());
    }

    private void extractVariable(EList<VariableUsage> parameterUsages) {
        for (VariableUsage usage : parameterUsages) {
            if (!this.checkParameterName(usage.getNamedReference__VariableUsage(), this.parameterName.split("\\."), 0)) continue;
            for (VariableCharacterisation characterisation : usage.getVariableCharacterisation_VariableUsage()) {
                if (!characterisation.getType().equals((Object)this.characterisationType)) continue;
                this.variable = characterisation.getSpecification_VariableCharacterisation();
                return;
            }
        }
        if (this.variable == null) {
            LOGGER.error((Object)("Did not find any PCMRandomVariable for parameter \"" + this.parameterName + "." + this.characterisationType.getName()));
        }
    }

    @Override
    protected List<List<String>> getLogHeadingsMulti() {
        ArrayList<List<String>> resultList = new ArrayList<List<String>>();
        String elementNameHeader = null;
        String elementIDHeader = null;
        switch (this.parameterType) {
            case SYSTEM_CALL_INPUT: {
                elementNameHeader = "System Call Name";
                elementIDHeader = "System Call ID";
                break;
            }
            case COMPONENT_CONFIGURATION: {
                elementNameHeader = "Component Name";
                elementIDHeader = "Component ID";
            }
        }
        ArrayList<String> headings = new ArrayList<String>();
        headings.add(elementNameHeader);
        headings.add(elementIDHeader);
        headings.add("Parameter Name");
        headings.add("Parameter Characterisation");
        headings.add("Parameter Specification");
        resultList.add(headings);
        return resultList;
    }

    @Override
    protected List<String> getLogSingleResultsMulti() {
        ArrayList<String> resultList = new ArrayList<String>();
        resultList.add(this.elementName);
        resultList.add(this.elementId);
        resultList.add(this.parameterName);
        resultList.add(this.characterisationType.getName());
        resultList.add(this.calculator.getCurrentLogEntry((SensitivityParameterVariation)this.getStringSequence(), this.getCurrentStepNumber()));
        return resultList;
    }
}

