/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.reliability.visualisation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.palladiosimulator.solver.reliability.reporting.MarkovReportItem;
import org.palladiosimulator.solver.reliability.reporting.MarkovReporting;
import org.palladiosimulator.solver.reliability.reporting.MarkovReportingTable;

public class MarkovHtmlGenerator {
    private List<MarkovReportItem> markovReportItems;

    public MarkovHtmlGenerator(MarkovReporting markovReporting) {
        this.markovReportItems = markovReporting.getMarkovReportItems();
    }

    public String getHtml() {
        String cssCode = "";
        String jsCode = "";
        try {
            cssCode = this.getInputStreamContents(this.getClass().getResourceAsStream("/jsComponents.css"));
            jsCode = this.getInputStreamContents(this.getClass().getResourceAsStream("/jsComponents.js"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        StringBuilder htmlCode = new StringBuilder("<html><head><title>Markov Results</title><script type=\"text/javascript\">" + jsCode + "</script>" + "<style type=\"text/css\">" + cssCode + "\t\tbody { font-family: Lucida Grande, Arial, Tahoma, Verdana; font-size: 12px; }" + "\t\ttd, th { font-size: 11px; }" + "\t\tth { background-color: c0c0c0; margin: 1px; padding: 3px 5px 3px 5px; border: 1px solid black; }" + "\t\ttd { background-color: dfdfdf; margin: 1px; padding: 3px 5px 3px 5px; }" + "</style>" + "</head><body>");
        for (MarkovReportItem item : this.markovReportItems) {
            htmlCode.append("<h2>Reliability results for UsageScenario: <font color=\"#606060\">" + item.getScenarioName() + "</font></h2>");
            htmlCode.append("Scenario ID: <font color=\"#606060\">" + item.getScenarioId() + "</font><br />");
            htmlCode.append("Success probability: <font color=\"#606060\">" + item.getSuccessProbabilityString() + "</font><br />");
            if (item.getFailureModeTables().size() != 0) {
                htmlCode.append("<hr />");
                htmlCode.append("<h3>Failure Mode Analysis</h3>");
            }
            for (MarkovReportingTable table : item.getFailureModeTables()) {
                if (table.getRows().size() == 0) continue;
                htmlCode.append("<div class=\"JSTableStripe\"><div class=\"JSTableSort\">");
                htmlCode.append("<b>" + table.getTableName() + ":</b><br />");
                htmlCode.append("<table border=\"0\" style=\"margin-top: 1mm; border: 1px solid black;\">");
                htmlCode.append("<thead><tr>");
                for (String string : table.getHeaderRow()) {
                    htmlCode.append("<th class=\"SortString\" onselectstart=\"return false;\">" + string + "</th>");
                }
                htmlCode.append("</tr></thead><tbody>");
                for (List list : table.getRows()) {
                    htmlCode.append("<tr>");
                    for (String entry : list) {
                        htmlCode.append("<td>" + entry + "</td>");
                    }
                    htmlCode.append("</tr>");
                }
                htmlCode.append("</tbody></table>");
                htmlCode.append("</div></div><br />");
            }
            if (item.getImpactAnalysisTables().size() != 0) {
                htmlCode.append("<hr />");
                htmlCode.append("<h3>Impact Analysis</h3>");
                for (MarkovReportingTable table : item.getImpactAnalysisTables()) {
                    if (table.getRows().size() == 0) continue;
                    htmlCode.append("<div class=\"JSTableStripe\"><div class=\"JSTableSort\">");
                    htmlCode.append("<b>" + table.getTableName() + ":</b><br />");
                    htmlCode.append("<table border=\"0\" style=\"margin-top: 1mm; border: 1px solid black;\">");
                    htmlCode.append("<thead><tr>");
                    for (String string : table.getHeaderRow()) {
                        htmlCode.append("<th class=\"SortString\" onselectstart=\"return false;\">" + string + "</th>");
                    }
                    htmlCode.append("</tr></thead><tbody>");
                    for (List list : table.getRows()) {
                        htmlCode.append("<tr>");
                        for (String entry : list) {
                            htmlCode.append("<td>" + entry + "</td>");
                        }
                        htmlCode.append("</tr>");
                    }
                    htmlCode.append("</tbody></table>");
                    htmlCode.append("</div></div><br />");
                }
            }
            htmlCode.append("<hr>");
            htmlCode.append("<hr>");
        }
        htmlCode.append("</body></html>");
        return htmlCode.toString();
    }

    private String getInputStreamContents(InputStream is) throws IOException {
        if (is != null) {
            StringWriter writer = new StringWriter();
            char[] buffer = new char[1024];
            try {
                int n;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                while ((n = reader.read(buffer)) != -1) {
                    ((Writer)writer).write(buffer, 0, n);
                }
            }
            finally {
                is.close();
            }
            return ((Object)writer).toString();
        }
        return "";
    }
}

