/*
 * Decompiled with CFR 0.152.
 */
package org.scaledl.usageevolution.wizard.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.palladiosimulator.pcm.usagemodel.UsageModel;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;
import org.scaledl.usageevolution.Usage;
import org.scaledl.usageevolution.UsageEvolution;
import org.scaledl.usageevolution.UsageevolutionFactory;
import org.scaledl.usageevolution.wizard.wizards.UsageEvolutionSetupModel;
import tools.descartes.dlim.Sequence;

public class UsageEvolutionFileGenerator {
    public static Sequence getLIMBOSequence(ResourceSet resourceSet, UsageEvolutionSetupModel model) {
        try {
            Resource limboResource = resourceSet.getResource(URI.createPlatformResourceURI((String)model.loadLimboFileName, (boolean)false), true);
            Sequence sequence = (Sequence)limboResource.getContents().get(0);
            return sequence;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static UsageScenario getUsageScenario(ResourceSet resourceSet, UsageEvolutionSetupModel model) {
        try {
            Resource usageResource = resourceSet.getResource(URI.createPlatformResourceURI((String)model.usageModelFileName, (boolean)false), true);
            UsageScenario scenario = (UsageScenario)((UsageModel)usageResource.getContents().get(0)).getUsageScenario_UsageModel().get(0);
            return scenario;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static IFile generate(UsageEvolutionSetupModel model) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        try {
            Resource resource = resourceSet.createResource(URI.createPlatformResourceURI((String)model.usageEvolutionFileName, (boolean)false));
            Sequence sequence = UsageEvolutionFileGenerator.getLIMBOSequence((ResourceSet)resourceSet, model);
            UsageScenario scenario = UsageEvolutionFileGenerator.getUsageScenario((ResourceSet)resourceSet, model);
            UsageEvolution evolution = UsageevolutionFactory.eINSTANCE.createUsageEvolution();
            evolution.setEntityName(model.getUsageEvolutionEntityName());
            Usage usage = UsageevolutionFactory.eINSTANCE.createUsage();
            usage.setEntityName(model.getUsageEntityName());
            if (sequence != null) {
                usage.setLoadEvolution(sequence);
            }
            if (scenario != null) {
                usage.setScenario(scenario);
            }
            evolution.getUsages().add((Object)usage);
            resource.getContents().add((Object)evolution);
            resource.save(null);
            String platformString = resource.getURI().toPlatformString(true);
            return (IFile)ResourcesPlugin.getWorkspace().getRoot().findMember(platformString);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

