/*
 * Decompiled with CFR 0.152.
 */
package org.somox.analyzer.simplemodelanalyzer.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.gmt.modisco.java.ASTNode;
import org.eclipse.gmt.modisco.java.Type;
import org.eclipse.modisco.java.composition.javaapplication.JavaNodeSourceRegion;
import org.jgrapht.Graph;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.ComposedStructure;
import org.palladiosimulator.pcm.core.composition.CompositionFactory;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.CompositeComponent;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.repository.RepositoryFactory;
import org.somox.analyzer.AnalysisResult;
import org.somox.analyzer.simplemodelanalyzer.builder.AbstractBuilder;
import org.somox.analyzer.simplemodelanalyzer.builder.AssemblyConnectorBuilder;
import org.somox.analyzer.simplemodelanalyzer.builder.AssemblyConnectorDeFactoStrategy;
import org.somox.analyzer.simplemodelanalyzer.builder.AssemblyConnectorsInsideCompositeComponentStrategy;
import org.somox.analyzer.simplemodelanalyzer.builder.ComponentAndTypeNaming;
import org.somox.analyzer.simplemodelanalyzer.builder.IAssemblyConnectorStrategy;
import org.somox.analyzer.simplemodelanalyzer.builder.IRoleBuilderStrategy;
import org.somox.analyzer.simplemodelanalyzer.builder.InterfaceBuilder;
import org.somox.analyzer.simplemodelanalyzer.builder.NonDuplicatingInterfacePortBuilder;
import org.somox.configuration.SoMoXConfiguration;
import org.somox.kdmhelper.KDMHelper;
import org.somox.kdmhelper.metamodeladdition.Root;
import org.somox.metrics.ClusteringRelation;
import org.somox.sourcecodedecorator.ComponentImplementingClassesLink;
import org.somox.sourcecodedecorator.FileLevelSourceCodeLink;
import org.somox.sourcecodedecorator.SourceCodeDecoratorFactory;

public class ComponentBuilder
extends AbstractBuilder {
    private ComponentAndTypeNaming componentNamingStrategy = null;
    private InterfaceBuilder interfaceBuilder = null;
    private IAssemblyConnectorStrategy assemblyConnectorDeFactoBuilder = null;
    private IAssemblyConnectorStrategy assemblyConnectorInnerBuilder = null;
    private IRoleBuilderStrategy roleBuilder = null;
    private static Logger logger = Logger.getLogger(ComponentBuilder.class);

    public ComponentBuilder(Root gastModel, SoMoXConfiguration somoxConfiguration, AnalysisResult analysisResult) {
        super(gastModel, somoxConfiguration, analysisResult);
        logger.debug((Object)"Initialising PCM model builder");
        this.componentNamingStrategy = new ComponentAndTypeNaming();
        this.interfaceBuilder = new InterfaceBuilder(gastModel, somoxConfiguration, analysisResult);
        AssemblyConnectorBuilder connectorBuilder = new AssemblyConnectorBuilder(gastModel, somoxConfiguration, analysisResult);
        this.assemblyConnectorDeFactoBuilder = new AssemblyConnectorDeFactoStrategy(connectorBuilder);
        this.assemblyConnectorInnerBuilder = new AssemblyConnectorsInsideCompositeComponentStrategy();
        this.roleBuilder = new NonDuplicatingInterfacePortBuilder(gastModel, somoxConfiguration, analysisResult, this.componentNamingStrategy);
        if (somoxConfiguration.isReverseEngineerInterfacesNotAssignedToComponent()) {
            this.interfaceBuilder.reverseEngineerRemainingInterfacesAsFreeFloatingInterfaces(analysisResult, gastModel);
        }
    }

    public ComponentImplementingClassesLink createCompositeComponent(Graph<ComponentImplementingClassesLink, ClusteringRelation> compositeComponentSubgraph) {
        ComponentImplementingClassesLink result = SourceCodeDecoratorFactory.eINSTANCE.createComponentImplementingClassesLink();
        CompositeComponent newComponentType = RepositoryFactory.eINSTANCE.createCompositeComponent();
        String componentName = this.componentNamingStrategy.createCompositeComponentName(compositeComponentSubgraph.vertexSet());
        logger.info((Object)("Creating composite component with name: " + componentName));
        newComponentType.setEntityName(componentName);
        this.createAssemblyContext(compositeComponentSubgraph.vertexSet(), (ComposedStructure)newComponentType);
        result.setComponent((RepositoryComponent)newComponentType);
        result.getSubComponents().addAll((Collection)compositeComponentSubgraph.vertexSet());
        this.analysisResult.getSourceCodeDecoratorRepository().getComponentImplementingClassesLink().add((Object)result);
        this.analysisResult.getInternalArchitectureModel().getComponents__Repository().add((Object)newComponentType);
        this.assemblyConnectorDeFactoBuilder.buildAssemblyConnectors(result, compositeComponentSubgraph);
        this.assemblyConnectorInnerBuilder.buildAssemblyConnectors(result, compositeComponentSubgraph);
        this.roleBuilder.buildProvidedRole(result);
        this.roleBuilder.buildRequiredRole(result);
        return result;
    }

    public List<AssemblyContext> createAssemblyContext(Set<ComponentImplementingClassesLink> subComponents, ComposedStructure newComponentType) {
        ArrayList<AssemblyContext> subComponentInstance = new ArrayList<AssemblyContext>(subComponents.size());
        for (ComponentImplementingClassesLink innerComponent : subComponents) {
            AssemblyContext assemblyContext = CompositionFactory.eINSTANCE.createAssemblyContext();
            assemblyContext.setParentStructure__AssemblyContext(newComponentType);
            assemblyContext.setEncapsulatedComponent__AssemblyContext(innerComponent.getComponent());
            assemblyContext.setEntityName(this.componentNamingStrategy.createComponentInstanceName(innerComponent.getComponent()));
            innerComponent.setIsInitialComponent(false);
        }
        return subComponentInstance;
    }

    public ComponentImplementingClassesLink createMergedComponent(Graph<ComponentImplementingClassesLink, ClusteringRelation> compositeComponentSubgraph) {
        ComponentImplementingClassesLink compositeComponentLink = this.findExistingComposite(compositeComponentSubgraph.vertexSet());
        if (compositeComponentLink != null) {
            logger.trace((Object)"creating merged component CC + children");
            return this.addAsChildPrimitiveComponentToExistingComposite(compositeComponentSubgraph, compositeComponentLink);
        }
        logger.trace((Object)"creating merged single component");
        return this.createSinglePrimitiveComponent(compositeComponentSubgraph);
    }

    public ComponentImplementingClassesLink createPrimitiveComponentFromGASTClass(Type gastClass) {
        ArrayList<Type> singleClassList = new ArrayList<Type>();
        singleClassList.add(gastClass);
        return this.createSinglePrimitiveComponentFromGASTClasses(singleClassList);
    }

    public ComponentImplementingClassesLink createSinglePrimitiveComponentFromGASTClasses(List<Type> gastClasses) {
        ComponentImplementingClassesLink newPrimitiveComponent = SourceCodeDecoratorFactory.eINSTANCE.createComponentImplementingClassesLink();
        return this.createSinglePrimitiveComponentFromGASTClasses(gastClasses, newPrimitiveComponent);
    }

    public ComponentImplementingClassesLink createSinglePrimitiveComponentFromGASTClasses(List<Type> gastClasses, ComponentImplementingClassesLink primitiveComponent) {
        String componentName = this.componentNamingStrategy.createSimpleComponentName(gastClasses, false);
        logger.info((Object)("Creating primitive component " + componentName));
        this.analysisResult.getSourceCodeDecoratorRepository().getComponentImplementingClassesLink().add((Object)primitiveComponent);
        BasicComponent newComponentType = RepositoryFactory.eINSTANCE.createBasicComponent();
        newComponentType.setEntityName(componentName);
        this.analysisResult.getInternalArchitectureModel().getComponents__Repository().add((Object)newComponentType);
        primitiveComponent.setComponent((RepositoryComponent)newComponentType);
        for (Type currentGASTclass : gastClasses) {
            primitiveComponent.getImplementingClasses().addAll(this.getInnerClasses(currentGASTclass, (RepositoryComponent)newComponentType));
        }
        this.interfaceBuilder.findAndAddRequiredInterfaces(primitiveComponent);
        this.interfaceBuilder.addProvidedInterfaces(primitiveComponent);
        this.interfaceBuilder.removeInterfaceSelfAccesses(primitiveComponent);
        return primitiveComponent;
    }

    public ComponentImplementingClassesLink createComponentLinkFromGASTClass(Type gastClass) {
        ComponentImplementingClassesLink newPrimitiveComponent = SourceCodeDecoratorFactory.eINSTANCE.createComponentImplementingClassesLink();
        this.analysisResult.getSourceCodeDecoratorRepository().getComponentImplementingClassesLink().add((Object)newPrimitiveComponent);
        newPrimitiveComponent.getImplementingClasses().addAll(this.getInnerClasses(gastClass));
        return newPrimitiveComponent;
    }

    private ComponentImplementingClassesLink createSinglePrimitiveComponent(Graph<ComponentImplementingClassesLink, ClusteringRelation> compositeComponentSubgraph) {
        logger.trace((Object)"creating single primitive component (merge)");
        BasicEList classesOfPrimitiveComponent = new BasicEList();
        for (ComponentImplementingClassesLink currentComponent : compositeComponentSubgraph.vertexSet()) {
            assert (currentComponent.isInitialComponent());
            classesOfPrimitiveComponent.addAll((Collection)currentComponent.getImplementingClasses());
        }
        ComponentImplementingClassesLink result = SourceCodeDecoratorFactory.eINSTANCE.createComponentImplementingClassesLink();
        result = this.createSinglePrimitiveComponentFromGASTClasses((List<Type>)classesOfPrimitiveComponent);
        return result;
    }

    private ComponentImplementingClassesLink addAsChildPrimitiveComponentToExistingComposite(Graph<ComponentImplementingClassesLink, ClusteringRelation> compositeComponentSubgraph, ComponentImplementingClassesLink compositeComponentLink) {
        for (ComponentImplementingClassesLink innerComponent : compositeComponentSubgraph.vertexSet()) {
            if (!innerComponent.isInitialComponent()) continue;
            ComponentImplementingClassesLink newInnerPrimitiveComponent = this.createSinglePrimitiveComponentFromGASTClasses((List<Type>)innerComponent.getImplementingClasses());
            AssemblyContext assemblyContext = CompositionFactory.eINSTANCE.createAssemblyContext();
            assemblyContext.setEncapsulatedComponent__AssemblyContext(newInnerPrimitiveComponent.getComponent());
            assemblyContext.setEntityName(this.componentNamingStrategy.createComponentInstanceName(newInnerPrimitiveComponent.getComponent()));
            ((CompositeComponent)compositeComponentLink.getComponent()).getAssemblyContexts__ComposedStructure().add((Object)assemblyContext);
            compositeComponentLink.getSubComponents().add((Object)newInnerPrimitiveComponent);
        }
        this.roleBuilder.buildProvidedRole(compositeComponentLink);
        this.roleBuilder.buildRequiredRole(compositeComponentLink);
        this.assemblyConnectorDeFactoBuilder.buildAssemblyConnectors(compositeComponentLink, compositeComponentSubgraph);
        this.assemblyConnectorInnerBuilder.buildAssemblyConnectors(compositeComponentLink, compositeComponentSubgraph);
        return compositeComponentLink;
    }

    private ComponentImplementingClassesLink findExistingComposite(Set<ComponentImplementingClassesLink> componentLinks) {
        assert (this.assertOnlyASingleComposite(componentLinks));
        for (ComponentImplementingClassesLink innerComponent : componentLinks) {
            if (!innerComponent.isCompositeComponent()) continue;
            return innerComponent;
        }
        return null;
    }

    private boolean assertOnlyASingleComposite(Set<ComponentImplementingClassesLink> componentLinks) {
        int compositeCount = 0;
        for (ComponentImplementingClassesLink innerComponent : componentLinks) {
            if (!(innerComponent instanceof CompositeComponent)) continue;
            ++compositeCount;
        }
        return compositeCount <= 1;
    }

    private Set<Type> getInnerClasses(Type element, RepositoryComponent newComponentType) {
        HashSet<Type> currentList = new HashSet<Type>();
        currentList.add(element);
        this.storeFileLocationInSourceCodeDecorator(element, newComponentType);
        List innerClasses = KDMHelper.getInnerClasses((Type)element);
        if (innerClasses != null) {
            currentList.addAll(innerClasses);
        }
        for (Type innerClass : innerClasses) {
            currentList.addAll(this.getInnerClasses(innerClass, newComponentType));
        }
        return currentList;
    }

    private Set<Type> getInnerClasses(Type element) {
        HashSet<Type> currentList = new HashSet<Type>();
        currentList.add(element);
        List innerClasses = KDMHelper.getInnerClasses((Type)element);
        if (innerClasses != null) {
            currentList.addAll(innerClasses);
        }
        for (Type innerClass : innerClasses) {
            currentList.addAll(this.getInnerClasses(innerClass));
        }
        return currentList;
    }

    private void storeFileLocationInSourceCodeDecorator(Type gastClass, RepositoryComponent newComponent) {
        FileLevelSourceCodeLink link = SourceCodeDecoratorFactory.eINSTANCE.createFileLevelSourceCodeLink();
        link.setRepositoryComponent(newComponent);
        if (KDMHelper.getJavaNodeSourceRegion((ASTNode)gastClass) != null && KDMHelper.getSourceFile((JavaNodeSourceRegion)KDMHelper.getJavaNodeSourceRegion((ASTNode)gastClass)) != null) {
            link.setFile(KDMHelper.getSourceFile((JavaNodeSourceRegion)KDMHelper.getJavaNodeSourceRegion((ASTNode)gastClass)));
        }
        this.analysisResult.getSourceCodeDecoratorRepository().getFileLevelSourceCodeLink().add((Object)link);
    }

    public void updateRequiredInterfacesOfExistingPrimitiveComponents() {
        this.interfaceBuilder.updateRequiredInterfacesOfExistingPrimitiveComponents();
    }

    public InterfaceBuilder getInterfaceBuilder() {
        return this.interfaceBuilder;
    }

    public ComponentAndTypeNaming getComponentAndTypeNamingStrategy() {
        return this.componentNamingStrategy;
    }

    public IAssemblyConnectorStrategy getInsideCompositeComponentAssemblyConnectorStrategy() {
        return this.assemblyConnectorInnerBuilder;
    }
}

