/*
 * Decompiled with CFR 0.152.
 */
package org.somox.analyzer.simplemodelanalyzer.builder;

import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gmt.modisco.java.ASTNode;
import org.eclipse.gmt.modisco.java.AbstractMethodDeclaration;
import org.eclipse.gmt.modisco.java.ArrayType;
import org.eclipse.gmt.modisco.java.MethodDeclaration;
import org.eclipse.gmt.modisco.java.PrimitiveTypeVoid;
import org.eclipse.gmt.modisco.java.SingleVariableDeclaration;
import org.eclipse.gmt.modisco.java.Type;
import org.eclipse.gmt.modisco.java.VisibilityKind;
import org.eclipse.modisco.java.composition.javaapplication.JavaNodeSourceRegion;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.repository.CollectionDataType;
import org.palladiosimulator.pcm.repository.CompositeDataType;
import org.palladiosimulator.pcm.repository.DataType;
import org.palladiosimulator.pcm.repository.InnerDeclaration;
import org.palladiosimulator.pcm.repository.OperationInterface;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.Parameter;
import org.palladiosimulator.pcm.repository.PrimitiveDataType;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.repository.RepositoryFactory;
import org.palladiosimulator.pcm.repository.Signature;
import org.somox.analyzer.AnalysisResult;
import org.somox.analyzer.simplemodelanalyzer.builder.AbstractBuilder;
import org.somox.analyzer.simplemodelanalyzer.builder.util.DefaultResourceEnvironment;
import org.somox.configuration.SoMoXConfiguration;
import org.somox.kdmhelper.GetAccessedType;
import org.somox.kdmhelper.KDMHelper;
import org.somox.kdmhelper.metamodeladdition.Root;
import org.somox.sourcecodedecorator.MethodLevelSourceCodeLink;
import org.somox.sourcecodedecorator.SourceCodeDecoratorFactory;

public class OperationBuilder
extends AbstractBuilder {
    public static final String VOID_TYPE = "void";
    private static final Logger LOGGER = Logger.getLogger(OperationBuilder.class);

    public OperationBuilder(Root kdmModelRoot, SoMoXConfiguration somoxConfiguration, AnalysisResult analysisResult) {
        super(kdmModelRoot, somoxConfiguration, analysisResult);
    }

    public void createOperations(Type interfaceClass, OperationInterface interf) {
        for (MethodDeclaration method : KDMHelper.getMethods((Type)interfaceClass)) {
            if (!KDMHelper.isModifierOfKind((MethodDeclaration)method, (VisibilityKind)VisibilityKind.NONE) && !KDMHelper.isModifierOfKind((MethodDeclaration)method, (VisibilityKind)VisibilityKind.PUBLIC)) continue;
            MethodDeclaration realMethod = method;
            OperationSignature op = this.createOperationSignature(realMethod, interf);
            interf.getSignatures__OperationInterface().add((Object)op);
        }
    }

    private MethodDeclaration getRealMethod(Type implementationClass, MethodDeclaration inputMethod) {
        assert (implementationClass != null);
        for (MethodDeclaration methodFromClass : KDMHelper.getMethods((Type)implementationClass)) {
            if (methodFromClass == inputMethod) {
                return methodFromClass;
            }
            if (!methodFromClass.getName().equals(inputMethod.getName())) continue;
            MethodDeclaration overrideMethod = KDMHelper.getOverriddenMember((MethodDeclaration)methodFromClass);
            while (overrideMethod != null) {
                if (overrideMethod == inputMethod) {
                    return methodFromClass;
                }
                overrideMethod = KDMHelper.getOverriddenMember((MethodDeclaration)overrideMethod);
            }
        }
        for (Type superClass : KDMHelper.getSuperTypes((Type)implementationClass)) {
            MethodDeclaration real;
            if (KDMHelper.isAbstract((Type)superClass) || KDMHelper.isInterface((ASTNode)superClass) || (real = this.getRealMethod(superClass, inputMethod)) == null) continue;
            return real;
        }
        return null;
    }

    private OperationSignature createOperationSignature(MethodDeclaration method, OperationInterface interf) {
        OperationSignature operation = RepositoryFactory.eINSTANCE.createOperationSignature();
        String nameForMethod = this.createNonExistingNameInInterface(method, interf);
        operation.setEntityName(nameForMethod);
        this.updateSourceCodeDecorator(operation, method);
        for (SingleVariableDeclaration inputParameter : method.getParameters()) {
            Parameter opSigParam = RepositoryFactory.eINSTANCE.createParameter();
            opSigParam.setParameterName(inputParameter.getName());
            if (inputParameter.getType() == null || inputParameter.getType().getType() == null) {
                LOGGER.error((Object)("Input parameter type was null. Could not set the parameter type \"" + inputParameter.getName() + "\" of method \"" + method.getName() + "\""));
                continue;
            }
            opSigParam.setDataType__Parameter(this.getType(GetAccessedType.getAccessedType((ASTNode)inputParameter.getType()), this.analysisResult.getInternalArchitectureModel()));
            opSigParam.setOperationSignature__Parameter(operation);
        }
        if (method.getReturnType() != null && method.getReturnType().getType() != null && !(method.getReturnType().getType() instanceof PrimitiveTypeVoid)) {
            operation.setReturnType__OperationSignature(this.getType(GetAccessedType.getAccessedType((ASTNode)method.getReturnType()), this.analysisResult.getInternalArchitectureModel()));
        }
        return operation;
    }

    private String createNonExistingNameInInterface(MethodDeclaration method, OperationInterface interf) {
        String methodName = method.getName();
        if (!this.containsName(interf, methodName)) {
            return methodName;
        }
        int counter = 1;
        while (this.containsName(interf, this.createMethodNameWithNumber(methodName, counter))) {
            ++counter;
        }
        return this.createMethodNameWithNumber(methodName, counter);
    }

    private String createMethodNameWithNumber(String methodName, int counter) {
        return String.valueOf(methodName) + "_" + counter;
    }

    private boolean containsName(OperationInterface interf, String methodName) {
        EList signatures = interf.getSignatures__OperationInterface();
        for (OperationSignature signature : signatures) {
            if (!signature.getEntityName().equals(methodName)) continue;
            return true;
        }
        return false;
    }

    private void updateSourceCodeDecorator(OperationSignature operation, MethodDeclaration method) {
        MethodLevelSourceCodeLink link = SourceCodeDecoratorFactory.eINSTANCE.createMethodLevelSourceCodeLink();
        link.setFunction((AbstractMethodDeclaration)method);
        link.setOperation((Signature)operation);
        if (KDMHelper.getJavaNodeSourceRegion((ASTNode)method) != null && KDMHelper.getSourceFile((JavaNodeSourceRegion)KDMHelper.getJavaNodeSourceRegion((ASTNode)method)) != null) {
            link.setFile(KDMHelper.getSourceFile((JavaNodeSourceRegion)KDMHelper.getJavaNodeSourceRegion((ASTNode)method)));
        }
        this.analysisResult.getSourceCodeDecoratorRepository().getMethodLevelSourceCodeLink().add((Object)link);
    }

    private DataType getType(Type gastType, Repository repository) {
        DataType type = this.getExistingType(gastType, Arrays.asList(repository, DefaultResourceEnvironment.getPrimitiveTypesRepository()));
        if (type == null) {
            type = this.createDataType(repository, gastType);
        }
        return type;
    }

    private DataType createDataType(Repository repository, Type gastType) {
        String typeName = this.getUnifiedTypeName(gastType.getName());
        CollectionDataType newType = null;
        if (!typeName.toLowerCase().equals(VOID_TYPE)) {
            if (gastType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)gastType;
                newType = RepositoryFactory.eINSTANCE.createCollectionDataType();
                newType.setEntityName(typeName);
                repository.getDataTypes__Repository().add((Object)newType);
                LOGGER.debug((Object)("found collection type " + typeName));
                DataType innerType = this.getType(arrayType.getElementType().getType(), repository);
                if (innerType == null) {
                    LOGGER.error((Object)("Unsupported inner type: " + arrayType.getElementType().getType()));
                }
                newType.setInnerType_CollectionDataType(innerType);
            } else {
                CompositeDataType compositeDataType = RepositoryFactory.eINSTANCE.createCompositeDataType();
                repository.getDataTypes__Repository().add((Object)compositeDataType);
                compositeDataType.setEntityName(gastType.getName());
                newType = compositeDataType;
                for (Type currentClass : KDMHelper.getAllAccessedClasses((Type)gastType)) {
                    if (currentClass.equals(gastType) || currentClass.getName().equals(VOID_TYPE)) continue;
                    String tmpInnerTypeName = currentClass.getName();
                    InnerDeclaration innerElement = RepositoryFactory.eINSTANCE.createInnerDeclaration();
                    innerElement.setDatatype_InnerDeclaration(this.getType(currentClass, repository));
                    innerElement.setEntityName(tmpInnerTypeName);
                    ((CompositeDataType)newType).getInnerDeclaration_CompositeDataType().add((Object)innerElement);
                }
            }
        }
        return newType;
    }

    private String getUnifiedTypeName(String typeName) {
        if (typeName.toLowerCase().equals("integer") || typeName.toLowerCase().equals("long")) {
            typeName = "int";
        } else if (typeName.toLowerCase().equals("boolean")) {
            typeName = "bool";
        } else if (typeName.toLowerCase().equals("float")) {
            typeName = "double";
        }
        return typeName.toLowerCase();
    }

    private DataType getExistingType(Type gastType, List<Repository> list) {
        return this.getExistingTypeByName(gastType.getName(), list);
    }

    private DataType getExistingTypeByName(String gastTypeName, List<Repository> repositories) {
        String unifiedGastTypeName = this.getUnifiedTypeName(gastTypeName);
        for (Repository repository : repositories) {
            for (DataType currentType : repository.getDataTypes__Repository()) {
                String pcmTypeName = null;
                if (currentType instanceof Entity) {
                    pcmTypeName = ((Entity)currentType).getEntityName();
                } else if (currentType instanceof PrimitiveDataType) {
                    pcmTypeName = ((PrimitiveDataType)currentType).getType().getName();
                }
                if (!unifiedGastTypeName.equals(pcmTypeName.toLowerCase())) continue;
                return currentType;
            }
        }
        LOGGER.info((Object)("no type found for " + gastTypeName + ". Type will be created."));
        return null;
    }
}

