/*
 * Decompiled with CFR 0.152.
 */
package org.somox.analyzer.simplemodelanalyzer.detection;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.gmt.modisco.java.Type;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.alg.ConnectivityInspector;
import org.jgrapht.graph.DirectedSubgraph;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.jgrapht.graph.Subgraph;
import org.somox.analyzer.ModelAnalyzerException;
import org.somox.analyzer.simplemodelanalyzer.builder.ComponentBuilder;
import org.somox.analyzer.simplemodelanalyzer.detection.IDetectionStrategy;
import org.somox.analyzer.simplemodelanalyzer.detection.NodePair;
import org.somox.analyzer.simplemodelanalyzer.detection.util.ComponentPrinter;
import org.somox.analyzer.simplemodelanalyzer.detection.util.EdgeThresholdFilter;
import org.somox.analyzer.simplemodelanalyzer.detection.util.VertexTypeAndEdgeThresholdFilter;
import org.somox.analyzer.simplemodelanalyzer.metrics.DefaultCompositionIndicatingMetric;
import org.somox.analyzer.simplemodelanalyzer.metrics.DefaultMergeIndicatingMetric;
import org.somox.analyzer.simplemodelanalyzer.metricvalues.MetricValuesWriter;
import org.somox.configuration.SoMoXConfiguration;
import org.somox.filter.BaseFilter;
import org.somox.filter.FilteredCollectionsFactory;
import org.somox.kdmhelper.metamodeladdition.Root;
import org.somox.metrics.ClusteringRelation;
import org.somox.metrics.IMetric;
import org.somox.metrics.MetricID;
import org.somox.metrics.helper.Class2ClassAccessGraphHelper;
import org.somox.metrics.helper.ClassAccessGraphEdge;
import org.somox.metrics.helper.ComponentToImplementingClassesHelper;
import org.somox.metrics.registry.MetricsRegistry;
import org.somox.metrics.util.GraphPrinter;
import org.somox.sourcecodedecorator.ComponentImplementingClassesLink;

public class ComponentDetectionByClustering
implements IDetectionStrategy {
    private static final Logger LOG = Logger.getLogger(ComponentDetectionByClustering.class);
    private final Root kdmModel;
    private final SoMoXConfiguration somoxConfiguration;
    private final ComponentToImplementingClassesHelper componentToImplementingClassHelper = new ComponentToImplementingClassesHelper();
    private final IMetric compositionIndicatingMetric;
    private final IMetric mergeIndicatingMetric;
    private final Map<MetricID, IMetric> allMetrics;
    private final ExecutorCompletionService<ClusteringRelation[]> completionService;
    private ExecutorService pool;

    public ComponentDetectionByClustering(Root kdmModelToAnalyze, List<ComponentImplementingClassesLink> initialComponentCandidates, SoMoXConfiguration somoxConfig) {
        this.validateConfiguration(somoxConfig);
        this.kdmModel = kdmModelToAnalyze;
        this.somoxConfiguration = somoxConfig;
        this.allMetrics = this.initializeMetrics(initialComponentCandidates);
        this.compositionIndicatingMetric = this.getMetric(this.allMetrics, DefaultCompositionIndicatingMetric.METRIC_ID);
        this.mergeIndicatingMetric = this.getMetric(this.allMetrics, DefaultMergeIndicatingMetric.METRIC_ID);
        this.completionService = this.initializeExecutorCompletionService();
        GraphPrinter.cleanOutputFolder((String)somoxConfig.getFileLocations().getAnalyserInputFile());
    }

    private void validateConfiguration(SoMoXConfiguration somoxConfig) {
        if (!(somoxConfig.getClusteringConfig().getClusteringMergeThresholdDecrement() > 0.0) || !(somoxConfig.getClusteringConfig().getClusteringComposeThresholdDecrement() > 0.0)) {
            throw new IllegalArgumentException("The merge and compose threshold increment/decrement have to be positive numbers");
        }
        if (!(somoxConfig.getClusteringConfig().getMinComposeClusteringThreshold() < somoxConfig.getClusteringConfig().getMaxComposeClusteringThreshold())) {
            throw new IllegalArgumentException("The minimum clustering threshold must be lower than maximum clustering threshold");
        }
        if (!(somoxConfig.getClusteringConfig().getMinMergeClusteringThreshold() < somoxConfig.getClusteringConfig().getMaxMergeClusteringThreshold())) {
            throw new IllegalArgumentException("The minimum merge threshold must be lower than maximum merge threshold");
        }
    }

    private ExecutorCompletionService<ClusteringRelation[]> initializeExecutorCompletionService() {
        int poolSize = LOG.isDebugEnabled() ? 1 : Runtime.getRuntime().availableProcessors() + 1;
        LOG.debug((Object)("Initialized thread pool to compute repair actions of the clustering graph with " + poolSize + " threads"));
        this.pool = Executors.newFixedThreadPool(poolSize);
        return new ExecutorCompletionService<ClusteringRelation[]>(this.pool);
    }

    @Override
    public List<ComponentImplementingClassesLink> startDetection(ComponentBuilder pcmBuilder, SoMoXConfiguration somoxConfig, IProgressMonitor progressMonitor, List<ComponentImplementingClassesLink> componentCandidates) throws ModelAnalyzerException {
        OperationMode currentMode = OperationMode.MERGE;
        double currentThreshold = this.somoxConfiguration.getClusteringConfig().getMinMergeClusteringThreshold();
        double currentThresholdBound = this.somoxConfiguration.getClusteringConfig().getMaxMergeClusteringThreshold();
        double currentDelta = this.somoxConfiguration.getClusteringConfig().getClusteringMergeThresholdDecrement();
        int componentCountPreviousIteration = componentCandidates.size();
        boolean newComponentsFound = true;
        int iteration = 0;
        DirectedGraph<ComponentImplementingClassesLink, ClusteringRelation> componentIndicatingGraph = this.setupGraph(componentCandidates);
        while (this.clusteringCanContinue(componentCandidates, currentMode, currentThreshold, currentThresholdBound)) {
            LOG.info((Object)("Clustering iteration nr.: " + ++iteration + " in mode: " + (Object)((Object)currentMode)));
            LOG.info((Object)("NR Component candidates: " + componentCandidates.size()));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Operation mode: " + (Object)((Object)currentMode) + ", current threshold value: " + currentThreshold + ", current delta: " + currentDelta + ", current bound: " + currentThresholdBound));
            }
            if (newComponentsFound) {
                LOG.debug((Object)"Computing clustering graphs");
                this.computeAllMetrics(componentCandidates, this.mergeIndicatingMetric, componentIndicatingGraph, progressMonitor);
                this.saveMetricValuesModel(componentIndicatingGraph, iteration, currentThreshold, currentMode, componentCandidates);
            }
            LOG.debug((Object)("Projecting graph based on current threshold " + currentThreshold));
            DirectedGraph<ComponentImplementingClassesLink, ClusteringRelation> projectedGraph = this.createProjectedGraph(componentIndicatingGraph, currentThreshold, currentMode);
            this.createDebugOutputForIteration(currentMode, iteration, componentIndicatingGraph, projectedGraph);
            componentCandidates = this.componentComposition(pcmBuilder, projectedGraph, iteration, currentMode == OperationMode.MERGE);
            pcmBuilder.updateRequiredInterfacesOfExistingPrimitiveComponents();
            if (componentCandidates.size() == componentCountPreviousIteration) {
                newComponentsFound = false;
            } else {
                componentCountPreviousIteration = componentCandidates.size();
                newComponentsFound = true;
            }
            if (newComponentsFound || currentMode != OperationMode.MERGE || !this.isSwitchToCompose(currentThreshold += currentDelta, currentThresholdBound)) continue;
            LOG.info((Object)"Done merging primitive components, now starting to compose.");
            currentMode = OperationMode.COMPOSE;
            currentThreshold = this.somoxConfiguration.getClusteringConfig().getMaxComposeClusteringThreshold();
            currentThresholdBound = this.somoxConfiguration.getClusteringConfig().getMinComposeClusteringThreshold();
            currentDelta = -this.somoxConfiguration.getClusteringConfig().getClusteringComposeThresholdDecrement();
        }
        if (LOG.isDebugEnabled()) {
            ComponentPrinter.printComponents(componentCandidates, LOG);
        }
        this.pool.shutdown();
        return componentCandidates;
    }

    private boolean isSwitchToCompose(double currentThreshold, double currentThresholdBound) {
        return currentThreshold > currentThresholdBound;
    }

    private boolean clusteringCanContinue(List<ComponentImplementingClassesLink> componentCandidates, OperationMode mode, double currentThreshold, double currentThresholdBound) {
        if (componentCandidates.size() <= 1) {
            return false;
        }
        if (mode == OperationMode.MERGE) {
            return true;
        }
        return currentThreshold >= currentThresholdBound;
    }

    private void saveMetricValuesModel(DirectedGraph<ComponentImplementingClassesLink, ClusteringRelation> metricsGraph, int iteration, double currentThreshold, OperationMode mode, List<ComponentImplementingClassesLink> componentCandidates) {
        MetricValuesWriter mvWriter = new MetricValuesWriter(this.somoxConfiguration);
        mvWriter.saveMetricValuesModel(metricsGraph, iteration, currentThreshold, componentCandidates, mode == OperationMode.MERGE);
    }

    private void createDebugOutputForIteration(OperationMode currentMode, int iteration, DirectedGraph<ComponentImplementingClassesLink, ClusteringRelation> componentIndicatingGraph, DirectedGraph<ComponentImplementingClassesLink, ClusteringRelation> projectedGraph) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("graph in mode = " + (Object)((Object)currentMode) + " contains " + projectedGraph.edgeSet().size() + " edges, " + projectedGraph.vertexSet().size() + " vertices / orig graph: " + componentIndicatingGraph.edgeSet().size() + " edges, " + projectedGraph.vertexSet().size() + " vertices"));
            GraphPrinter.dumpGraph((ComponentToImplementingClassesHelper)this.componentToImplementingClassHelper, componentIndicatingGraph, (String)this.somoxConfiguration.getFileLocations().getAnalyserInputFile(), (int)iteration, (int)-1);
            if (projectedGraph.edgeSet().size() > 0) {
                GraphPrinter.dumpGraph((ComponentToImplementingClassesHelper)this.componentToImplementingClassHelper, projectedGraph, (String)this.somoxConfiguration.getFileLocations().getAnalyserInputFile(), (int)iteration, (int)0);
            }
        }
    }

    private DirectedGraph<Type, ClassAccessGraphEdge> getAccessGraph(List<ComponentImplementingClassesLink> componentCandidates) {
        DirectedGraph accessGraph = Class2ClassAccessGraphHelper.computeFilteredClass2ClassAccessGraph((SoMoXConfiguration)this.somoxConfiguration, (Set)this.componentToImplementingClassHelper.collectAllClasses(componentCandidates));
        return accessGraph;
    }

    private Map<MetricID, IMetric> initializeMetrics(List<ComponentImplementingClassesLink> componentCandidates) {
        Map allMetrics = MetricsRegistry.getRegisteredMetrics();
        DirectedGraph<Type, ClassAccessGraphEdge> accessGraph = this.getAccessGraph(componentCandidates);
        for (IMetric metric : allMetrics.values()) {
            metric.initialize(this.kdmModel, this.somoxConfiguration, allMetrics, accessGraph, this.componentToImplementingClassHelper);
        }
        return allMetrics;
    }

    private DirectedGraph<ComponentImplementingClassesLink, ClusteringRelation> createProjectedGraph(DirectedGraph<ComponentImplementingClassesLink, ClusteringRelation> componentIndicatingGraph, double currentThreshold, OperationMode currentMode) {
        BaseFilter filter = currentMode == OperationMode.MERGE ? new VertexTypeAndEdgeThresholdFilter(this.mergeIndicatingMetric.getMID(), currentThreshold) : new EdgeThresholdFilter(this.compositionIndicatingMetric.getMID(), currentThreshold);
        return new DirectedSubgraph(componentIndicatingGraph, componentIndicatingGraph.vertexSet(), FilteredCollectionsFactory.getFilteredHashSet((BaseFilter)filter, (Iterable)componentIndicatingGraph.edgeSet()));
    }

    private void computeAllMetrics(List<ComponentImplementingClassesLink> newComponentCandidates, IMetric metricComputationStrategy, DirectedGraph<ComponentImplementingClassesLink, ClusteringRelation> previousGraph, IProgressMonitor progressMonitor) throws ModelAnalyzerException {
        Collection<NodePair> work = this.deriveComputationWork(newComponentCandidates, previousGraph);
        int totalCount = work.size();
        SubProgressMonitor clusteringProgressMonitor = new SubProgressMonitor(progressMonitor, totalCount);
        long startTimeClustering = System.nanoTime();
        LOG.debug((Object)("Creating weighted directed graph for " + newComponentCandidates.size() + " components."));
        for (NodePair nodePair : work) {
            this.completionService.submit(nodePair.getWorkTask(metricComputationStrategy, this.allMetrics));
        }
        try {
            int stepNo = 0;
            while (stepNo < totalCount) {
                ClusteringRelation[] computedRelationPair;
                ClusteringRelation[] clusteringRelationArray = computedRelationPair = this.completionService.take().get();
                int n = computedRelationPair.length;
                int n2 = 0;
                while (n2 < n) {
                    ClusteringRelation relation = clusteringRelationArray[n2];
                    previousGraph.addEdge((Object)relation.getSourceComponent(), (Object)relation.getTargetComponent(), (Object)relation);
                    ++n2;
                }
                LOG.debug((Object)(String.valueOf(stepNo * 100 / totalCount) + "% of clustering done."));
                ++stepNo;
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Parallel execution failed unexpectedly", e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Parallel execution failed unexpectedly", e);
        }
        long clusteringTime = System.nanoTime() - startTimeClustering;
        LOG.debug((Object)("TIME for Compute All Metrics: " + TimeUnit.NANOSECONDS.toSeconds(clusteringTime) + " s"));
        clusteringProgressMonitor.done();
    }

    private Collection<NodePair> deriveComputationWork(List<ComponentImplementingClassesLink> componentCandidates, DirectedGraph<ComponentImplementingClassesLink, ClusteringRelation> previousGraph) {
        HashSet<ComponentImplementingClassesLink> newNodes = new HashSet<ComponentImplementingClassesLink>();
        HashSet<ComponentImplementingClassesLink> nodesToRemove = new HashSet<ComponentImplementingClassesLink>();
        for (ComponentImplementingClassesLink link : previousGraph.vertexSet()) {
            if (componentCandidates.contains(link)) continue;
            nodesToRemove.add(link);
        }
        previousGraph.removeAllVertices(nodesToRemove);
        HashSet<ComponentImplementingClassesLink> oldNodesSet = new HashSet<ComponentImplementingClassesLink>(previousGraph.vertexSet());
        for (ComponentImplementingClassesLink link : componentCandidates) {
            if (previousGraph.vertexSet().contains(link)) continue;
            newNodes.add(link);
            previousGraph.addVertex((Object)link);
        }
        assert (Collections.disjoint(newNodes, oldNodesSet));
        int totalCount = newNodes.size() * (newNodes.size() - 1) / 2 + newNodes.size() * oldNodesSet.size();
        Collection<NodePair> pairsToCompute = this.derivePairsToCompute(newNodes, oldNodesSet);
        assert (pairsToCompute.size() == totalCount);
        return pairsToCompute;
    }

    private Collection<NodePair> derivePairsToCompute(Set<ComponentImplementingClassesLink> newNodes, Set<ComponentImplementingClassesLink> oldNodesSet) {
        HashSet<NodePair> result = new HashSet<NodePair>();
        for (ComponentImplementingClassesLink oldNode : oldNodesSet) {
            for (ComponentImplementingClassesLink newNode : newNodes) {
                result.add(new NodePair(newNode, oldNode));
            }
        }
        for (ComponentImplementingClassesLink newNode1 : newNodes) {
            for (ComponentImplementingClassesLink newNode2 : newNodes) {
                NodePair newPair;
                if (newNode1 == newNode2 || result.contains(newPair = new NodePair(newNode1, newNode2))) continue;
                result.add(newPair);
            }
        }
        return result;
    }

    private DirectedGraph<ComponentImplementingClassesLink, ClusteringRelation> setupGraph(List<ComponentImplementingClassesLink> componentCandidates) {
        SimpleDirectedGraph result = new SimpleDirectedGraph(ClusteringRelation.class);
        return result;
    }

    private List<ComponentImplementingClassesLink> componentComposition(ComponentBuilder sammBuilder, DirectedGraph<ComponentImplementingClassesLink, ClusteringRelation> relationshipGraph, int iteration, boolean isMergeCase) {
        LinkedList<ComponentImplementingClassesLink> result = new LinkedList<ComponentImplementingClassesLink>();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)relationshipGraph.toString());
        }
        ConnectivityInspector connectivityInspector = new ConnectivityInspector(relationshipGraph);
        List subGraphs = connectivityInspector.connectedSets();
        LOG.debug((Object)("Found " + subGraphs.size() + " strong components in relation graph."));
        int subgraphNo = 1;
        for (Set componentsToMerge : subGraphs) {
            if (componentsToMerge.size() > 1) {
                LOG.debug((Object)("Found a cluster of " + componentsToMerge.size() + " related components. Merging them into a composite component"));
                Subgraph compositeComponentSubgraph = new Subgraph(relationshipGraph, componentsToMerge);
                if (compositeComponentSubgraph.edgeSet().size() > 0 && LOG.isTraceEnabled()) {
                    GraphPrinter.dumpGraph((ComponentToImplementingClassesHelper)this.componentToImplementingClassHelper, (Graph)compositeComponentSubgraph, (String)this.somoxConfiguration.getFileLocations().getAnalyserInputFile(), (int)iteration, (int)subgraphNo++);
                }
                ComponentImplementingClassesLink newComponent = null;
                newComponent = isMergeCase ? sammBuilder.createMergedComponent((Graph<ComponentImplementingClassesLink, ClusteringRelation>)compositeComponentSubgraph) : sammBuilder.createCompositeComponent((Graph<ComponentImplementingClassesLink, ClusteringRelation>)compositeComponentSubgraph);
                result.add(newComponent);
                continue;
            }
            result.addAll(componentsToMerge);
        }
        return result;
    }

    private IMetric getMetric(Map<MetricID, IMetric> allMetrics, MetricID metricId) {
        IMetric result = allMetrics.get(metricId);
        if (result == null) {
            throw new RuntimeException("Configuration error, Metric " + metricId + " needed but not available");
        }
        return result;
    }

    private static enum OperationMode {
        MERGE,
        COMPOSE;

    }
}

