/*
 * Decompiled with CFR 0.152.
 */
package org.somox.analyzer.simplemodelanalyzer.detection;

import org.eclipse.gmt.modisco.java.ASTNode;
import org.eclipse.gmt.modisco.java.BodyDeclaration;
import org.eclipse.gmt.modisco.java.MethodDeclaration;
import org.eclipse.gmt.modisco.java.Type;
import org.somox.analyzer.simplemodelanalyzer.detection.IComponentInterfaceStrategy;
import org.somox.kdmhelper.KDMHelper;
import org.somox.sourcecodedecorator.InterfaceSourceCodeLink;
import org.somox.sourcecodedecorator.SourceCodeDecoratorRepository;

public class ComponentInterfaceStrategy
implements IComponentInterfaceStrategy {
    private final SourceCodeDecoratorRepository sourceCodeDecorator;

    public ComponentInterfaceStrategy(SourceCodeDecoratorRepository sourceCodeDecorator) {
        this.sourceCodeDecorator = sourceCodeDecorator;
    }

    @Override
    public boolean isComponentInterface(Type classToCheck) {
        return this.isRegularInterface(classToCheck) || this.isPureVirtualClass(classToCheck) || this.isClassifiedAsInterfaceViaSourceCodeDecorator(classToCheck);
    }

    private boolean isRegularInterface(Type classToCheck) {
        return KDMHelper.isInterface((ASTNode)classToCheck);
    }

    private boolean isClassifiedAsInterfaceViaSourceCodeDecorator(Type classToCheck) {
        for (InterfaceSourceCodeLink ifLink : this.sourceCodeDecorator.getInterfaceSourceCodeLink()) {
            if (!ifLink.getGastClass().equals(classToCheck)) continue;
            return true;
        }
        return false;
    }

    private boolean isPureVirtualClass(Type classToCheck) {
        if (KDMHelper.getMethods((Type)classToCheck).size() == 0) {
            return false;
        }
        for (MethodDeclaration method : KDMHelper.getMethods((Type)classToCheck)) {
            if (!KDMHelper.isVirtual((BodyDeclaration)method)) {
                return false;
            }
            if (method.getBody() == null) continue;
            return false;
        }
        return true;
    }
}

