/*
 * Decompiled with CFR 0.152.
 */
package org.somox.analyzer.simplemodelanalyzer.detection;

import de.uka.ipd.sdq.workflow.ExecutionTimeLoggingProgressMonitor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.EventGroup;
import org.palladiosimulator.pcm.repository.EventType;
import org.palladiosimulator.pcm.repository.OperationInterface;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.repository.Signature;
import org.palladiosimulator.pcm.repository.SinkRole;
import org.palladiosimulator.pcm.seff.ResourceDemandingSEFF;
import org.somox.analyzer.simplemodelanalyzer.SimpleAnalysisResult;
import org.somox.analyzer.simplemodelanalyzer.detection.IPostComponentDetectionStrategy;
import org.somox.configuration.SoMoXConfiguration;
import org.somox.sourcecodedecorator.ComponentImplementingClassesLink;
import org.somox.sourcecodedecorator.FileLevelSourceCodeLink;
import org.somox.sourcecodedecorator.Seff2MethodLink;

public class DeleteInitialComponentCandidatesStrategy
implements IPostComponentDetectionStrategy {
    private static Logger logger = Logger.getLogger(DeleteInitialComponentCandidatesStrategy.class);

    @Override
    public void postComponentDetection(SoMoXConfiguration somoxConfiguration, SimpleAnalysisResult analysisResult, IProgressMonitor progressMonitor) {
        ExecutionTimeLoggingProgressMonitor subProgressMonitor = new ExecutionTimeLoggingProgressMonitor(progressMonitor, analysisResult.getSourceCodeDecoratorRepository().getComponentImplementingClassesLink().size());
        subProgressMonitor.beginTask("Post component detection", -1);
        logger.trace((Object)"Post component detection");
        HashSet<RepositoryComponent> componentsToDelete = new HashSet<RepositoryComponent>();
        HashSet<ComponentImplementingClassesLink> componentLinksToDelete = new HashSet<ComponentImplementingClassesLink>();
        boolean lastCollectedForDeletion = false;
        for (ComponentImplementingClassesLink componentLinkToCheck : analysisResult.getSourceCodeDecoratorRepository().getComponentImplementingClassesLink()) {
            if (componentLinkToCheck.isInitialComponent()) {
                for (ComponentImplementingClassesLink innerComponentLink : analysisResult.getSourceCodeDecoratorRepository().getComponentImplementingClassesLink()) {
                    if (innerComponentLink == componentLinkToCheck || !innerComponentLink.getImplementingClasses().containsAll((Collection)componentLinkToCheck.getImplementingClasses())) continue;
                    logger.trace((Object)("Deleting initial component: " + componentLinkToCheck.getComponent().getEntityName()));
                    componentLinksToDelete.add(componentLinkToCheck);
                    componentsToDelete.add(componentLinkToCheck.getComponent());
                    lastCollectedForDeletion = true;
                    break;
                }
                if (!lastCollectedForDeletion) {
                    componentLinkToCheck.setIsInitialComponent(false);
                    lastCollectedForDeletion = false;
                }
            }
            subProgressMonitor.worked(1);
        }
        this.cleanUpGastBehaviour(analysisResult, componentLinksToDelete);
        this.cleanUpSourceCodeDecorator(analysisResult, componentLinksToDelete);
        for (ComponentImplementingClassesLink compLink : componentLinksToDelete) {
            EcoreUtil.delete((EObject)compLink, (boolean)true);
        }
        for (RepositoryComponent comp : componentsToDelete) {
            EcoreUtil.delete((EObject)comp, (boolean)true);
        }
        subProgressMonitor.done();
    }

    private void cleanUpSourceCodeDecorator(SimpleAnalysisResult analysisResult, Set<ComponentImplementingClassesLink> componentLinksToDelete) {
        HashSet<FileLevelSourceCodeLink> fileLevelSourceCodeLinksToDelete = new HashSet<FileLevelSourceCodeLink>();
        HashSet<FileLevelSourceCodeLink> methodLevelSourceCodeLinksToDelete = new HashSet<FileLevelSourceCodeLink>();
        for (ComponentImplementingClassesLink compLink : componentLinksToDelete) {
            for (FileLevelSourceCodeLink sourceLink : analysisResult.getSourceCodeDecoratorRepository().getFileLevelSourceCodeLink()) {
                if (!sourceLink.getRepositoryComponent().equals(compLink.getComponent())) continue;
                fileLevelSourceCodeLinksToDelete.add(sourceLink);
            }
            for (FileLevelSourceCodeLink sourceLink : analysisResult.getSourceCodeDecoratorRepository().getMethodLevelSourceCodeLink()) {
                if (sourceLink.getRepositoryComponent() == null || !sourceLink.getRepositoryComponent().equals(compLink.getComponent())) continue;
                methodLevelSourceCodeLinksToDelete.add(sourceLink);
            }
        }
        for (FileLevelSourceCodeLink sourceCodeLink : fileLevelSourceCodeLinksToDelete) {
            EcoreUtil.delete((EObject)sourceCodeLink, (boolean)true);
        }
        for (FileLevelSourceCodeLink sourceCodeLink : methodLevelSourceCodeLinksToDelete) {
            EcoreUtil.delete((EObject)sourceCodeLink, (boolean)true);
        }
    }

    private void cleanUpGastBehaviour(SimpleAnalysisResult analysisResult, Set<ComponentImplementingClassesLink> componentLinksToDelete) {
        HashSet<Seff2MethodLink> mappingsToDelete = new HashSet<Seff2MethodLink>();
        block0: for (Seff2MethodLink seff2MethodMapping : analysisResult.getSourceCodeDecoratorRepository().getSeff2MethodLink()) {
            Signature signature = seff2MethodMapping.getSeff().getDescribedService__SEFF();
            for (ComponentImplementingClassesLink compLink : componentLinksToDelete) {
                for (ProvidedRole providedRole : compLink.getComponent().getProvidedRoles_InterfaceProvidingEntity()) {
                    BasicComponent compOfBehaviour;
                    if (providedRole instanceof OperationProvidedRole) {
                        OperationInterface operationInterface = ((OperationProvidedRole)providedRole).getProvidedInterface__OperationProvidedRole();
                        for (OperationSignature operationSignature : operationInterface.getSignatures__OperationInterface()) {
                            if (seff2MethodMapping.getSeff().eContainer() instanceof BasicComponent) {
                                compOfBehaviour = (BasicComponent)seff2MethodMapping.getSeff().eContainer();
                                if (!operationSignature.equals(signature) || !compOfBehaviour.equals(compLink.getComponent())) continue;
                                mappingsToDelete.add(seff2MethodMapping);
                                continue block0;
                            }
                            logger.warn((Object)"Parent of gast behaviour stub should be a primitive component.");
                        }
                        continue;
                    }
                    if (providedRole instanceof SinkRole) {
                        EventGroup eventGroup = ((SinkRole)providedRole).getEventGroup__SinkRole();
                        for (EventType eventType : eventGroup.getEventTypes__EventGroup()) {
                            if (seff2MethodMapping.getSeff().eContainer() instanceof BasicComponent) {
                                compOfBehaviour = (BasicComponent)seff2MethodMapping.getSeff().eContainer();
                                if (!eventType.equals(signature) || !compOfBehaviour.equals(compLink.getComponent())) continue;
                                mappingsToDelete.add(seff2MethodMapping);
                                continue block0;
                            }
                            logger.warn((Object)"Parent of gast behaviour stub should be a primitive component.");
                        }
                        continue;
                    }
                    logger.warn((Object)("Unsupported operation type: " + providedRole.getEntityName() + " [" + providedRole.getClass().getSimpleName() + "]"));
                }
            }
        }
        for (Seff2MethodLink seff2MethodMapping : mappingsToDelete) {
            ResourceDemandingSEFF seff = (ResourceDemandingSEFF)seff2MethodMapping.getSeff();
            logger.trace((Object)("deleting Seff2MethodMapping in decorator: " + seff.getId() + ": " + seff.getDescribedService__SEFF().getEntityName() + " " + seff2MethodMapping));
            EcoreUtil.delete((EObject)seff2MethodMapping, (boolean)false);
        }
    }
}

