/*
 * Decompiled with CFR 0.152.
 */
package org.somox.analyzer.simplemodelanalyzer.jobs;

import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import java.io.IOException;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.palladiosimulator.pcm.qosannotations.QoSAnnotations;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.system.System;
import org.somox.analyzer.AnalysisResult;
import org.somox.analyzer.simplemodelanalyzer.jobs.SoMoXBlackboard;
import org.somox.configuration.SoMoXConfiguration;
import org.somox.sourcecodedecorator.SourceCodeDecoratorRepository;

public class SaveSoMoXModelsJob
implements IBlackboardInteractingJob<SoMoXBlackboard> {
    private static final String PATH_SOURCECODE_DECORATOR_REPOSITORY = "/internal_architecture_model.sourcecodedecorator";
    private static final String PATH_SYSTEM_MODEL = "/internal_architecture_model.system";
    private static final String PATH_QOS_ANNOTATIONS_MODEL = "/internal_architecture_model.samm_qosannotation";
    private static final String PATH_REPOSITORY_MODEL = "/internal_architecture_model.repository";
    private final Logger logger = Logger.getLogger(SaveSoMoXModelsJob.class);
    private SoMoXBlackboard blackboard = null;
    private ResourceSet resourceSet = null;
    private SoMoXConfiguration somoxConfiguration = null;

    public SaveSoMoXModelsJob(SoMoXConfiguration somoxConfiguration) {
        this.somoxConfiguration = somoxConfiguration;
        this.resourceSet = new ResourceSetImpl();
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
    }

    public void setBlackboard(SoMoXBlackboard blackBoard) {
        this.blackboard = blackBoard;
    }

    public void execute(IProgressMonitor arg0) throws JobFailedException, UserCanceledException {
        AnalysisResult result = this.blackboard.getAnalysisResult();
        String projectIdentifier = this.somoxConfiguration.getFileLocations().getProjectName();
        String outputFolder = this.somoxConfiguration.getFileLocations().getOutputFolder();
        try {
            this.saveRepositoryModel(result.getInternalArchitectureModel(), projectIdentifier, outputFolder);
            this.saveSourceCodeDecoratorRepository(result.getSourceCodeDecoratorRepository(), projectIdentifier, outputFolder);
            this.saveSammModel(result.getSystemModel(), projectIdentifier, outputFolder);
            this.saveQoSAnnotationsModel(result.getQosAnnotationModel(), projectIdentifier, outputFolder);
        }
        catch (IOException e) {
            this.logger.error((Object)"Model Analyzer failed.", (Throwable)e);
            throw new JobFailedException("Unable to save SoMoX Models", (Throwable)e);
        }
    }

    private void saveSourceCodeDecoratorRepository(SourceCodeDecoratorRepository repository, String projectIdentifier, String outputFolder) throws IOException {
        this.save((EObject)repository, projectIdentifier, String.valueOf(outputFolder) + PATH_SOURCECODE_DECORATOR_REPOSITORY);
    }

    private void saveSammModel(System system, String projectIdentifier, String outputFolder) throws IOException {
        this.save((EObject)system, projectIdentifier, String.valueOf(outputFolder) + PATH_SYSTEM_MODEL);
    }

    private void saveQoSAnnotationsModel(QoSAnnotations serviceArchitectureModel, String projectIdentifier, String outputFolder) throws IOException {
        this.save((EObject)serviceArchitectureModel, projectIdentifier, String.valueOf(outputFolder) + PATH_QOS_ANNOTATIONS_MODEL);
    }

    private void saveRepositoryModel(Repository repository, String projectIdentifier, String outputFolder) throws IOException {
        this.save((EObject)repository, projectIdentifier, String.valueOf(outputFolder) + PATH_REPOSITORY_MODEL);
    }

    private void save(EObject emfObject, String projectIdentifier, String path) throws IOException {
        ResourceSet resourceSet = this.getResourceSetForURI();
        URI uri = URI.createURI((String)("platform:/resource/" + projectIdentifier + path));
        Resource resource = resourceSet.createResource(uri);
        resource.getContents().add((Object)emfObject);
        HashMap<String, String> saveOptions = new HashMap<String, String>();
        saveOptions.put("PROCESS_DANGLING_HREF", "DISCARD");
        resource.save(saveOptions);
    }

    private ResourceSet getResourceSetForURI() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        return resourceSet;
    }

    public String getName() {
        return "Save SoMoX Models Job";
    }

    public void cleanup(IProgressMonitor arg0) throws CleanupFailedException {
    }
}

