/*
 * Decompiled with CFR 0.152.
 */
package org.somox.metrics.abstractmetrics;

import java.util.Map;
import org.somox.configuration.SoMoXConfiguration;
import org.somox.metrics.ICompositionFunction;
import org.somox.metrics.MetricID;
import org.somox.metrics.abstractmetrics.AbstractComposedMetric;

public abstract class AbstractWeightedComposedMetric
extends AbstractComposedMetric {
    private final double[] weights = this.getWeigths();
    private final ICompositionFunction function = new ICompositionFunction(){

        @Override
        public double computeOverallDirectedMetricValue(Map<MetricID, Double> metricValues) {
            double weightSum = 0.0;
            double weightedSum = 0.0;
            int i = 0;
            while (i < AbstractWeightedComposedMetric.this.weights.length) {
                double metricValue = metricValues.get(AbstractWeightedComposedMetric.this.getAllChildMetrics()[i]);
                double weight = AbstractWeightedComposedMetric.this.weights[i];
                weightSum += weight;
                weightedSum += metricValue * weight;
                ++i;
            }
            return weightedSum / weightSum;
        }
    };

    @Override
    protected ICompositionFunction getCompositionFunction(SoMoXConfiguration somoxConfiguration) {
        return this.function;
    }

    protected abstract double[] getWeigths();

    @Override
    public boolean isNormalised() {
        return true;
    }
}

