/*
 * Decompiled with CFR 0.152.
 */
package org.storydriven.storydiagrams.diagram.interpreter.util;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class InterpreterConsole
extends MessageConsole {
    private MessageConsoleStream debugStream;
    private MessageConsoleStream failureStream;
    private MessageConsoleStream infoStream = this.newMessageStream();
    private MessageConsoleStream successStream;

    public InterpreterConsole() {
        super("Interpreter Console", null, false);
        this.infoStream.setColor(new Color((Device)PlatformUI.getWorkbench().getDisplay(), 0, 0, 0));
        this.successStream = this.newMessageStream();
        this.successStream.setColor(new Color((Device)PlatformUI.getWorkbench().getDisplay(), 30, 200, 30));
        this.failureStream = this.newMessageStream();
        this.failureStream.setColor(new Color((Device)PlatformUI.getWorkbench().getDisplay(), 200, 30, 30));
        this.debugStream = this.newMessageStream();
        this.debugStream.setColor(new Color((Device)PlatformUI.getWorkbench().getDisplay(), 160, 160, 160));
    }

    public void append(StreamType type, String message) {
        String printed = String.valueOf(message) + "\n";
        switch (type) {
            case INFO: {
                this.infoStream.print(printed);
                break;
            }
            case SUCCESS: {
                this.successStream.print(printed);
                break;
            }
            case FAILURE: {
                this.failureStream.print(printed);
                break;
            }
            case DEBUG: {
                this.debugStream.print(printed);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    public void wrap() {
        this.debugStream.print("\n");
    }

    public static enum StreamType {
        DEBUG,
        FAILURE,
        INFO,
        SUCCESS;

    }
}

