/*
 * Decompiled with CFR 0.152.
 */
package org.storydriven.storydiagrams.diagram.interpreter.util;

import de.mdelab.sdm.interpreter.core.SDMException;
import de.mdelab.sdm.interpreter.core.notifications.NotificationReceiver;
import de.mdelab.sdm.interpreter.core.variables.Variable;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.storydriven.storydiagrams.activities.Activity;
import org.storydriven.storydiagrams.diagram.interpreter.ConsoleNotificationReceiver;
import org.storydriven.storydiagrams.diagram.interpreter.util.InterpreterConsole;
import org.storydriven.storydiagrams.interpreter.eclipse.StoryDrivenEclipseInterpreter;

public class InterpreterRunnable
implements IRunnableWithProgress {
    private Activity activity;
    private List<Variable<EClassifier>> parameters;
    private NotificationReceiver<EClassifier> receiver;
    private Map<String, Variable<EClassifier>> results;

    public InterpreterRunnable(Activity activity, List<Variable<EClassifier>> parameters, InterpreterConsole console) {
        this.activity = activity;
        this.parameters = parameters;
        this.receiver = new ConsoleNotificationReceiver(console);
    }

    public Map<String, Variable<EClassifier>> getResults() {
        return this.results;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            StoryDrivenEclipseInterpreter interpreter = new StoryDrivenEclipseInterpreter(this.getClass().getClassLoader());
            interpreter.getNotificationEmitter().addNotificationReceiver(this.receiver);
            this.results = interpreter.executeActivity((Object)this.activity, this.parameters);
            interpreter.getNotificationEmitter().removeNotificationReceiver(this.receiver);
        }
        catch (SDMException e) {
            throw new InvocationTargetException(e);
        }
    }
}

