/*
 * Decompiled with CFR 0.152.
 */
package org.storydriven.storydiagrams.diagram.interpreter.util;

import de.upb.swt.core.ui.providers.ComposedAdapterFactoryLabelProvider;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EParameter;
import org.storydriven.core.NamedElement;
import org.storydriven.core.expressions.Expression;
import org.storydriven.core.expressions.TextualExpression;
import org.storydriven.core.expressions.common.ArithmeticExpression;
import org.storydriven.core.expressions.common.ArithmeticOperator;
import org.storydriven.core.expressions.common.ComparingOperator;
import org.storydriven.core.expressions.common.ComparisonExpression;
import org.storydriven.core.expressions.common.LiteralExpression;
import org.storydriven.core.expressions.common.LogicOperator;
import org.storydriven.core.expressions.common.LogicalExpression;
import org.storydriven.core.expressions.common.UnaryExpression;
import org.storydriven.storydiagrams.activities.Activity;
import org.storydriven.storydiagrams.activities.ActivityCallNode;
import org.storydriven.storydiagrams.activities.ActivityEdge;
import org.storydriven.storydiagrams.activities.ActivityFinalNode;
import org.storydriven.storydiagrams.activities.EdgeGuard;
import org.storydriven.storydiagrams.activities.InitialNode;
import org.storydriven.storydiagrams.activities.JunctionNode;
import org.storydriven.storydiagrams.activities.MatchingStoryNode;
import org.storydriven.storydiagrams.activities.ModifyingStoryNode;
import org.storydriven.storydiagrams.activities.StatementNode;
import org.storydriven.storydiagrams.activities.StructuredNode;
import org.storydriven.storydiagrams.activities.expressions.ExceptionVariableExpression;
import org.storydriven.storydiagrams.calls.OpaqueCallable;
import org.storydriven.storydiagrams.calls.ParameterExtension;
import org.storydriven.storydiagrams.calls.expressions.MethodCallExpression;
import org.storydriven.storydiagrams.calls.expressions.ParameterExpression;
import org.storydriven.storydiagrams.diagram.custom.util.EcoreTextUtil;
import org.storydriven.storydiagrams.patterns.AbstractVariable;
import org.storydriven.storydiagrams.patterns.CollectionVariable;
import org.storydriven.storydiagrams.patterns.LinkVariable;
import org.storydriven.storydiagrams.patterns.ObjectVariable;
import org.storydriven.storydiagrams.patterns.PrimitiveVariable;
import org.storydriven.storydiagrams.patterns.StoryPattern;
import org.storydriven.storydiagrams.patterns.expressions.AttributeValueExpression;
import org.storydriven.storydiagrams.patterns.expressions.CollectionSizeExpression;
import org.storydriven.storydiagrams.patterns.expressions.ObjectVariableExpression;
import org.storydriven.storydiagrams.patterns.expressions.PrimitiveVariableExpression;

public class Texts {
    private static final ComposedAdapterFactoryLabelProvider AFLP = new ComposedAdapterFactoryLabelProvider();

    private Texts() {
    }

    public static StringBuilder get(Object element) {
        StringBuilder builder = new StringBuilder();
        if (element instanceof Activity) {
            return Texts.append(builder, (Activity)element);
        }
        if (element instanceof ActivityCallNode) {
            return Texts.append(builder, (ActivityCallNode)element);
        }
        if (element instanceof ModifyingStoryNode) {
            return Texts.append(builder, (NamedElement)((ModifyingStoryNode)element), "Modifying Story Node");
        }
        if (element instanceof MatchingStoryNode) {
            return Texts.append(builder, (NamedElement)((MatchingStoryNode)element), "Matching Story Node");
        }
        if (element instanceof StatementNode) {
            return Texts.append(builder, (NamedElement)((StatementNode)element), "Statement Node");
        }
        if (element instanceof StructuredNode) {
            return Texts.append(builder, (NamedElement)((StructuredNode)element), "Structured Node");
        }
        if (element instanceof ActivityEdge) {
            return Texts.append(builder, (ActivityEdge)element);
        }
        if (element instanceof InitialNode) {
            return Texts.append(builder, (NamedElement)((InitialNode)element), "Initial Node");
        }
        if (element instanceof JunctionNode) {
            return Texts.append(builder, (NamedElement)((JunctionNode)element), "Junction Node");
        }
        if (element instanceof ActivityFinalNode) {
            return Texts.append(builder, (ActivityFinalNode)element);
        }
        if (element instanceof Expression) {
            return Texts.append(builder, (Expression)element);
        }
        if (element instanceof StoryPattern) {
            return Texts.append(builder, (StoryPattern)element);
        }
        if (element instanceof ObjectVariable) {
            if (element instanceof CollectionVariable) {
                return Texts.append(builder, (NamedElement)((ObjectVariable)element), "Collection Variable");
            }
            return Texts.append(builder, (NamedElement)((ObjectVariable)element), "Object Variable");
        }
        if (element instanceof PrimitiveVariable) {
            return Texts.append(builder, (NamedElement)((PrimitiveVariable)element), "Primitive Variable");
        }
        if (element instanceof LinkVariable) {
            return Texts.append(builder, (LinkVariable)element);
        }
        if (element instanceof EObject) {
            return builder.append(AFLP.getText(element));
        }
        return builder.append(String.valueOf(element));
    }

    private static StringBuilder append(StringBuilder builder, Activity element) {
        builder.append("Activity");
        builder.append(' ');
        builder.append('\'');
        builder.append(element.getName());
        builder.append('(');
        EList in = element.getInParameters();
        int i = 0;
        while (i < in.size()) {
            EcoreTextUtil.append((StringBuilder)builder, (EClassifier)((EParameter)in.get(i)).getEType());
            if (i < in.size() - 1) {
                builder.append(',');
                builder.append(' ');
            }
            ++i;
        }
        builder.append(')');
        builder.append(':');
        builder.append(' ');
        EList out = element.getOutParameters();
        if (out.isEmpty()) {
            builder.append("void");
        } else {
            int i2 = 0;
            while (i2 < out.size()) {
                EcoreTextUtil.append((StringBuilder)builder, (EClassifier)((EParameter)out.get(i2)).getEType());
                if (i2 < out.size() - 1) {
                    builder.append(',');
                    builder.append(' ');
                }
                ++i2;
            }
        }
        builder.append('\'');
        return builder;
    }

    private static StringBuilder append(StringBuilder builder, ActivityCallNode element) {
        return Texts.append(builder, (NamedElement)element, "Activity Call Node");
    }

    private static StringBuilder append(StringBuilder builder, ActivityFinalNode element) {
        Texts.append(builder, (NamedElement)element, "Stop Node");
        return builder;
    }

    private static StringBuilder append(StringBuilder builder, LinkVariable element) {
        builder.append('\'');
        if (element.getTargetEnd() != null) {
            builder.append(element.getTargetEnd().getName());
        } else {
            builder.append(element);
        }
        builder.append('\'');
        builder.append(' ');
        builder.append("from");
        builder.append(' ');
        Texts.append(builder, element.getSource());
        builder.append(' ');
        builder.append("to");
        builder.append(' ');
        Texts.append(builder, element.getTarget());
        builder.append(' ');
        return builder;
    }

    private static StringBuilder append(StringBuilder builder, AbstractVariable element) {
        if (element instanceof ObjectVariable) {
            return Texts.append(builder, (ObjectVariable)element);
        }
        if (element instanceof PrimitiveVariable) {
            return Texts.append(builder, (NamedElement)((PrimitiveVariable)element), "Primitive Variable");
        }
        return builder.append(element);
    }

    private static StringBuilder append(StringBuilder builder, ObjectVariable element) {
        if (element instanceof CollectionVariable) {
            Texts.append(builder, (NamedElement)element, "Collection Variable");
        } else {
            Texts.append(builder, (NamedElement)element, "Object Variable");
        }
        return builder;
    }

    private static StringBuilder append(StringBuilder builder, NamedElement element, String prefix) {
        builder.append(prefix);
        if (element.getName() != null && !element.getName().trim().isEmpty()) {
            builder.append(' ');
            builder.append('\'');
            builder.append(element.getName());
            builder.append('\'');
        }
        return builder;
    }

    private static StringBuilder append(StringBuilder builder, ActivityEdge element) {
        builder.append("Activity Edge");
        builder.append(' ');
        builder.append('[');
        builder.append(element.getGuard());
        if (EdgeGuard.BOOL.equals((Object)element.getGuard())) {
            builder.append(':');
            builder.append(' ');
            builder.append(element.getGuardExpression());
        }
        builder.append(']');
        return builder;
    }

    private static StringBuilder append(StringBuilder builder, Expression expression) {
        if (expression == null) {
            return builder.append(expression);
        }
        boolean isRoot = !(expression.eContainer() instanceof Expression);
        boolean isNegated = expression.eContainer() instanceof UnaryExpression;
        if (expression instanceof LiteralExpression) {
            LiteralExpression le = (LiteralExpression)expression;
            builder.append(le.getValue());
            return builder;
        }
        if (expression instanceof TextualExpression) {
            TextualExpression te = (TextualExpression)expression;
            if (isRoot) {
                return builder.append(te.getExpressionText());
            }
            builder.append('{');
            builder.append(' ');
            builder.append(te.getExpressionText());
            builder.append(' ');
            builder.append('}');
            return builder;
        }
        if (expression instanceof UnaryExpression) {
            UnaryExpression ne = (UnaryExpression)expression;
            builder.append("not");
            builder.append('(');
            Texts.append(builder, ne.getEnclosedExpression());
            builder.append(')');
            return builder;
        }
        if (expression instanceof ArithmeticExpression) {
            ArithmeticExpression ae = (ArithmeticExpression)expression;
            if (!isRoot && !isNegated) {
                builder.append('(');
            }
            Texts.append(builder, ae.getLeftExpression());
            builder.append(' ');
            Texts.append(builder, ae.getOperator());
            builder.append(' ');
            Texts.append(builder, ae.getRightExpression());
            if (!isRoot && !isNegated) {
                builder.append(')');
            }
            return builder;
        }
        if (expression instanceof LogicalExpression) {
            LogicalExpression ble = (LogicalExpression)expression;
            if (!isRoot && !isNegated) {
                builder.append('(');
            }
            Texts.append(builder, ble.getLeftExpression());
            builder.append(' ');
            Texts.append(builder, ble.getOperator());
            builder.append(' ');
            Texts.append(builder, ble.getRightExpression());
            if (!isRoot && !isNegated) {
                builder.append(')');
            }
            return builder;
        }
        if (expression instanceof ComparisonExpression) {
            ComparisonExpression ce = (ComparisonExpression)expression;
            if (!isRoot && !isNegated) {
                builder.append('(');
            }
            Texts.append(builder, ce.getLeftExpression());
            builder.append(' ');
            Texts.append(builder, ce.getOperator());
            builder.append(' ');
            Texts.append(builder, ce.getRightExpression());
            if (!isRoot && !isNegated) {
                builder.append(')');
            }
            return builder;
        }
        if (expression instanceof ObjectVariableExpression) {
            ObjectVariableExpression ove = (ObjectVariableExpression)expression;
            if (ove.getObject() == null) {
                return builder.append(ove.getObject());
            }
            return builder.append(((ObjectVariableExpression)expression).getObject().getName());
        }
        if (expression instanceof PrimitiveVariableExpression) {
            PrimitiveVariableExpression ove = (PrimitiveVariableExpression)expression;
            if (ove.getPrimitiveVariable() == null) {
                return builder.append(ove.getPrimitiveVariable());
            }
            return builder.append(((PrimitiveVariableExpression)expression).getPrimitiveVariable().getName());
        }
        if (expression instanceof AttributeValueExpression) {
            AttributeValueExpression ave = (AttributeValueExpression)expression;
            if (ave.getObject() == null) {
                builder.append(ave.getObject());
            } else {
                builder.append(ave.getObject().getName());
            }
            builder.append('.');
            if (ave.getAttribute() == null) {
                builder.append(ave.getAttribute());
            } else {
                builder.append(ave.getAttribute().getName());
            }
            return builder;
        }
        if (expression instanceof MethodCallExpression) {
            MethodCallExpression mce = (MethodCallExpression)expression;
            return Texts.append(builder, mce.getOpaqueCallable());
        }
        if (expression instanceof ParameterExpression) {
            ParameterExpression pe = (ParameterExpression)expression;
            return Texts.append(builder, pe.getParameter());
        }
        if (expression instanceof CollectionSizeExpression) {
            CollectionSizeExpression cse = (CollectionSizeExpression)expression;
            if (cse.getSet() == null) {
                return builder.append(cse.getSet());
            }
            return builder.append(cse.getSet().getName());
        }
        if (expression instanceof ExceptionVariableExpression) {
            ExceptionVariableExpression eve = (ExceptionVariableExpression)expression;
            if (eve.getExceptionVariable() == null) {
                return builder.append(eve.getExceptionVariable());
            }
            return builder.append(eve.getExceptionVariable().getName());
        }
        return builder.append(expression);
    }

    private static StringBuilder append(StringBuilder builder, ArithmeticOperator operator) {
        switch (operator) {
            case PLUS: {
                return builder.append('+');
            }
            case MINUS: {
                return builder.append('-');
            }
            case TIMES: {
                return builder.append('*');
            }
            case DIVIDE: {
                return builder.append('/');
            }
            case MODULO: {
                return builder.append('%');
            }
        }
        return builder.append(operator);
    }

    private static StringBuilder append(StringBuilder builder, LogicOperator operator) {
        switch (operator) {
            case AND: {
                return builder.append("AND");
            }
            case EQUIVALENT: {
                return builder.append("EQUIV");
            }
            case IMPLY: {
                return builder.append("IMPLY");
            }
            case OR: {
                return builder.append("OR");
            }
            case XOR: {
                return builder.append("XOR");
            }
        }
        return builder.append(operator);
    }

    private static String get(Expression element) {
        if (element instanceof ComparisonExpression) {
            return Texts.get((ComparisonExpression)element);
        }
        if (element instanceof AttributeValueExpression) {
            return Texts.get((Expression)((AttributeValueExpression)element));
        }
        if (element instanceof PrimitiveVariableExpression) {
            return Texts.get((Expression)((PrimitiveVariableExpression)element));
        }
        if (element instanceof LiteralExpression) {
            return Texts.get((Expression)((LiteralExpression)element));
        }
        if (element instanceof TextualExpression) {
            return Texts.get((Expression)((TextualExpression)element));
        }
        return String.valueOf(element);
    }

    private static String get(ComparisonExpression element) {
        StringBuilder text = new StringBuilder();
        text.append(Texts.get(element.getLeftExpression()));
        text.append(' ');
        Texts.append(text, element.getOperator());
        text.append(' ');
        text.append(Texts.get(element.getRightExpression()));
        return text.toString();
    }

    private static StringBuilder append(StringBuilder builder, ComparingOperator operator) {
        switch (operator) {
            case EQUAL: {
                return builder.append('=');
            }
            case GREATER: {
                return builder.append('>');
            }
            case GREATER_OR_EQUAL: {
                return builder.append("\u2265");
            }
            case LESS: {
                return builder.append('<');
            }
            case LESS_OR_EQUAL: {
                return builder.append("\u2264");
            }
            case REGULAR_EXPRESSION: {
                return builder.append("regex");
            }
            case UNEQUAL: {
                return builder.append("\u2260");
            }
        }
        return builder;
    }

    private static StringBuilder append(StringBuilder builder, OpaqueCallable callable) {
        if (callable == null) {
            return builder.append(callable);
        }
        builder.append(callable.getName());
        return builder;
    }

    private static StringBuilder append(StringBuilder builder, ParameterExtension parameter) {
        if (parameter == null) {
            return builder.append(parameter);
        }
        return EcoreTextUtil.append((StringBuilder)builder, (EParameter)parameter.getParameter());
    }

    private static StringBuilder append(StringBuilder builder, StoryPattern element) {
        switch (element.getBindingSemantics()) {
            case MANDATORY: {
                builder.append("mandatory");
                break;
            }
            case NEGATIVE: {
                builder.append("negative");
                break;
            }
            case OPTIONAL: {
                builder.append("optional");
                break;
            }
        }
        builder.append(' ');
        builder.append("pattern");
        return builder;
    }
}

