/*
 * Decompiled with CFR 0.152.
 */
package org.storydriven.storydiagrams.diagram.interpreter.wizards;

import de.mdelab.sdm.interpreter.core.variables.Variable;
import java.util.Map;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.storydriven.storydiagrams.diagram.custom.DiagramImages;
import org.storydriven.storydiagrams.diagram.interpreter.providers.ResultContentProvider;
import org.storydriven.storydiagrams.diagram.interpreter.providers.ResultLabelProvider;
import org.storydriven.storydiagrams.diagram.interpreter.wizards.InterpreteActivityWizard;

public class ResultWizardPage
extends WizardPage {
    private Composite resultComposite;
    private Composite exceptionComposite;
    private Composite resourceChangedComposite;
    private TreeViewer resultViewer;
    private Text exceptionText;
    private Button saveResourceButton;
    private ResultLabelProvider labelProvider;

    protected ResultWizardPage() {
        super(ResultWizardPage.class.getName());
        this.setTitle("Interpreter Results");
        this.setDescription("The activity has been interpreted.");
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            Throwable throwable;
            this.setPageComplete(false);
            this.resourceChangedComposite.setVisible(false);
            this.saveResourceButton.setSelection(false);
            this.getWizard().setSaveResource(false);
            this.resultViewer.setInput(null);
            this.resultComposite.setVisible(false);
            this.exceptionText.setText("");
            this.exceptionComposite.setVisible(false);
            Map<String, Variable<EClassifier>> results = this.getWizard().getResults();
            if (results != null) {
                Variable<EClassifier> result = results.get("resultValue");
                this.labelProvider.setResult(result);
                this.resultComposite.setVisible(true);
                this.resultViewer.setInput(result);
                if (this.getWizard().getResource() != null) {
                    this.resourceChangedComposite.setVisible(this.getWizard().getResource().isModified());
                    this.saveResourceButton.setSelection(true);
                    this.getWizard().setSaveResource(true);
                }
                this.setPageComplete(true);
            }
            if ((throwable = this.getWizard().getThrowable()) != null) {
                this.exceptionComposite.setVisible(true);
                this.exceptionText.setText(String.valueOf(throwable));
            }
        }
    }

    public InterpreteActivityWizard getWizard() {
        return (InterpreteActivityWizard)super.getWizard();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().margins(6, 6).applyTo(composite);
        this.resultComposite = new Composite(composite, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.resultComposite);
        GridLayoutFactory.fillDefaults().applyTo(this.resultComposite);
        Label resultLabel = new Label(this.resultComposite, 16448);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)resultLabel);
        resultLabel.setText("The following represents the result of the interpretation.");
        this.resultViewer = new TreeViewer(this.resultComposite, 2052);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.resultViewer.getControl());
        this.resultViewer.setAutoExpandLevel(-1);
        this.labelProvider = new ResultLabelProvider();
        this.resultViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.resultViewer.setContentProvider((IContentProvider)new ResultContentProvider());
        this.exceptionComposite = new Composite(composite, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.exceptionComposite);
        GridLayoutFactory.fillDefaults().applyTo(this.exceptionComposite);
        Label exceptionLabel = new Label(this.exceptionComposite, 16448);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)exceptionLabel);
        exceptionLabel.setText("The following exception occurred during the interpretation.");
        this.exceptionText = new Text(this.exceptionComposite, 2818);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.exceptionText);
        this.exceptionText.setEditable(false);
        this.resourceChangedComposite = new Composite(composite, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(this.resourceChangedComposite);
        Label resourceChangedImageLabel = new Label(this.resourceChangedComposite, 16384);
        GridDataFactory.fillDefaults().align(0x1000000, 1).applyTo((Control)resourceChangedImageLabel);
        resourceChangedImageLabel.setImage(DiagramImages.getImage((String)"icons/controls/warning.png"));
        Label resourceChangedLabel = new Label(this.resourceChangedComposite, 16384);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)resourceChangedLabel);
        resourceChangedLabel.setText("The host graph resource has been modified during the interpretation.");
        this.saveResourceButton = new Button(this.resourceChangedComposite, 32);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.saveResourceButton);
        this.saveResourceButton.setSelection(true);
        this.saveResourceButton.setText("Save the changed resource");
        this.saveResourceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResultWizardPage.this.getWizard().setSaveResource(ResultWizardPage.this.saveResourceButton.getSelection());
            }
        });
        this.setPageComplete(false);
        this.setControl((Control)composite);
    }
}

