/*
 * Decompiled with CFR 0.152.
 */
package org.storydriven.storydiagrams.diagram.ocl;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String ID = "org.storydriven.storydiagrams.diagram.ocl";
    private static Activator instance;

    public void logError(String message) {
        this.logError(message, null);
    }

    public void logError(String message, Throwable exception) {
        if (message == null && exception != null) {
            message = exception.getMessage();
        }
        this.log(4, message, exception);
    }

    public void logInfo(String message) {
        this.logInfo(message, null);
    }

    public void logInfo(String message, Throwable exception) {
        if (message == null && exception != null) {
            message = exception.getMessage();
        }
        this.log(1, message, exception);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        instance = this;
        this.addImages();
    }

    private void addImages() {
        this.addImage("icons/kind/association_class.png");
        this.addImage("icons/kind/signal.png");
        this.addImage("icons/kind/state.png");
        this.addImage("icons/kind/variable.png");
    }

    private void addImage(String path) {
        ImageDescriptor desc = Activator.imageDescriptorFromPlugin((String)this.getID(), (String)path);
        if (desc != null) {
            this.getImageRegistry().put(path, desc);
        } else {
            this.logWarning("The image under '" + path + "' could not be cached. It probably does not exist.");
        }
    }

    public void logWarning(String message) {
        this.logWarning(message, null);
    }

    public void logWarning(String message, Throwable exception) {
        if (message == null && exception != null) {
            message = exception.getMessage();
        }
        this.log(2, message, exception);
    }

    private void log(int severity, String message, Throwable throwable) {
        this.getLog().log((IStatus)new Status(severity, this.getID(), message, throwable));
    }

    protected String getID() {
        return ID;
    }

    public static Activator getInstance() {
        return instance;
    }

    public Image getImage(String key) {
        if (this.getImageRegistry().get(key) == null) {
            return ImageDescriptor.getMissingImageDescriptor().createImage();
        }
        return this.getImageRegistry().get(key);
    }

    public ImageDescriptor getImageDescriptor(String key) {
        if (this.getImageRegistry().getDescriptor(key) == null) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
        return this.getImageRegistry().getDescriptor(key);
    }

    public void stop(BundleContext context) throws Exception {
        instance = null;
        super.stop(context);
    }
}

