/*
 * Decompiled with CFR 0.152.
 */
package org.storydriven.storydiagrams.diagram.ocl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.helper.Choice;
import org.eclipse.ocl.helper.ChoiceKind;
import org.eclipse.swt.graphics.Image;
import org.storydriven.storydiagrams.diagram.custom.DiagramImages;
import org.storydriven.storydiagrams.diagram.ocl.OCLDocument;
import org.storydriven.storydiagrams.diagram.ocl.OCLImages;

public class OCLCompletionProcessor
implements IContentAssistProcessor {
    private static final Object NAME_SELF = "self";
    private static char[] ACTIVATION = new char[]{'.', ':', '>', '^', ' '};
    private static char[] NO_CHARS = new char[0];
    private static ICompletionProposal[] NO_COMPLETIONS = new ICompletionProposal[0];
    private static IContextInformation[] NO_CONTEXTS = new IContextInformation[0];

    /*
     * Unable to fully structure code
     */
    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        doc = (OCLDocument)viewer.getDocument();
        replacementOffset = offset;
        try {
            if (offset > 0 && doc.getChar(offset - 1) == '>' && (offset < 2 || doc.getChar(offset - 2) != '-')) {
                return OCLCompletionProcessor.NO_COMPLETIONS;
            }
            if (offset <= 0 || doc.getChar(offset - 1) != ':' || offset >= 2 && doc.getChar(offset - 2) == ':') ** GOTO lbl-1000
            return OCLCompletionProcessor.NO_COMPLETIONS;
            {
                trigger = doc.getChar(--replacementOffset);
                switch (trigger) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': 
                    case '(': 
                    case '.': 
                    case ':': 
                    case '>': 
                    case '[': 
                    case '^': 
                    case '{': {
                        ++replacementOffset;
                        break block5;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        if (replacementOffset > 0) continue block5;
                        break block5;
                    }
                }
            }
        }
        catch (BadLocationException e) {
            return OCLCompletionProcessor.NO_COMPLETIONS;
        }
        choices = doc.getOCLChoices(offset);
        return this.createCompletions(choices, replacementOffset, offset - replacementOffset);
    }

    private ICompletionProposal[] createCompletions(List<Choice> choices, int replacementOffset, int replacementLength) {
        ArrayList<CompletionProposal> result = new ArrayList<CompletionProposal>();
        this.sortChoices(choices);
        for (Choice choice : choices) {
            int cursor;
            String display;
            String text = choice.getName();
            Image image = OCLCompletionProcessor.getImage(choice);
            switch (choice.getKind()) {
                case OPERATION: 
                case SIGNAL: {
                    text = String.valueOf(text) + "()";
                    display = choice.getDescription();
                    cursor = text.length() - 1;
                    break;
                }
                case PROPERTY: 
                case ENUMERATION_LITERAL: 
                case ASSOCIATION_CLASS: 
                case VARIABLE: {
                    display = String.valueOf(text) + " : " + choice.getDescription();
                    cursor = text.length();
                    break;
                }
                default: {
                    display = text;
                    cursor = text.length();
                }
            }
            result.add(new CompletionProposal(text, replacementOffset, replacementLength, cursor, image, display, null, null));
        }
        return result.toArray(new ICompletionProposal[result.size()]);
    }

    private void sortChoices(List<Choice> choices) {
        Collections.sort(choices, new Comparator<Choice>(){

            @Override
            public int compare(Choice o1, Choice o2) {
                int result = OCLCompletionProcessor.getRank(o1) - OCLCompletionProcessor.getRank(o2);
                if (result == 0 && !ChoiceKind.VARIABLE.equals((Object)o1.getKind()) && !ChoiceKind.VARIABLE.equals((Object)o2.getKind())) {
                    result = o1.getName().compareTo(o2.getName());
                }
                return result;
            }
        });
    }

    private static Image getImage(Choice choice) {
        Variable variable;
        if (choice.getElement() instanceof Variable && NAME_SELF.equals((variable = (Variable)choice.getElement()).getName())) {
            return null;
        }
        switch (choice.getKind()) {
            case PROPERTY: {
                return DiagramImages.getImage((String)"icons/elements/ecore/EAttribute.png");
            }
            case OPERATION: {
                return DiagramImages.getImage((String)"icons/elements/ecore/EOperation.png");
            }
            case VARIABLE: {
                return OCLImages.getImage("icons/kind/variable.png");
            }
            case PACKAGE: {
                return DiagramImages.getImage((String)"icons/elements/ecore/EPackage.png");
            }
            case TYPE: {
                if (choice.getElement() instanceof EClass) {
                    return DiagramImages.getImage((String)"icons/elements/ecore/EClass.png");
                }
                if (choice.getElement() instanceof EDataType) {
                    if (choice.getElement() instanceof EEnum) {
                        return DiagramImages.getImage((String)"icons/elements/ecore/EEnum.png");
                    }
                    return DiagramImages.getImage((String)"icons/elements/ecore/EDataType.png");
                }
                return null;
            }
            case ENUMERATION_LITERAL: {
                return DiagramImages.getImage((String)"icons/elements/ecore/EEnumLiteral.png");
            }
            case STATE: {
                return OCLImages.getImage("icons/kind/state.png");
            }
            case ASSOCIATION_CLASS: {
                return OCLImages.getImage("icons/kind/association_class.png");
            }
            case SIGNAL: {
                return OCLImages.getImage("icons/kind/signal.png");
            }
        }
        return null;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return NO_CONTEXTS;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return ACTIVATION;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return NO_CHARS;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    private static int getRank(Choice choice) {
        Variable variable;
        if (choice.getElement() instanceof Variable && NAME_SELF.equals((variable = (Variable)choice.getElement()).getName())) {
            return Integer.MAX_VALUE;
        }
        switch (choice.getKind()) {
            case VARIABLE: {
                return 0;
            }
            case PROPERTY: {
                return 1;
            }
            case OPERATION: {
                return 2;
            }
            case PACKAGE: {
                return 3;
            }
            case TYPE: {
                return 4;
            }
            case ENUMERATION_LITERAL: {
                return 5;
            }
            case STATE: {
                return 6;
            }
            case ASSOCIATION_CLASS: {
                return 7;
            }
            case SIGNAL: {
                return 8;
            }
        }
        return Integer.MAX_VALUE;
    }
}

