/*
 * Decompiled with CFR 0.152.
 */
package org.storydriven.storydiagrams.interpreter.facade;

import de.mdelab.sdm.interpreter.core.facade.IDecisionNodeFacade;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.storydriven.core.expressions.Expression;
import org.storydriven.storydiagrams.activities.ActivityEdge;
import org.storydriven.storydiagrams.activities.ActivityNode;
import org.storydriven.storydiagrams.activities.EdgeGuard;
import org.storydriven.storydiagrams.activities.JunctionNode;
import org.storydriven.storydiagrams.interpreter.facade.StoryDrivenActivityNodeFacade;

public class StoryDrivenJunctionNodeFacade
extends StoryDrivenActivityNodeFacade
implements IDecisionNodeFacade<ActivityNode, ActivityEdge, Expression> {
    public Map<Expression, ActivityEdge> getConditionalNextEdges(ActivityNode activityNode) {
        assert (activityNode != null);
        assert (activityNode instanceof JunctionNode);
        HashMap<Expression, ActivityEdge> map = new HashMap<Expression, ActivityEdge>();
        if (activityNode.getOutgoings().size() == 1) {
            return Collections.emptyMap();
        }
        for (ActivityEdge edge : activityNode.getOutgoings()) {
            if (edge.getGuard() == EdgeGuard.BOOL) {
                map.put(edge.getGuardExpression(), edge);
                continue;
            }
            assert (edge.getGuard() == EdgeGuard.ELSE);
        }
        return map;
    }

    public ActivityEdge getUnconditionalNextEdge(ActivityNode activityNode) {
        assert (activityNode != null);
        assert (activityNode instanceof JunctionNode);
        if (activityNode.getOutgoings().size() == 1) {
            return (ActivityEdge)activityNode.getOutgoings().get(0);
        }
        for (ActivityEdge edge : activityNode.getOutgoings()) {
            if (edge.getGuard() == EdgeGuard.ELSE) {
                return edge;
            }
            assert (edge.getGuard() == EdgeGuard.BOOL);
        }
        return null;
    }
}

