/*
 * Decompiled with CFR 0.152.
 */
package org.storydriven.storydiagrams.diagram.custom.util;

import java.util.LinkedHashMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.storydriven.core.expressions.Expression;
import org.storydriven.core.expressions.TextualExpression;
import org.storydriven.core.expressions.common.ArithmeticExpression;
import org.storydriven.core.expressions.common.ArithmeticOperator;
import org.storydriven.core.expressions.common.ComparingOperator;
import org.storydriven.core.expressions.common.ComparisonExpression;
import org.storydriven.core.expressions.common.LiteralExpression;
import org.storydriven.core.expressions.common.LogicOperator;
import org.storydriven.core.expressions.common.LogicalExpression;
import org.storydriven.core.expressions.common.UnaryExpression;
import org.storydriven.storydiagrams.activities.Activity;
import org.storydriven.storydiagrams.activities.ActivityCallNode;
import org.storydriven.storydiagrams.activities.ActivityFinalNode;
import org.storydriven.storydiagrams.activities.EdgeGuard;
import org.storydriven.storydiagrams.activities.InitialNode;
import org.storydriven.storydiagrams.activities.MatchingStoryNode;
import org.storydriven.storydiagrams.activities.expressions.ExceptionVariableExpression;
import org.storydriven.storydiagrams.calls.Callable;
import org.storydriven.storydiagrams.calls.OpaqueCallable;
import org.storydriven.storydiagrams.calls.ParameterBinding;
import org.storydriven.storydiagrams.calls.ParameterExtension;
import org.storydriven.storydiagrams.calls.expressions.MethodCallExpression;
import org.storydriven.storydiagrams.calls.expressions.ParameterExpression;
import org.storydriven.storydiagrams.diagram.custom.util.ActivityUtil;
import org.storydriven.storydiagrams.diagram.custom.util.EcoreTextUtil;
import org.storydriven.storydiagrams.patterns.AbstractVariable;
import org.storydriven.storydiagrams.patterns.AttributeAssignment;
import org.storydriven.storydiagrams.patterns.BindingState;
import org.storydriven.storydiagrams.patterns.Constraint;
import org.storydriven.storydiagrams.patterns.LinkVariable;
import org.storydriven.storydiagrams.patterns.ObjectVariable;
import org.storydriven.storydiagrams.patterns.PrimitiveVariable;
import org.storydriven.storydiagrams.patterns.expressions.AttributeValueExpression;
import org.storydriven.storydiagrams.patterns.expressions.CollectionSizeExpression;
import org.storydriven.storydiagrams.patterns.expressions.ObjectVariableExpression;
import org.storydriven.storydiagrams.patterns.expressions.PrimitiveVariableExpression;

public final class TextUtil {
    private static final String STEREOTYPE_PREFIX = "\u00ab";
    private static final String STEREOTYPE_SUFFIX = "\u00bb";
    private static final String EMPTY = "";

    private TextUtil() {
    }

    public static String getText(InitialNode InitialNode2) {
        return TextUtil.append(new StringBuilder(), InitialNode2).toString();
    }

    private static StringBuilder append(StringBuilder builder, InitialNode InitialNode2) {
        Activity activity = ActivityUtil.getActivity(InitialNode2);
        EOperation operation = ActivityUtil.getEOperation(activity);
        if (operation != null) {
            EcoreTextUtil.append(builder, operation);
        } else {
            builder.append(activity.getName());
            builder.append('(');
            EList<EParameter> in = activity.getInParameters();
            if (!in.isEmpty()) {
                int i = 0;
                while (i < in.size()) {
                    builder.append(((EParameter)in.get(i)).getName());
                    builder.append(':');
                    builder.append(' ');
                    EcoreTextUtil.append(builder, ((EParameter)in.get(i)).getEType());
                    if (i < in.size() - 1) {
                        builder.append(',');
                        builder.append(' ');
                    }
                    ++i;
                }
            }
            builder.append(')');
            builder.append(':');
            builder.append(' ');
            EList<EParameter> out = activity.getOutParameters();
            if (out.isEmpty()) {
                builder.append("void");
            } else {
                if (out.size() > 1) {
                    builder.append('<');
                }
                int i = 0;
                while (i < out.size()) {
                    builder.append(((EParameter)out.get(i)).getName());
                    builder.append(':');
                    builder.append(' ');
                    EcoreTextUtil.append(builder, ((EParameter)out.get(i)).getEType());
                    if (i < out.size() - 1) {
                        builder.append(',');
                        builder.append(' ');
                    }
                    ++i;
                }
                if (out.size() > 1) {
                    builder.append('>');
                }
            }
        }
        return builder;
    }

    public static String getText(MatchingStoryNode element) {
        Activity activity = ActivityUtil.getActivity(element);
        StringBuilder builder = new StringBuilder();
        TextUtil.append(builder, activity);
        builder.append(' ');
        builder.append(STEREOTYPE_SUFFIX);
        builder.append(' ');
        builder.append(element.getName());
        return builder.toString();
    }

    public static String getText(Callable callable) {
        if (callable == null) {
            return EMPTY;
        }
        if (callable instanceof Activity) {
            return TextUtil.getText((Activity)callable);
        }
        return String.valueOf(callable);
    }

    public static String getText(Activity activity) {
        return TextUtil.append(new StringBuilder(), activity).toString();
    }

    private static StringBuilder append(StringBuilder builder, Activity activity) {
        builder.append(activity.getName());
        builder.append('(');
        EList<EParameter> in = activity.getInParameters();
        if (!in.isEmpty()) {
            int i = 0;
            while (i < in.size()) {
                EcoreTextUtil.append(builder, ((EParameter)in.get(i)).getEType());
                if (i < in.size() - 1) {
                    builder.append(',');
                    builder.append(' ');
                }
                ++i;
            }
        }
        builder.append(')');
        EList<EParameter> out = activity.getOutParameters();
        if (!out.isEmpty()) {
            builder.append(' ');
            builder.append(':');
            builder.append(' ');
            if (out.size() > 1) {
                builder.append('<');
            }
            int i = 0;
            while (i < out.size()) {
                EcoreTextUtil.append(builder, ((EParameter)out.get(i)).getEType());
                if (i < out.size() - 1) {
                    builder.append(',');
                    builder.append(' ');
                }
                ++i;
            }
            if (out.size() > 1) {
                builder.append('>');
            }
        }
        return builder;
    }

    public static String getText(Constraint element) {
        return TextUtil.append(new StringBuilder(), element).toString();
    }

    private static StringBuilder append(StringBuilder builder, Constraint element) {
        return TextUtil.append(builder, element.getConstraintExpression());
    }

    public static String getText(ActivityFinalNode ActivityFinalNode2) {
        if (!ActivityFinalNode2.getReturnValues().isEmpty()) {
            StringBuilder builder = new StringBuilder();
            EList<Expression> values = ActivityFinalNode2.getReturnValues();
            int i = 0;
            while (i < values.size()) {
                TextUtil.append(builder, (Expression)values.get(i));
                if (i < values.size() - 1) {
                    builder.append(',');
                    builder.append(' ');
                }
                ++i;
            }
            return builder.toString();
        }
        return null;
    }

    public static String getText(ActivityCallNode node) {
        if (node.getCallee() != null) {
            LinkedHashMap<EParameter, Expression> map = new LinkedHashMap<EParameter, Expression>();
            for (ParameterBinding binding : node.getOwnedParameterBindings()) {
                map.put(binding.getParameter(), binding.getValueExpression());
            }
            StringBuilder builder = new StringBuilder();
            EList<EParameter> out = node.getCallee().getOutParameters();
            int i = 0;
            while (i < out.size()) {
                builder.append(TextUtil.getText((Expression)map.get(out.get(i))));
                if (i < out.size() - 1) {
                    builder.append(',');
                    builder.append(' ');
                } else {
                    builder.append(' ');
                    builder.append(':');
                    builder.append('=');
                    builder.append(' ');
                }
                ++i;
            }
            if (node.getCallee() instanceof Activity) {
                builder.append(((Activity)node.getCallee()).getName());
            }
            builder.append('(');
            EList<EParameter> in = node.getCallee().getInParameters();
            int i2 = 0;
            while (i2 < in.size()) {
                builder.append(TextUtil.getText((Expression)map.get(in.get(i2))));
                if (i2 < in.size() - 1) {
                    builder.append(',');
                    builder.append(' ');
                }
                ++i2;
            }
            builder.append(')');
            return builder.toString();
        }
        return "\u00abno callee\u00bb";
    }

    public static String getText(Expression expression) {
        return TextUtil.append(new StringBuilder(), expression).toString();
    }

    public static StringBuilder append(StringBuilder builder, Expression expression) {
        if (expression == null) {
            return builder.append(expression);
        }
        boolean isRoot = !(expression.eContainer() instanceof Expression);
        boolean isNegated = expression.eContainer() instanceof UnaryExpression;
        if (expression instanceof LiteralExpression) {
            LiteralExpression le = (LiteralExpression)expression;
            builder.append(le.getValue());
            return builder;
        }
        if (expression instanceof TextualExpression) {
            TextualExpression te = (TextualExpression)expression;
            if (isRoot) {
                return builder.append(te.getExpressionText());
            }
            builder.append('{');
            builder.append(' ');
            builder.append(te.getExpressionText());
            builder.append(' ');
            builder.append('}');
            return builder;
        }
        if (expression instanceof UnaryExpression) {
            UnaryExpression ne = (UnaryExpression)expression;
            builder.append("not");
            builder.append('(');
            TextUtil.append(builder, ne.getEnclosedExpression());
            builder.append(')');
            return builder;
        }
        if (expression instanceof ArithmeticExpression) {
            ArithmeticExpression ae = (ArithmeticExpression)expression;
            if (!isRoot && !isNegated) {
                builder.append('(');
            }
            TextUtil.append(builder, ae.getLeftExpression());
            builder.append(' ');
            TextUtil.append(builder, ae.getOperator());
            builder.append(' ');
            TextUtil.append(builder, ae.getRightExpression());
            if (!isRoot && !isNegated) {
                builder.append(')');
            }
            return builder;
        }
        if (expression instanceof LogicalExpression) {
            LogicalExpression ble = (LogicalExpression)expression;
            if (!isRoot && !isNegated) {
                builder.append('(');
            }
            TextUtil.append(builder, ble.getLeftExpression());
            builder.append(' ');
            TextUtil.append(builder, ble.getOperator());
            builder.append(' ');
            TextUtil.append(builder, ble.getRightExpression());
            if (!isRoot && !isNegated) {
                builder.append(')');
            }
            return builder;
        }
        if (expression instanceof ComparisonExpression) {
            ComparisonExpression ce = (ComparisonExpression)expression;
            if (!isRoot && !isNegated) {
                builder.append('(');
            }
            TextUtil.append(builder, ce.getLeftExpression());
            builder.append(' ');
            TextUtil.append(builder, ce.getOperator());
            builder.append(' ');
            TextUtil.append(builder, ce.getRightExpression());
            if (!isRoot && !isNegated) {
                builder.append(')');
            }
            return builder;
        }
        if (expression instanceof ObjectVariableExpression) {
            ObjectVariableExpression ove = (ObjectVariableExpression)expression;
            if (ove.getObject() == null) {
                return builder.append(ove.getObject());
            }
            return builder.append(((ObjectVariableExpression)expression).getObject().getName());
        }
        if (expression instanceof PrimitiveVariableExpression) {
            PrimitiveVariableExpression ove = (PrimitiveVariableExpression)expression;
            if (ove.getPrimitiveVariable() == null) {
                return builder.append(ove.getPrimitiveVariable());
            }
            return builder.append(((PrimitiveVariableExpression)expression).getPrimitiveVariable().getName());
        }
        if (expression instanceof AttributeValueExpression) {
            AttributeValueExpression ave = (AttributeValueExpression)expression;
            if (ave.getObject() == null) {
                builder.append(ave.getObject());
            } else {
                builder.append(ave.getObject().getName());
            }
            builder.append('.');
            if (ave.getAttribute() == null) {
                builder.append(ave.getAttribute());
            } else {
                builder.append(ave.getAttribute().getName());
            }
            return builder;
        }
        if (expression instanceof MethodCallExpression) {
            MethodCallExpression mce = (MethodCallExpression)expression;
            return TextUtil.append(builder, mce.getOpaqueCallable());
        }
        if (expression instanceof ParameterExpression) {
            ParameterExpression pe = (ParameterExpression)expression;
            return TextUtil.append(builder, pe.getParameter());
        }
        if (expression instanceof CollectionSizeExpression) {
            CollectionSizeExpression cse = (CollectionSizeExpression)expression;
            if (cse.getSet() == null) {
                return builder.append(cse.getSet());
            }
            return builder.append(cse.getSet().getName());
        }
        if (expression instanceof ExceptionVariableExpression) {
            ExceptionVariableExpression eve = (ExceptionVariableExpression)expression;
            if (eve.getExceptionVariable() == null) {
                return builder.append(eve.getExceptionVariable());
            }
            return builder.append(eve.getExceptionVariable().getName());
        }
        return builder.append(expression);
    }

    public static String getText(ArithmeticOperator operator) {
        return TextUtil.append(new StringBuilder(), operator).toString();
    }

    private static StringBuilder append(StringBuilder builder, ArithmeticOperator operator) {
        switch (operator) {
            case PLUS: {
                return builder.append('+');
            }
            case MINUS: {
                return builder.append('-');
            }
            case TIMES: {
                return builder.append('*');
            }
            case DIVIDE: {
                return builder.append('/');
            }
            case MODULO: {
                return builder.append('%');
            }
        }
        return builder.append(operator);
    }

    public static String getText(LogicOperator operator) {
        return TextUtil.append(new StringBuilder(), operator).toString();
    }

    private static StringBuilder append(StringBuilder builder, LogicOperator operator) {
        switch (operator) {
            case AND: {
                return builder.append("AND");
            }
            case EQUIVALENT: {
                return builder.append("EQUIV");
            }
            case IMPLY: {
                return builder.append("IMPLY");
            }
            case OR: {
                return builder.append("OR");
            }
            case XOR: {
                return builder.append("XOR");
            }
        }
        return builder.append(operator);
    }

    public static String getText(ComparingOperator operator) {
        return TextUtil.append(new StringBuilder(), operator).toString();
    }

    private static StringBuilder append(StringBuilder builder, ComparingOperator operator) {
        switch (operator) {
            case EQUAL: {
                return builder.append('=');
            }
            case GREATER: {
                return builder.append('>');
            }
            case GREATER_OR_EQUAL: {
                return builder.append("\u2265");
            }
            case LESS: {
                return builder.append('<');
            }
            case LESS_OR_EQUAL: {
                return builder.append("\u2264");
            }
            case REGULAR_EXPRESSION: {
                return builder.append("regex");
            }
            case UNEQUAL: {
                return builder.append("\u2260");
            }
        }
        return builder;
    }

    private static StringBuilder append(StringBuilder builder, OpaqueCallable callable) {
        if (callable == null) {
            return builder.append(callable);
        }
        builder.append(callable.getName());
        return builder;
    }

    private static StringBuilder append(StringBuilder builder, ParameterExtension parameter) {
        if (parameter == null) {
            return builder.append(parameter);
        }
        return EcoreTextUtil.append(builder, parameter.getParameter());
    }

    public static String getText(AttributeAssignment element) {
        return TextUtil.append(new StringBuilder(), element).toString();
    }

    private static StringBuilder append(StringBuilder builder, AttributeAssignment element) {
        if (element.getAttribute() == null) {
            builder.append(element.getAttribute());
        } else {
            builder.append(element.getAttribute().getName());
        }
        builder.append(' ');
        builder.append(':');
        builder.append('=');
        builder.append(' ');
        builder.append(element.getValueExpression());
        return builder;
    }

    public static String getText(AbstractVariable element) {
        return TextUtil.append(new StringBuilder(), element).toString();
    }

    private static StringBuilder append(StringBuilder builder, AbstractVariable element) {
        builder.append(element.getName());
        if (!BindingState.BOUND.equals((Object)element.getBindingState())) {
            if (BindingState.MAYBE_BOUND.equals((Object)element.getBindingState())) {
                builder.append('?');
            }
            builder.append(' ');
            builder.append(':');
            builder.append(' ');
            if (element instanceof ObjectVariable) {
                EcoreTextUtil.append(builder, (EClassifier)((ObjectVariable)element).getClassifier());
            } else if (element instanceof PrimitiveVariable) {
                EcoreTextUtil.append(builder, (EClassifier)((PrimitiveVariable)element).getClassifier());
            }
        }
        return builder;
    }

    public static String getText(EdgeGuard guard) {
        switch (guard) {
            case BOOL: {
                return "[BOOL]";
            }
            case EACH_TIME: {
                return "[EACH_TIME]";
            }
            case ELSE: {
                return "[ELSE]";
            }
            case END: {
                return "[END]";
            }
            case EXCEPTION: {
                return "[EXCEPTION]";
            }
            case FAILURE: {
                return "[FAILURE]";
            }
            case FINALLY: {
                return "[FINALLY]";
            }
            case SUCCESS: {
                return "[SUCCESS]";
            }
        }
        return null;
    }

    public static String getText(LinkVariable link) {
        if (link.getTargetEnd() != null) {
            return link.getTargetEnd().getName();
        }
        return String.valueOf(link.getName());
    }
}

