/*
 * Decompiled with CFR 0.152.
 */
package org.storydriven.storydiagrams.patterns;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum LinkConstraintType implements Enumerator
{
    FIRST(0, "FIRST", "FIRST"),
    LAST(1, "LAST", "LAST"),
    NEXT(2, "NEXT", "NEXT"),
    INDIRECT_SUCCESSOR(3, "INDIRECT_SUCCESSOR", "INDIRECT_SUCCESSOR"),
    INDEX(4, "INDEX", "INDEX");

    public static final int FIRST_VALUE = 0;
    public static final int LAST_VALUE = 1;
    public static final int NEXT_VALUE = 2;
    public static final int INDIRECT_SUCCESSOR_VALUE = 3;
    public static final int INDEX_VALUE = 4;
    private static final LinkConstraintType[] VALUES_ARRAY;
    public static final List<LinkConstraintType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new LinkConstraintType[]{FIRST, LAST, NEXT, INDIRECT_SUCCESSOR, INDEX};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static LinkConstraintType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LinkConstraintType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LinkConstraintType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LinkConstraintType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LinkConstraintType get(int value) {
        switch (value) {
            case 0: {
                return FIRST;
            }
            case 1: {
                return LAST;
            }
            case 2: {
                return NEXT;
            }
            case 3: {
                return INDIRECT_SUCCESSOR;
            }
            case 4: {
                return INDEX;
            }
        }
        return null;
    }

    private LinkConstraintType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

