/*
 * Decompiled with CFR 0.152.
 */
package tools.descartes.dlim.exporter.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.eclipse.core.runtime.Status;
import tools.descartes.dlim.DlimGeneratorPlugin;
import tools.descartes.dlim.generator.ArrivalRateTuple;
import tools.descartes.dlim.util.MathUtil;

public abstract class TimeStampWriter {
    private String endOfLineCharacter = ";";
    private int decimalplaces = 3;
    private double stretch = 1.0;

    protected String getEndOfLineCharacter() {
        return this.endOfLineCharacter;
    }

    protected int getDecimalplaces() {
        return this.decimalplaces;
    }

    protected String formatDoubleForDecimalPlaces(double d) {
        return MathUtil.formatDoubleForDecimalPlaces(d, this.decimalplaces);
    }

    protected double getStretch() {
        return this.stretch;
    }

    protected TimeStampWriter(String endOfLineCharacter) {
        this.endOfLineCharacter = endOfLineCharacter;
    }

    protected TimeStampWriter() {
    }

    public void generateTimeStampsFromArrivalRates(File file, List<ArrivalRateTuple> arrRates, int decimalPlaces, double stretch, double arDevisor) {
        this.stretch = stretch;
        this.decimalplaces = decimalPlaces;
        try {
            PrintWriter timeStampWriter = new PrintWriter(file, "UTF-8");
            ArrivalRateTuple lastTupel = null;
            for (ArrivalRateTuple tuple : arrRates) {
                double step = tuple.getStep(lastTupel);
                double arrRate = tuple.getArrivalRate() / arDevisor;
                double time = tuple.getTimeStamp();
                double tmpStep = step * stretch;
                double tmpTime = time * stretch;
                this.writeTimestampsForArrivalRate(timeStampWriter, step, arrRate, tmpStep, tmpTime);
                lastTupel = tuple;
            }
            timeStampWriter.close();
        }
        catch (FileNotFoundException e) {
            DlimGeneratorPlugin.INSTANCE.log(new Status(1, "tools.descartes.dlim.generator", "FileNotFound, Could not write time stamps.", (Throwable)e));
        }
        catch (UnsupportedEncodingException e) {
            DlimGeneratorPlugin.INSTANCE.log(new Status(1, "tools.descartes.dlim.generator", "UnsupportedEncoding, Could not write time stamps.", (Throwable)e));
        }
    }

    protected abstract void writeTimestampsForArrivalRate(PrintWriter var1, double var2, double var4, double var6, double var8);
}

