/*
 * Decompiled with CFR 0.152.
 */
package tools.descartes.dlim.extractor.utils;

import java.util.ArrayList;
import java.util.List;
import tools.descartes.dlim.DlimPackage;
import tools.descartes.dlim.Sequence;
import tools.descartes.dlim.TimeDependentFunctionContainer;
import tools.descartes.dlim.assistant.CalibrationException;
import tools.descartes.dlim.extractor.utils.BasicSeasonalExtractionUtilities;
import tools.descartes.dlim.extractor.utils.ExtractionDataContainer;
import tools.descartes.dlim.extractor.utils.ISplittingRule;
import tools.descartes.dlim.generator.ArrivalRateTuple;

public class BinarySeasonalSplitter {
    private static int globalPartialSeasonalsCounter = 0;
    private static ExtractionDataContainer globalContainer;
    private List<ArrivalRateTuple> left = new ArrayList<ArrivalRateTuple>();
    private List<ArrivalRateTuple> right = new ArrayList<ArrivalRateTuple>();
    private ExtractionDataContainer cleft;
    private ExtractionDataContainer cright;
    private ExtractionDataContainer container;
    private double splitTime;

    public BinarySeasonalSplitter(ExtractionDataContainer container) {
        this.container = container;
        this.splitArrivalRateList();
    }

    private void splitArrivalRateList() {
        this.splitTime = this.calcSplitTime();
        this.splitArrivalRateListInLeftAndRight(this.container.getArrivalRateList(), this.left, this.right, this.splitTime);
        this.cleft = this.container.clone();
        this.cleft.setArrivalRateList(this.left);
        this.cleft.setDuration(this.splitTime);
        this.cleft.setBeginTime(this.container.getBeginTime());
        this.cright = this.container.clone();
        this.cright.setArrivalRateList(this.right);
        this.cright.setDuration(this.container.getDuration() - this.splitTime);
        this.cright.setBeginTime(this.container.getBeginTime() + this.splitTime);
        ArrayList<ArrivalRateTuple> localMaxesRight = new ArrayList<ArrivalRateTuple>();
        ArrayList<ArrivalRateTuple> localMaxesLeft = new ArrayList<ArrivalRateTuple>();
        ArrayList<ArrivalRateTuple> localMinsRight = new ArrayList<ArrivalRateTuple>();
        ArrayList<ArrivalRateTuple> localMinsLeft = new ArrayList<ArrivalRateTuple>();
        this.splitArrivalRateListInLeftAndRight(this.container.getLocalMaxes(), localMaxesLeft, localMaxesRight, this.splitTime);
        this.splitArrivalRateListInLeftAndRight(this.container.getLocalMins(), localMinsLeft, localMinsRight, this.splitTime);
        this.cleft.setLocalMins(localMinsLeft);
        this.cleft.setLocalMaxes(localMaxesLeft);
        this.cright.setLocalMins(localMinsRight);
        this.cright.setLocalMaxes(localMaxesRight);
    }

    private double calcSplitTime() {
        double splitTime = this.container.getDuration() / 2.0;
        int seasonalcount = (int)(splitTime / this.container.getPeriod());
        return this.container.getPeriod() * (double)seasonalcount;
    }

    public void appendSplitsToRoot(Sequence root, Sequence baseline, ISplittingRule splittingRule) throws CalibrationException {
        if (splittingRule.warrantSplit(this.cleft, this.cright)) {
            BinarySeasonalSplitter leftsplitter = new BinarySeasonalSplitter(this.cleft);
            BinarySeasonalSplitter rightsplitter = new BinarySeasonalSplitter(this.cright);
            leftsplitter.appendSplitsToRoot(root, baseline, splittingRule);
            rightsplitter.appendSplitsToRoot(root, baseline, splittingRule);
        } else {
            Sequence[] partials = this.createPartialSeasonalIteration(this.container);
            globalContainer.getSubContainerList().add(this.container);
            this.appendPartialSeasonalIteration(root, baseline, partials[0], partials[1]);
        }
    }

    private void splitArrivalRateListInLeftAndRight(List<ArrivalRateTuple> original, List<ArrivalRateTuple> left, List<ArrivalRateTuple> right, double splitTime) {
        boolean copyleft = true;
        for (ArrivalRateTuple t : original) {
            if (copyleft) {
                left.add(t);
            }
            if (!(t.getTimeStamp() >= splitTime)) continue;
            copyleft = false;
            ArrivalRateTuple rightTuple = t.clone();
            rightTuple.setTimeStamp(rightTuple.getTimeStamp() - splitTime);
            right.add(rightTuple);
        }
    }

    private Sequence[] createPartialSeasonalIteration(ExtractionDataContainer partialContainer) throws CalibrationException {
        Sequence[] seqs = new Sequence[2];
        seqs[0] = DlimPackage.eINSTANCE.getDlimFactory().createSequence();
        seqs[0].setName("Seasonal" + globalPartialSeasonalsCounter);
        seqs[1] = DlimPackage.eINSTANCE.getDlimFactory().createSequence();
        seqs[1].setName("SeasonalBaseline" + globalPartialSeasonalsCounter++);
        BasicSeasonalExtractionUtilities.extractSeasonalPart(seqs[0], seqs[1], partialContainer);
        return seqs;
    }

    private void appendPartialSeasonalIteration(Sequence root, Sequence baseline, Sequence seasonalroot, Sequence seasonalbaseline) {
        TimeDependentFunctionContainer stdfc = this.createTDFC(seasonalroot);
        TimeDependentFunctionContainer btdfc = this.createTDFC(seasonalbaseline);
        root.getSequenceFunctionContainers().add((Object)stdfc);
        baseline.getSequenceFunctionContainers().add((Object)btdfc);
        root.setTerminateAfterTime(0.0);
        root.setTerminateAfterLoops(1);
        baseline.setTerminateAfterTime(0.0);
        baseline.setTerminateAfterLoops(1);
    }

    private TimeDependentFunctionContainer createTDFC(Sequence seasonalSeq) {
        TimeDependentFunctionContainer stdfc = DlimPackage.eINSTANCE.getDlimFactory().createTimeDependentFunctionContainer();
        stdfc.setDuration(seasonalSeq.getTerminateAfterTime());
        stdfc.setName(seasonalSeq.getName());
        stdfc.setFunction(seasonalSeq);
        return stdfc;
    }

    public static void resetBinarySplittingCount() {
        globalPartialSeasonalsCounter = 0;
    }

    public static ExtractionDataContainer getGlobalContainer() {
        return globalContainer;
    }

    public static void setGlobalContainer(ExtractionDataContainer globalContainer) {
        BinarySeasonalSplitter.globalContainer = globalContainer;
    }
}

