/*
 * Decompiled with CFR 0.152.
 */
package tools.descartes.dlim.generator.util;

import java.util.ArrayList;
import tools.descartes.dlim.generator.ArrivalRateTuple;
import tools.descartes.dlim.generator.ModelEvaluator;

public class ConcurrentModelEvaluator {
    private ModelEvaluator evaluator;
    private int threadCount;
    private double max = 0.0;

    public ConcurrentModelEvaluator(ModelEvaluator evaluator) {
        this(evaluator, Runtime.getRuntime().availableProcessors());
    }

    public ConcurrentModelEvaluator(ModelEvaluator evaluator, int threadCount) {
        this.evaluator = evaluator;
        this.threadCount = threadCount;
    }

    public ArrayList<ArrivalRateTuple> evaluateForTimeStamps(double startTime, double endTime, double step) {
        this.max = 0.0;
        ArrayList<ArrivalRateTuple> tuples = new ArrayList<ArrivalRateTuple>();
        if (this.evaluator.containsReferenceClockObject()) {
            return this.evaluateForTimeStampsSequentially(startTime, endTime, step);
        }
        try {
            EvaluationThread[] threads = new EvaluationThread[this.threadCount];
            int stepcount = (int)((endTime - startTime) / step) + 1;
            int stepsPerThread = stepcount / this.threadCount + 1;
            double threadStartTime = startTime;
            int i = 0;
            while (i < this.threadCount) {
                double threadEndTime = threadStartTime + step * (double)stepsPerThread;
                threadEndTime = Math.min(threadEndTime, endTime);
                threads[i] = new EvaluationThread(threadStartTime, threadEndTime, step);
                threads[i].start();
                threadStartTime = threadEndTime;
                ++i;
            }
            i = 0;
            while (i < this.threadCount) {
                threads[i].join();
                if (threads[i].isDone()) {
                    this.max = Math.max(this.max, threads[i].getMax());
                }
                tuples.addAll(threads[i].getArrivalRates());
                ++i;
            }
        }
        catch (InterruptedException interruptedException) {
            System.out.println("Cuncurrent Evaluation is broken, evaluating sequentially!");
            return this.evaluateForTimeStampsSequentially(startTime, endTime, step);
        }
        return tuples;
    }

    public ArrayList<ArrivalRateTuple> evaluateForTimeStampsSequentially(double startTime, double endTime, double step) {
        ArrayList<ArrivalRateTuple> tuples = new ArrayList<ArrivalRateTuple>();
        double time = startTime;
        while (time < endTime) {
            double y = this.evaluator.getArrivalRateAtTime(time);
            this.max = Math.max(y, this.max);
            tuples.add(new ArrivalRateTuple(time, y));
            time += step;
        }
        return tuples;
    }

    public double getMax() {
        return this.max;
    }

    private class EvaluationThread
    extends Thread {
        private volatile ArrayList<ArrivalRateTuple> tuples = new ArrayList();
        private volatile boolean done = false;
        private double startTime;
        private double endTime;
        private double step;
        private double max;

        public EvaluationThread(double startTime, double endTime, double step) {
            this.startTime = startTime;
            this.endTime = endTime;
            this.step = step;
        }

        public ArrayList<ArrivalRateTuple> getArrivalRates() {
            return this.tuples;
        }

        @Override
        public void run() {
            double time = this.startTime;
            while (time < this.endTime) {
                double y = ConcurrentModelEvaluator.this.evaluator.getArrivalRateAtTime(time);
                this.tuples.add(new ArrivalRateTuple(time, y));
                this.max = Math.max(y, this.max);
                time += this.step;
            }
            this.done = true;
        }

        public boolean isDone() {
            return this.done;
        }

        public synchronized double getMax() {
            return this.max;
        }
    }
}

