/*
 * Decompiled with CFR 0.152.
 */
package tools.descartes.dlim.impl.custom;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import tools.descartes.dlim.DlimGeneratorPlugin;
import tools.descartes.dlim.generator.ArrivalRateTuple;
import tools.descartes.dlim.impl.ArrivalRatesFromFileImpl;

public class CustomArrivalRatesFromFileImpl
extends ArrivalRatesFromFileImpl {
    private List<ArrivalRateTuple> arrRates = new ArrayList<ArrivalRateTuple>();

    protected CustomArrivalRatesFromFileImpl() {
    }

    @Override
    public double getArrivalRate(double x) {
        if (this.arrRates.size() == 0) {
            return 0.0;
        }
        if (x >= this.arrRates.get(this.arrRates.size() - 1).getTimeStamp()) {
            return 0.0;
        }
        if (x < this.arrRates.get(0).getTimeStamp()) {
            if (x >= 0.0) {
                return x / this.arrRates.get(0).getTimeStamp() * this.arrRates.get(0).getArrivalRate();
            }
            return 0.0;
        }
        double assumedStep = this.arrRates.get(0).getStep(null);
        int index = (int)(x / assumedStep);
        if (index >= this.arrRates.size() - 1) {
            index = this.arrRates.size() - 2;
        }
        ArrivalRateTuple lower = this.arrRates.get(index);
        ArrivalRateTuple higher = this.arrRates.get(index + 1);
        while (x < lower.getTimeStamp()) {
            lower = this.arrRates.get(--index);
        }
        while (x >= higher.getTimeStamp()) {
            higher = this.arrRates.get(++index + 1);
        }
        lower = this.arrRates.get(index);
        higher = this.arrRates.get(index + 1);
        return lower.getArrivalRate() + (x - lower.getTimeStamp()) / (higher.getTimeStamp() - lower.getTimeStamp()) * (higher.getArrivalRate() - lower.getArrivalRate());
    }

    @Override
    public void readFile() {
        this.arrRates.clear();
        Path txtFilePath = new Path(this.getFilePath().trim());
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(txtFilePath.toString()));
            while ((line = br.readLine()) != null) {
                String[] numbers = (line = line.substring(0, line.length() - 1)).split(",");
                if (numbers.length < 2) continue;
                double timeStamp = Double.parseDouble(numbers[0].trim());
                double readArrivalRate = Double.parseDouble(numbers[1].trim());
                this.arrRates.add(new ArrivalRateTuple(timeStamp, readArrivalRate));
            }
            br.close();
        }
        catch (IOException e) {
            DlimGeneratorPlugin.INSTANCE.log(new Status(4, "tools.descartes.dlim.generator", "Arrival Rate File does not exist.", (Throwable)e));
        }
    }
}

