/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.discrepancy;

import java.math.BigDecimal;
import java.math.MathContext;
import umontreal.ssj.discrepancy.Discrepancy;
import umontreal.ssj.hups.PointSet;

public abstract class BigDiscrepancy
extends Discrepancy {
    protected BigDecimal[] C1Big;
    protected BigDecimal[] C2Big;
    protected BigDecimal[] C3Big;
    protected BigDecimal[] UBig;
    protected BigDecimal[][] FactorBig;

    protected void reserveCBig(int s) {
        this.C1Big = new BigDecimal[s];
        this.C2Big = new BigDecimal[s];
        this.C3Big = new BigDecimal[s];
        for (int i = 0; i < s; ++i) {
            this.C1Big[i] = new BigDecimal(0);
            this.C2Big[i] = new BigDecimal(0);
            this.C3Big[i] = new BigDecimal(0);
        }
    }

    protected void reserveFactorBig(int n, int s) {
        this.FactorBig = new BigDecimal[n][s];
        for (int i = 0; i < n; ++i) {
            this.FactorBig[i] = new BigDecimal[s];
            for (int j = 0; j < s; ++j) {
                this.FactorBig[i][j] = new BigDecimal(0);
            }
        }
    }

    protected void setUBig(int n) {
        this.UBig = new BigDecimal[n];
        BigDecimal Ninv = new BigDecimal(1);
        Ninv = Ninv.divide(new BigDecimal(n), MathContext.DECIMAL128);
        for (int i = 0; i < n; ++i) {
            this.UBig[i] = new BigDecimal(i);
            this.UBig[i] = this.UBig[i].multiply(Ninv);
        }
    }

    public BigDiscrepancy(double[][] points, int n, int s) {
        super(points, n, s);
    }

    public BigDiscrepancy(double[][] points, int n, int s, double[] gamma) {
        super(points, n, s, gamma);
    }

    public BigDiscrepancy(int n, int s, double[] gamma) {
        super(n, s, gamma);
    }

    public BigDiscrepancy(PointSet set) {
        super(set);
    }

    public BigDiscrepancy() {
    }
}

