/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.hups;

import umontreal.ssj.hups.DigitalSequence;
import umontreal.ssj.util.PrintfFormat;

public class FaureSequence
extends DigitalSequence {
    private static final int MAXDIM = 500;
    private int[][][] v;
    static final int[] primes = new int[]{2, 2, 3, 5, 5, 7, 7, 11, 11, 11, 11, 13, 13, 17, 17, 17, 17, 19, 19, 23, 23, 23, 23, 29, 29, 29, 29, 29, 29, 31, 31, 37, 37, 37, 37, 37, 37, 41, 41, 41, 41, 43, 43, 47, 47, 47, 47, 53, 53, 53, 53, 53, 53, 59, 59, 59, 59, 59, 59, 61, 61, 67, 67, 67, 67, 67, 67, 71, 71, 71, 71, 73, 73, 79, 79, 79, 79, 79, 79, 83, 83, 83, 83, 89, 89, 89, 89, 89, 89, 97, 97, 97, 97, 97, 97, 97, 97, 101, 101, 101, 101, 103, 103, 107, 107, 107, 107, 109, 109, 113, 113, 113, 113, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 131, 131, 131, 131, 137, 137, 137, 137, 137, 137, 139, 139, 149, 149, 149, 149, 149, 149, 149, 149, 149, 149, 151, 151, 157, 157, 157, 157, 157, 157, 163, 163, 163, 163, 163, 163, 167, 167, 167, 167, 173, 173, 173, 173, 173, 173, 179, 179, 179, 179, 179, 179, 181, 181, 191, 191, 191, 191, 191, 191, 191, 191, 191, 191, 193, 193, 197, 197, 197, 197, 199, 199, 211, 211, 211, 211, 211, 211, 211, 211, 211, 211, 211, 211, 223, 223, 223, 223, 223, 223, 223, 223, 223, 223, 223, 223, 227, 227, 227, 227, 229, 229, 233, 233, 233, 233, 239, 239, 239, 239, 239, 239, 241, 241, 251, 251, 251, 251, 251, 251, 251, 251, 251, 251, 257, 257, 257, 257, 257, 257, 263, 263, 263, 263, 263, 263, 269, 269, 269, 269, 269, 269, 271, 271, 277, 277, 277, 277, 277, 277, 281, 281, 281, 281, 283, 283, 293, 293, 293, 293, 293, 293, 293, 293, 293, 293, 307, 307, 307, 307, 307, 307, 307, 307, 307, 307, 307, 307, 307, 307, 311, 311, 311, 311, 313, 313, 317, 317, 317, 317, 331, 331, 331, 331, 331, 331, 331, 331, 331, 331, 331, 331, 331, 331, 337, 337, 337, 337, 337, 337, 347, 347, 347, 347, 347, 347, 347, 347, 347, 347, 349, 349, 353, 353, 353, 353, 359, 359, 359, 359, 359, 359, 367, 367, 367, 367, 367, 367, 367, 367, 373, 373, 373, 373, 373, 373, 379, 379, 379, 379, 379, 379, 383, 383, 383, 383, 389, 389, 389, 389, 389, 389, 397, 397, 397, 397, 397, 397, 397, 397, 401, 401, 401, 401, 409, 409, 409, 409, 409, 409, 409, 409, 419, 419, 419, 419, 419, 419, 419, 419, 419, 419, 421, 421, 431, 431, 431, 431, 431, 431, 431, 431, 431, 431, 433, 433, 439, 439, 439, 439, 439, 439, 443, 443, 443, 443, 449, 449, 449, 449, 449, 449, 457, 457, 457, 457, 457, 457, 457, 457, 461, 461, 461, 461, 463, 463, 467, 467, 467, 467, 479, 479, 479, 479, 479, 479, 479, 479, 479, 479, 479, 479, 487, 487, 487, 487, 487, 487, 487, 487, 491, 491, 491, 491, 499, 499, 499, 499, 499, 499, 499, 499, 503};

    public FaureSequence(int b, int k, int r, int w, int dim) {
        this.init(b, k, r, w, dim);
    }

    private void init(int b, int k, int r, int w, int dim) {
        if (dim < 1) {
            throw new IllegalArgumentException("Dimension for FaureSequence must be > 1");
        }
        if ((double)k * Math.log(b) > 31.0 * Math.log(2.0)) {
            throw new IllegalArgumentException("Trying to construct a FaureSequence with too many points");
        }
        if (r < k || w < r) {
            throw new IllegalArgumentException("One must have k <= r <= w for FaureSequence");
        }
        this.b = b;
        this.numCols = k;
        this.numRows = r;
        this.outDigits = w;
        this.dim = dim;
        this.numPoints = b;
        for (int i = 1; i < k; ++i) {
            this.numPoints *= b;
        }
        this.normFactor = 1.0 / Math.pow(b, this.outDigits);
        double invb = 1.0 / (double)b;
        this.factor = new double[this.outDigits];
        this.factor[0] = invb;
        for (int j = 1; j < this.outDigits; ++j) {
            this.factor[j] = this.factor[j - 1] * invb;
        }
        this.genMat = new int[dim * this.numCols][this.numRows];
        this.initGenMat();
    }

    public FaureSequence(int n, int dim) {
        if (dim < 1 || dim > 500) {
            throw new IllegalArgumentException("Dimension for Faure net must be > 1 and < 500");
        }
        this.b = this.getSmallestPrime(dim);
        this.numCols = (int)Math.ceil(Math.log(n) / Math.log(this.b));
        this.outDigits = (int)Math.floor(Math.log(1.073741824E9) / Math.log(this.b));
        this.numRows = this.outDigits = Math.max(this.outDigits, this.numCols);
        this.init(this.b, this.numCols, this.numRows, this.outDigits, dim);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("Faure sequence:" + PrintfFormat.NEWLINE);
        sb.append(super.toString());
        return sb.toString();
    }

    @Override
    public void extendSequence(int k) {
        this.init(this.b, k, this.numRows, this.outDigits, this.dim);
    }

    private void initGenMat() {
        int l;
        int c;
        for (c = 0; c < this.numCols; ++c) {
            for (l = 0; l < this.numRows; ++l) {
                this.genMat[c][l] = 0;
            }
            this.genMat[c][c] = 1;
        }
        for (int j = 1; j < this.dim; ++j) {
            this.genMat[j * this.numCols][0] = 1;
            for (c = 1; c < this.numCols; ++c) {
                this.genMat[j * this.numCols + c][c] = 1;
                this.genMat[j * this.numCols + c][0] = j * this.genMat[j * this.numCols + c - 1][0] % this.b;
            }
            for (c = 2; c < this.numCols; ++c) {
                for (l = 1; l < c; ++l) {
                    this.genMat[j * this.numCols + c][l] = (this.genMat[j * this.numCols + c - 1][l - 1] + j * this.genMat[j * this.numCols + c - 1][l]) % this.b;
                }
            }
            for (c = 0; c < this.numCols; ++c) {
                for (l = c + 1; l < this.numRows; ++l) {
                    this.genMat[j * this.numCols + c][l] = 0;
                }
            }
        }
    }

    private int getSmallestPrime(int d) {
        return primes[d - 1];
    }
}

