/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.markovchainrqmc;

import java.util.Arrays;
import umontreal.ssj.hups.PointSet;
import umontreal.ssj.hups.PointSetIterator;
import umontreal.ssj.hups.PointSetRandomization;
import umontreal.ssj.hups.RandomShift;
import umontreal.ssj.markovchainrqmc.ArrayOfComparableChains;
import umontreal.ssj.markovchainrqmc.MarkovChainDouble;
import umontreal.ssj.rng.MRG32k3a;
import umontreal.ssj.util.PrintfFormat;
import umontreal.ssj.util.sort.OneDimSort;

public class ArrayOfDoubleChains
extends ArrayOfComparableChains {
    protected MarkovChainDouble baseChain;
    protected double[] state;
    protected double[] perfState;

    public ArrayOfDoubleChains(MarkovChainDouble baseChain, PointSetRandomization rand) {
        super(baseChain, rand, new OneDimSort(0));
        this.baseChain = baseChain;
    }

    public ArrayOfDoubleChains(MarkovChainDouble baseChain) {
        this(baseChain, new RandomShift(new MRG32k3a()));
    }

    @Override
    public void makeCopies(int n) {
        this.state = new double[n];
        this.perfState = new double[n];
        this.n = n;
    }

    public void setStatesDouble(double[] S) {
        if (S.length != this.n) {
            this.n = S.length;
            System.out.println("WARNING : number of chains modified to fit size of S in setStatesDouble(S)");
        }
        for (int i = 0; i < this.n; ++i) {
            this.state[i] = S[i];
        }
    }

    public double[] getStatesDouble() {
        return this.state;
    }

    public void initStatesDouble() {
        Arrays.fill(this.state, this.baseChain.initialStateDouble());
        Arrays.fill(this.perfState, 0.0);
    }

    public boolean simulOneStepArrayRQMC(int step, PointSet p) {
        boolean allStopped = true;
        p.randomize(this.randomization);
        PointSetIterator stream = p.iterator();
        stream.resetStartStream();
        for (int i = 0; i < this.n; ++i) {
            if (this.state[i] == Double.POSITIVE_INFINITY) continue;
            this.state[i] = this.baseChain.nextStepDouble(step, this.state[i], stream);
            stream.resetNextSubstream();
            this.perfState[i] = this.state[i] == Double.POSITIVE_INFINITY ? this.baseChain.getPerformance() : this.baseChain.getPerformanceDouble(this.state[i], step);
            allStopped = allStopped && this.state[i] == Double.POSITIVE_INFINITY;
        }
        return allStopped;
    }

    @Override
    public double simulArrayRQMC(PointSet p, int numSteps) {
        boolean allStopped = false;
        this.initStatesDouble();
        for (int step = 0; step < numSteps && !allStopped; ++step) {
            this.sortChains();
            allStopped = this.simulOneStepArrayRQMC(step, p);
        }
        return this.calcMeanPerf();
    }

    @Override
    public double calcMeanPerf() {
        double sumPerf = 0.0;
        for (int i = 0; i < this.n; ++i) {
            sumPerf += this.perfState[i];
        }
        return sumPerf / (double)this.n;
    }

    @Override
    public void sortChains() {
        Arrays.sort(this.state);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.baseChain.toString());
        sb.append("***************************************************************" + PrintfFormat.NEWLINE);
        for (int i = 0; i < this.n; ++i) {
            sb.append(" ; " + PrintfFormat.g(15, 6, this.state[i]));
        }
        sb.append("PrintfFormat.NEWLINE");
        return sb.toString();
    }
}

