/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.mcqmctools;

import java.util.ArrayList;
import umontreal.ssj.functionfit.LeastSquares;
import umontreal.ssj.hups.RQMCPointSet;
import umontreal.ssj.mcqmctools.MonteCarloModelCV;
import umontreal.ssj.mcqmctools.MonteCarloModelDouble;
import umontreal.ssj.mcqmctools.RQMCExperiment;
import umontreal.ssj.stat.PgfDataTable;
import umontreal.ssj.stat.Tally;
import umontreal.ssj.stat.list.lincv.ListOfTalliesWithCV;
import umontreal.ssj.util.Chrono;
import umontreal.ssj.util.PrintfFormat;

public class RQMCExperimentSeries {
    int numSets = 0;
    RQMCPointSet[] theSets;
    double base = 2.0;
    double logOfBase;
    double[] size = new double[this.numSets];
    double[] mean = new double[this.numSets];
    double[] variance = new double[this.numSets];
    double[] logn = new double[this.numSets];
    double[] logVar = new double[this.numSets];
    String[] tableFields = new String[]{"n", "mean", "variance", "log(n)", "log(variance)"};
    boolean displayExec = false;
    int numReplicates;
    MonteCarloModelDouble model;
    String cpuTime;
    String title;

    public RQMCExperimentSeries(RQMCPointSet[] theSets, double base) {
        this.init(theSets, base);
    }

    public void init(RQMCPointSet[] theSets, double base) {
        this.base = base;
        this.logOfBase = Math.log(base);
        this.numSets = theSets.length;
        this.theSets = theSets;
        this.size = new double[this.numSets];
        this.mean = new double[this.numSets];
        this.variance = new double[this.numSets];
        this.logn = new double[this.numSets];
        this.logVar = new double[this.numSets];
    }

    public void setExecutionDisplay(boolean display) {
        this.displayExec = display;
    }

    public void setBase(double b) {
        this.base = b;
        this.logOfBase = Math.log(this.base);
    }

    public double getBase() {
        return this.base;
    }

    public RQMCPointSet getSet(int i) {
        return this.theSets[i];
    }

    public double[] getValuesn() {
        return this.size;
    }

    public double[] getLogn() {
        return this.logn;
    }

    public double[] getMeans() {
        return this.mean;
    }

    public double[] getVariances() {
        return this.variance;
    }

    public double[] getLogVariances() {
        return this.logVar;
    }

    public void testVarianceRate(MonteCarloModelDouble model, int m) {
        Tally statReps = new Tally();
        Chrono timer = new Chrono();
        this.numReplicates = m;
        this.model = model;
        if (this.displayExec) {
            System.out.println("\n ============================================= ");
            System.out.println("RQMC simulation for mean estimation:  ");
            System.out.println("Model: " + model.toString());
            System.out.println(" Number of indep copies m  = " + m);
            System.out.println(" Point sets: " + this.theSets[0].toString() + "\n");
            System.out.println("    n     CPU time         mean      log(var) ");
        }
        for (int s = 0; s < this.numSets; ++s) {
            int n = this.theSets[s].getNumPoints();
            this.size[s] = n;
            this.logn[s] = Math.log(n) / this.logOfBase;
            RQMCExperiment.simulReplicatesRQMC(model, this.theSets[s], m, statReps);
            this.mean[s] = statReps.average();
            this.variance[s] = statReps.variance();
            this.logVar[s] = Math.log(this.variance[s]) / this.logOfBase;
            if (!this.displayExec) continue;
            System.out.println("  " + n + "     " + timer.format() + "   " + PrintfFormat.f(10, 5, this.mean[s]) + "   " + PrintfFormat.f(7, 2, this.logVar[s]));
        }
        this.cpuTime = timer.format();
    }

    public void testVarianceRateCV(MonteCarloModelCV model, int m) {
        int numCV = model.getNumberCV();
        ListOfTalliesWithCV<Tally> statWithCV = ListOfTalliesWithCV.createWithTally(1, numCV);
        statWithCV.setExpectedValue(0, 0.0);
        Chrono timer = new Chrono();
        this.numReplicates = m;
        this.model = model;
        if (this.displayExec) {
            System.out.println("\n ============================================= ");
            System.out.println("RQMC simulation for mean estimation with control variates:  ");
            System.out.println("Model: " + model.toString());
            System.out.println(" Number of indep copies m  = " + m);
            System.out.println(" Point sets: " + this.theSets[0].toString() + "\n");
            System.out.println("    n     CPU time         mean     log(var) ");
        }
        for (int s = 0; s < this.numSets; ++s) {
            int n = this.theSets[s].getNumPoints();
            this.size[s] = n;
            this.logn[s] = Math.log(n) / this.logOfBase;
            RQMCExperiment.simulReplicatesRQMCCV(model, this.theSets[s], m, statWithCV);
            statWithCV.estimateBeta();
            this.mean[s] = statWithCV.averageWithCV(0);
            this.variance[s] = statWithCV.covarianceWithCV(0, 0);
            this.logVar[s] = Math.log(this.variance[s]) / this.logOfBase;
            if (!this.displayExec) continue;
            System.out.println("  " + n + "     " + timer.format() + "   " + PrintfFormat.f(10, 5, this.mean[s]) + "   " + PrintfFormat.f(7, 2, this.logVar[s]));
        }
        this.cpuTime = timer.format();
    }

    public double[] regressionLogVariance(int numSkip) {
        double[] x2 = new double[this.numSets - numSkip];
        double[] y2 = new double[this.numSets - numSkip];
        for (int i = 0; i < this.numSets - numSkip; ++i) {
            x2[i] = this.logn[i + numSkip];
            y2[i] = this.logVar[i + numSkip];
        }
        return LeastSquares.calcCoefficients(x2, y2, 1);
    }

    public String formatRegression(double[] regCoeff) {
        StringBuffer sb = new StringBuffer("");
        sb.append("  Slope of log(var) = " + PrintfFormat.f(8, 5, regCoeff[1]) + "\n");
        sb.append("    constant term      = " + PrintfFormat.f(8, 5, regCoeff[0]) + "\n\n");
        return sb.toString();
    }

    public String reportVarianceRate(int numSkip, boolean details) {
        StringBuffer sb = new StringBuffer("");
        sb.append("\n ============================================= \n");
        sb.append("RQMC simulation for mean estimation: \n ");
        sb.append("Model: " + this.model.toString() + "\n");
        sb.append(" Number of indep copies m  = " + this.numReplicates + "\n");
        sb.append(" RQMC point sets: " + this.theSets[0].toString() + "\n\n");
        sb.append("RQMC variance \n");
        if (details) {
            sb.append(this.dataLogForPlot());
        }
        sb.append(this.formatRegression(this.regressionLogVariance(numSkip)));
        sb.append("  Total CPU Time = " + this.cpuTime + "\n");
        sb.append("-----------------------------------------------------\n");
        return sb.toString();
    }

    public PgfDataTable toPgfDataTable(String tableName, String tableLabel) {
        double[][] data = new double[this.numSets][5];
        for (int s = 0; s < this.numSets; ++s) {
            data[s][0] = this.size[s];
            data[s][1] = this.mean[s];
            data[s][2] = this.variance[s];
            data[s][3] = this.logn[s];
            data[s][4] = this.logVar[s];
        }
        return new PgfDataTable(tableName, tableLabel, this.tableFields, data);
    }

    public PgfDataTable toPgfDataTable(String tableLabel) {
        return this.toPgfDataTable(this.title, tableLabel);
    }

    public String dataForPlot() {
        StringBuffer sb = new StringBuffer("");
        sb.append("    n      mean       variance \n");
        for (int s = 0; s < this.numSets; ++s) {
            sb.append(" " + this.size[s] + " " + PrintfFormat.f(10, 5, this.mean[s]) + " " + PrintfFormat.f(10, 5, this.variance[s]) + "\n");
        }
        return sb.toString();
    }

    public String dataLogForPlot() {
        StringBuffer sb = new StringBuffer("");
        sb.append("   log(n)      mean       log(variance) \n");
        for (int s = 0; s < this.numSets; ++s) {
            sb.append(" " + this.logn[s] + " " + PrintfFormat.f(10, 5, this.mean[s]) + " " + PrintfFormat.f(10, 5, this.logVar[s]) + "\n");
        }
        return sb.toString();
    }

    public String testVarianceRateManyPointTypes(MonteCarloModelDouble model, ArrayList<RQMCPointSet[]> list, int m, int numSkip, boolean makePgfTable, boolean printReport, boolean details, ArrayList<PgfDataTable> listCurves) {
        StringBuffer sb = new StringBuffer("");
        for (RQMCPointSet[] ptSeries : list) {
            this.init(ptSeries, this.base);
            this.testVarianceRate(model, m);
            if (printReport) {
                System.out.println(this.reportVarianceRate(numSkip, details));
            }
            if (printReport) {
                sb.append(this.reportVarianceRate(numSkip, details));
            }
            if (!makePgfTable) continue;
            listCurves.add(this.toPgfDataTable(ptSeries[0].getLabel()));
        }
        return sb.toString();
    }

    public String toString() {
        return "RQMC Experiment:" + this.title;
    }
}

