/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.mcqmctools.anova;

import java.util.List;
import umontreal.ssj.mcqmctools.MonteCarloModel;
import umontreal.ssj.mcqmctools.MonteCarloModelDouble;
import umontreal.ssj.mcqmctools.anova.CoordinateSet;
import umontreal.ssj.mcqmctools.anova.Integrator;
import umontreal.ssj.mcqmctools.anova.MonteCarloModelDoubleRQMC;
import umontreal.ssj.mcqmctools.anova.PartialVarianceEstimator;
import umontreal.ssj.mcqmctools.anova.RandomIntegrator;
import umontreal.ssj.rng.RandomStream;

public class AnovaVarianceEstimator
implements MonteCarloModel<double[]> {
    protected PartialVarianceEstimator varEstimator = new PartialVarianceEstimator();
    protected RandomIntegrator integrator = null;
    double[] vars = null;

    public MonteCarloModelDouble getModel() {
        return this.varEstimator.getModel();
    }

    public double getApproximateMean() {
        return this.varEstimator.getApproximateMean();
    }

    public void setModel(MonteCarloModelDoubleRQMC model, double approxMean) {
        this.varEstimator.setModel(model, approxMean);
    }

    public Integrator getIntegrator() {
        return this.integrator;
    }

    public void setIntegrator(RandomIntegrator integrator) {
        this.integrator = integrator;
    }

    public List<CoordinateSet> getCoordinateSets() {
        return this.varEstimator.getCoordinateSets();
    }

    public void setCoordinates(List<CoordinateSet> coordSets) {
        this.varEstimator.setCoordinateSets(coordSets);
    }

    public void setCoordinates(CoordinateSet coords) {
        this.varEstimator.setCoordinateSets(coords.subsetsNotEmpty());
    }

    public void setCoordinates(CoordinateSet coords, int maxOrder) {
        this.varEstimator.setCoordinateSets(coords.subsetsNotEmpty(maxOrder));
    }

    @Override
    public void simulate(RandomStream stream) {
        List<CoordinateSet> coordSets = this.varEstimator.getCoordinateSets();
        int nSets = coordSets.size();
        if (this.vars == null || this.vars.length != nSets + 2) {
            this.vars = new double[nSets + 2];
        }
        if (this.integrator == null) {
            throw new IllegalStateException("integrator has not been initialized");
        }
        this.integrator.setStream(stream);
        this.integrator.integrate((MonteCarloModel<double[]>)this.varEstimator, this.vars);
        int n = nSets + 1;
        this.vars[n] = this.vars[n] - this.vars[nSets] * this.vars[nSets];
        for (int i = 0; i < nSets; ++i) {
            CoordinateSet cs = coordSets.get(i);
            for (int i2 = 0; i2 < i; ++i2) {
                CoordinateSet cs2 = coordSets.get(i2);
                if (!cs2.isSubset(cs)) continue;
                int n2 = i;
                this.vars[n2] = this.vars[n2] - this.vars[i2];
            }
        }
    }

    @Override
    public double[] getPerformance() {
        return this.vars;
    }

    public int getDimension() {
        return this.varEstimator.getDimension();
    }

    @Override
    public String toString() {
        String s = String.format("ANOVA Variance Estimator [model=%s]", this.varEstimator.getModel());
        return s;
    }
}

