/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.stochprocess;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.SingularValueDecomposition;
import umontreal.ssj.probdist.NormalDist;
import umontreal.ssj.randvar.NormalGen;
import umontreal.ssj.rng.RandomStream;
import umontreal.ssj.stochprocess.BrownianMotion;

public class BrownianMotionPCA
extends BrownianMotion {
    protected double[][] sigmaCov;
    protected double[][] A;
    protected double[] z;
    protected double[] sortedEigenvalues;
    protected boolean isDecompPCA = false;

    public BrownianMotionPCA(double x0, double mu, double sigma, RandomStream stream) {
        super(x0, mu, sigma, stream);
    }

    public BrownianMotionPCA(double x0, double mu, double sigma, NormalGen gen) {
        super(x0, mu, sigma, gen);
    }

    @Override
    public double nextObservation() {
        throw new UnsupportedOperationException("nextObservation() is not defined in BrownianMotionPCA");
    }

    @Override
    public void setParams(double x0, double mu, double sigma) {
        super.setParams(x0, mu, sigma);
        this.isDecompPCA = true;
    }

    @Override
    public double[] generatePath() {
        int j;
        if (!this.isDecompPCA) {
            this.init();
        }
        for (j = 0; j < this.d; ++j) {
            this.z[j] = this.gen.nextDouble();
        }
        for (j = 0; j < this.d; ++j) {
            double sum = 0.0;
            for (int k = 0; k < this.d; ++k) {
                sum += this.A[j][k] * this.z[k];
            }
            this.path[j + 1] = this.x0 + this.mu * this.t[j + 1] + sum;
        }
        this.observationIndex = this.d;
        this.observationCounter = this.d;
        return this.path;
    }

    @Override
    public double[] generatePath(double[] uniform01) {
        int j;
        if (!this.isDecompPCA) {
            this.init();
        }
        for (j = 0; j < this.d; ++j) {
            this.z[j] = NormalDist.inverseF01(uniform01[j]);
        }
        for (j = 0; j < this.d; ++j) {
            double sum = 0.0;
            for (int k = 0; k < this.d; ++k) {
                sum += this.A[j][k] * this.z[k];
            }
            this.path[j + 1] = this.x0 + this.mu * this.t[j + 1] + sum;
        }
        this.observationIndex = this.d;
        this.observationCounter = this.d;
        return this.path;
    }

    public double[][] decompPCA(double[][] sigma) {
        SingularValueDecomposition sv = new SingularValueDecomposition((DoubleMatrix2D)new DenseDoubleMatrix2D(sigma));
        DoubleMatrix2D D = sv.getS();
        for (int i = 0; i < D.rows(); ++i) {
            this.sortedEigenvalues[i] = D.getQuick(i, i);
            D.setQuick(i, i, Math.sqrt(D.getQuick(i, i)));
        }
        DoubleMatrix2D P = sv.getV();
        return P.zMult(D, null).toArray();
    }

    public double[] getSortedEigenvalues() {
        return this.sortedEigenvalues;
    }

    @Override
    protected void init() {
        super.init();
        this.z = new double[this.d];
        this.sortedEigenvalues = new double[this.d];
        this.sigmaCov = new double[this.d][this.d];
        for (int i = 0; i < this.d; ++i) {
            for (int j = i; j < this.d; ++j) {
                this.sigmaCov[i][j] = this.sigma * this.sigma * this.t[i + 1];
                this.sigmaCov[j][i] = this.sigmaCov[i][j];
            }
        }
        this.A = this.decompPCA(this.sigmaCov);
        this.isDecompPCA = true;
    }
}

