/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.stochprocess;

import umontreal.ssj.rng.RandomStream;
import umontreal.ssj.stochprocess.GeometricLevyProcess;
import umontreal.ssj.stochprocess.InverseGaussianProcess;
import umontreal.ssj.stochprocess.NormalInverseGaussianProcess;

public class GeometricNormalInverseGaussianProcess
extends GeometricLevyProcess {
    public GeometricNormalInverseGaussianProcess(double s0, double muGeom, double alpha, double beta, double mu, double delta, RandomStream streamBrownian, NormalInverseGaussianProcess nigP) {
        this.levyProcess = nigP;
        ((NormalInverseGaussianProcess)this.levyProcess).setParams(0.0, alpha, beta, mu, delta);
        this.x0 = s0;
        this.muGeom = muGeom;
        this.omegaRiskNeutralCorrection = mu + delta * ((NormalInverseGaussianProcess)this.levyProcess).getGamma() - delta * Math.sqrt(alpha * alpha - (1.0 + beta) * (1.0 + beta));
    }

    public GeometricNormalInverseGaussianProcess(double s0, double muGeom, double alpha, double beta, double mu, double delta, RandomStream streamBrownian, InverseGaussianProcess igP) {
        this.levyProcess = new NormalInverseGaussianProcess(0.0, alpha, beta, mu, delta, streamBrownian, igP);
        this.x0 = s0;
        this.muGeom = muGeom;
        this.omegaRiskNeutralCorrection = mu + delta * ((NormalInverseGaussianProcess)this.levyProcess).getGamma() - delta * Math.sqrt(alpha * alpha - (1.0 + beta) * (1.0 + beta));
    }

    public GeometricNormalInverseGaussianProcess(double s0, double muGeom, double alpha, double beta, double mu, double delta, RandomStream streamBrownian, RandomStream streamNIG1, RandomStream streamNIG2, String igType) {
        this.levyProcess = new NormalInverseGaussianProcess(0.0, alpha, beta, mu, delta, streamBrownian, streamNIG1, streamNIG2, igType);
        this.x0 = s0;
        this.muGeom = muGeom;
        this.omegaRiskNeutralCorrection = mu + delta * ((NormalInverseGaussianProcess)this.levyProcess).getGamma() - delta * Math.sqrt(alpha * alpha - (1.0 + beta) * (1.0 + beta));
    }

    public GeometricNormalInverseGaussianProcess(double s0, double muGeom, double alpha, double beta, double mu, double delta, RandomStream streamAll, String igType) {
        this(s0, muGeom, alpha, beta, mu, delta, streamAll, streamAll, streamAll, igType);
    }
}

