/*
 * Decompiled with CFR 0.152.
 */
package de.mdelab.sdm.interpreter.ocl.environment;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class MultiResourceLazyExtentMap
implements Map<EClass, Set<EObject>> {
    private final Map<EClass, Set<EObject>> delegate = new HashMap<EClass, Set<EObject>>();
    private final Collection<EObject> roots = new HashSet<EObject>();

    public MultiResourceLazyExtentMap(List<EObject> contextElements) {
        for (EObject e : contextElements) {
            EObject rootElement = EcoreUtil.getRootContainer((EObject)e);
            if (rootElement.eResource() != null) {
                ResourceSet resSet = rootElement.eResource().getResourceSet();
                if (resSet == null) continue;
                for (Resource resource : resSet.getResources()) {
                    this.roots.addAll((Collection<EObject>)resource.getContents());
                }
                continue;
            }
            this.roots.add(e);
        }
    }

    @Override
    public Set<EObject> get(Object p_key) {
        Set<EObject> result = this.delegate.get(p_key);
        if (result == null) {
            EClass cls = (EClass)p_key;
            result = new HashSet<EObject>();
            this.delegate.put(cls, result);
            TreeIterator iter = EcoreUtil.getAllContents(this.roots);
            while (iter.hasNext()) {
                EObject nextObject = (EObject)iter.next();
                if (!this.isInstance(cls, nextObject)) continue;
                result.add(nextObject);
            }
        }
        return result;
    }

    protected boolean isInstance(EClass p_class, EObject p_element) {
        return p_class.isInstance((Object)p_element);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public Set<Map.Entry<EClass, Set<EObject>>> entrySet() {
        return this.delegate.entrySet();
    }

    @Override
    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public Set<EClass> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public Set<EObject> put(EClass key, Set<EObject> value) {
        return this.delegate.put(key, value);
    }

    @Override
    public void putAll(Map<? extends EClass, ? extends Set<EObject>> t) {
        this.delegate.putAll(t);
    }

    @Override
    public Set<EObject> remove(Object key) {
        return this.delegate.remove(key);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public Collection<Set<EObject>> values() {
        return this.delegate.values();
    }
}

