/*
 * Decompiled with CFR 0.152.
 */
package agg.attribute.impl;

import agg.attribute.AttrConditionTuple;
import agg.attribute.AttrContext;
import agg.attribute.AttrVariableTuple;
import agg.attribute.handler.AttrHandler;
import agg.attribute.handler.HandlerExpr;
import agg.attribute.handler.HandlerType;
import agg.attribute.handler.SymbolTable;
import agg.attribute.impl.AttrTupleManager;
import agg.attribute.impl.ContextCore;
import agg.attribute.impl.ContextRestrictedException;
import agg.attribute.impl.ManagedObject;
import agg.attribute.impl.NoSuchVariableException;
import agg.attribute.impl.TupleMapping;
import agg.attribute.impl.ValueMember;
import agg.attribute.impl.ValueTuple;
import java.util.Hashtable;
import java.util.Vector;

public class ContextView
extends ManagedObject
implements AttrContext,
SymbolTable {
    static final long serialVersionUID = 6106321395444330038L;
    protected ContextCore core;
    protected boolean canDeclareVar = true;
    protected boolean canUseComplexExpr = true;
    protected boolean canHaveEmptyValues = true;
    protected boolean canUseInitialExpr = true;

    public ContextView(AttrTupleManager manager, int mapStyle) {
        this(manager, mapStyle, null);
    }

    public ContextView(AttrTupleManager manager, int mapStyle, AttrContext parent) {
        super(manager);
        ContextCore parentCore = null;
        if (parent != null) {
            parentCore = ((ContextView)parent).core;
        }
        this.core = new ContextCore(manager, mapStyle, parentCore);
    }

    public ContextView(AttrTupleManager manager, AttrContext source, boolean leftRuleSide) {
        this(manager, ((ContextView)source).core);
        if (leftRuleSide) {
            this.canDeclareVar = true;
            this.canUseComplexExpr = false;
            this.canUseInitialExpr = true;
        } else {
            this.canDeclareVar = true;
            this.canUseComplexExpr = true;
            this.canUseInitialExpr = true;
        }
    }

    public ContextView(AttrTupleManager manager, ContextCore source) {
        super(manager);
        this.core = source;
    }

    @Override
    public void dispose() {
        if (this.core != null) {
            this.core.dispose();
        }
        this.core = null;
    }

    protected final void finalize() {
    }

    public void resetVariableTuple() {
        this.core.resetVariableTuple();
    }

    public void resetConditionTuple() {
        this.core.resetConditionTuple();
    }

    public String getErrorMsg() {
        return this.core.getErrorMsg();
    }

    public void clearErrorMsg() {
        this.core.clearErrorMsg();
    }

    public void setVariableContext(boolean b) {
        this.core.setVariableContext(b);
    }

    public boolean isVariableContext() {
        return this.core.isVariableContext();
    }

    public boolean isIgnoreConstContext() {
        return this.core.isIgnoreOfConstContext();
    }

    public void setIgnoreOfConstContext(boolean b) {
        this.core.setIgnoreOfConstContext(b);
    }

    @Override
    public AttrConditionTuple getConditions() {
        return this.core.getConditions();
    }

    @Override
    public AttrVariableTuple getVariables() {
        return this.core.getVariables();
    }

    public Vector<TupleMapping> getMappingsToTarget(ValueTuple target) {
        return this.core.getMappingsToTarget(target);
    }

    @Override
    public boolean doesAllowComplexExpressions() {
        return this.canUseComplexExpr;
    }

    public boolean doesAllowInitialExpressions() {
        return this.canUseInitialExpr;
    }

    @Override
    public boolean doesAllowNewVariables() {
        return this.canDeclareVar;
    }

    @Override
    public boolean doesAllowEmptyValues() {
        return this.canHaveEmptyValues;
    }

    @Override
    public void setAllowVarDeclarations(boolean isAllowed) {
        this.canDeclareVar = isAllowed;
    }

    @Override
    public void setAllowComplexExpr(boolean isAllowed) {
        this.canUseComplexExpr = isAllowed;
    }

    public void setAllowInitialExpr(boolean isAllowed) {
        this.canUseInitialExpr = isAllowed;
    }

    @Override
    public void setAllowEmptyValues(boolean isAllowed) {
        this.canHaveEmptyValues = isAllowed;
    }

    @Override
    public void setAttrContext(AttrContext source) {
        ContextView cv = (ContextView)source;
        this.core = cv.core;
        this.canDeclareVar = cv.canDeclareVar;
        this.canUseComplexExpr = cv.canUseComplexExpr;
        this.canHaveEmptyValues = cv.canHaveEmptyValues;
        this.canUseInitialExpr = cv.canUseInitialExpr;
    }

    public void copyAttrContext(AttrContext context) {
        ContextView cv = (ContextView)context;
        this.core.makeCopyOf(((ContextView)context).core);
        this.canDeclareVar = cv.canDeclareVar;
        this.canUseComplexExpr = cv.canUseComplexExpr;
        this.canHaveEmptyValues = cv.canHaveEmptyValues;
        this.canUseInitialExpr = cv.canUseInitialExpr;
    }

    @Override
    public void freeze() {
        this.core.freeze();
    }

    @Override
    public void defreeze() {
        this.core.defreeze();
    }

    @Override
    public HandlerType getType(String name) {
        if (!this.isDeclared(name)) {
            return null;
        }
        return this.core.getDecl(name).getType();
    }

    @Override
    public HandlerExpr getExpr(String name) {
        if (!this.isDeclared(name)) {
            return null;
        }
        return this.core.getValue(name).getExpr();
    }

    public int getAllowedMapping() {
        return this.core.getAllowedMapping();
    }

    public void changeAllowedMapping(int otherMapStyle) {
        this.core.mapStyle = otherMapStyle;
    }

    public void addMapping(TupleMapping mapping) {
        this.core.addMapping(mapping);
    }

    public Hashtable<ValueTuple, Vector<TupleMapping>> getMapping() {
        return this.core.getMapping();
    }

    public boolean removeMapping(TupleMapping mapping) {
        return this.core.removeMapping(mapping);
    }

    @Override
    public void removeAllMappings() {
        this.core.removeAllMappings();
    }

    public int getMapStyle() {
        return this.core.mapStyle;
    }

    public boolean isDeclared(String name) {
        return this.core.isDeclared(name);
    }

    public boolean addDecl(AttrHandler handler, String type, String name) throws ContextRestrictedException {
        if (!this.canDeclareVar) {
            throw new ContextRestrictedException();
        }
        boolean result = this.core.addDecl(handler, type, name);
        return result;
    }

    public void removeDecl(String name) throws ContextRestrictedException {
        if (!this.canDeclareVar) {
            throw new ContextRestrictedException();
        }
        this.core.removeDecl(name);
    }

    public boolean canSetValue(String name, ValueMember value) {
        return this.core.canSetValue(name, value);
    }

    public void setValue(String name, ValueMember value) throws NoSuchVariableException {
        this.core.setValue(name, value);
    }

    public void removeValue(String name) throws NoSuchVariableException {
        this.core.removeValue(name);
    }
}

