/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.treeview.dialog;

import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdType;
import agg.gui.icons.CircleShapeIcon;
import agg.gui.icons.ColorDashLineIcon;
import agg.gui.icons.ColorDotLineIcon;
import agg.gui.icons.ColorSolidLineIcon;
import agg.gui.icons.OvalShapeIcon;
import agg.gui.icons.RectShapeIcon;
import agg.gui.icons.RoundRectShapeIcon;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.TitledBorder;

public class NodeEdgeTypeSelectionDialog {
    public static final int YES_OPTION = 0;
    protected final JDialog dialog;
    protected final JButton button;
    protected final JButton button2;
    protected boolean cancelled;
    protected EdGraGra gragra;
    protected EdType nodeType;
    protected EdType edgeType;
    protected Vector<EdType> edgeTypes;
    protected Vector<EdType> nodeTypes;
    protected JComboBox edgeTypeCB;
    protected JComboBox nodeTypeCB;
    final Object[] options = new Object[]{"Continue", "Cancel"};

    public NodeEdgeTypeSelectionDialog(JFrame parent) {
        this.dialog = new JDialog((Frame)parent, "Select Type");
        this.dialog.setModal(true);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                NodeEdgeTypeSelectionDialog.this.dialog.setVisible(false);
            }
        });
        this.button = new JButton("Option");
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NodeEdgeTypeSelectionDialog.this.cancelled = false;
                NodeEdgeTypeSelectionDialog.this.dialog.setVisible(false);
            }
        });
        this.button2 = new JButton("Option2");
        this.button2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NodeEdgeTypeSelectionDialog.this.cancelled = true;
                NodeEdgeTypeSelectionDialog.this.dialog.setVisible(false);
            }
        });
        if (this.options.length == 2) {
            if (this.options[0] instanceof String) {
                this.button.setText((String)this.options[0]);
            }
            if (this.options[1] instanceof String) {
                this.button2.setText((String)this.options[1]);
            }
        }
        JPanel content = new JPanel(new BorderLayout());
        this.initContent(content);
        this.dialog.getContentPane().add(content);
        this.dialog.validate();
        this.dialog.setPreferredSize(new Dimension(300, 350));
        this.dialog.pack();
    }

    public void setLocation(int x, int y) {
        this.dialog.setLocation(x, y);
    }

    private void initContent(JPanel content) {
        JPanel p = new JPanel(new GridLayout(11, 1));
        p.add(new JLabel("                                           "));
        p.add(new JLabel("                                           "));
        p.add(new JLabel("        Nodes of selected Node Type        "));
        p.add(new JLabel("                   and                     "));
        p.add(new JLabel("        edges of selected Edge Type        "));
        p.add(new JLabel("            between these nodes            "));
        p.add(new JLabel("        will be exported to ( .col )       "));
        p.add(new JLabel("        resp. imported from ( .col.res )   "));
        p.add(new JLabel("        ColorGraph format.                 "));
        p.add(new JLabel("                                           "));
        p.add(new JLabel("                                           "));
        content.add((Component)p, "North");
        JPanel p11 = new JPanel(new BorderLayout());
        p11.setBorder(new TitledBorder("  Node  Type  "));
        p11.add((Component)this.createNodeTypeComboBox(), "Center");
        p11.add((Component)new JLabel("           "), "South");
        JPanel p21 = new JPanel(new BorderLayout());
        p21.setBorder(new TitledBorder("  Edge  Type  "));
        p21.add((Component)this.createEdgeTypeComboBox(), "Center");
        p21.add((Component)new JLabel("           "), "South");
        JPanel p3 = new JPanel();
        p3.add(p11);
        p3.add(p21);
        content.add((Component)p3, "Center");
        JPanel p5 = new JPanel();
        p5.add(this.button);
        p5.add(new JLabel("          "));
        p5.add(this.button2);
        JPanel p6 = new JPanel(new BorderLayout());
        p6.add((Component)new JLabel("          "), "North");
        p6.add((Component)p5, "Center");
        p6.add((Component)new JLabel("          "), "South");
        content.add((Component)p6, "South");
    }

    public boolean isVisible() {
        return this.dialog.isVisible();
    }

    public void setVisible(boolean b) {
        this.dialog.setVisible(b);
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setGraGra(EdGraGra gra) {
        this.gragra = gra;
        this.updateNodeTypeComboBox(null);
        this.updateEdgeTypeComboBox(null);
        if (this.gragra != null) {
            this.updateNodeTypeComboBox(this.gragra.getTypeSet().getNodeTypes());
            this.updateEdgeTypeComboBox(this.gragra.getTypeSet().getArcTypes());
        }
    }

    public void setNodeType(EdType type) {
        this.nodeType = type;
        if (this.nodeType != null) {
            int indx = this.nodeTypes.indexOf(this.nodeType);
            if (indx != -1) {
                JLabel l = (JLabel)this.nodeTypeCB.getModel().getElementAt(indx + 1);
                this.nodeTypeCB.getModel().setSelectedItem(l);
                this.nodeTypeCB.setSelectedIndex(indx + 1);
            }
        } else {
            Object l = this.nodeTypeCB.getModel().getElementAt(0);
            this.nodeTypeCB.getModel().setSelectedItem(l);
            this.nodeTypeCB.setSelectedIndex(0);
        }
    }

    public void setEdgeType(EdType type) {
        this.edgeType = type;
        if (this.edgeType != null) {
            int indx = this.edgeTypes.indexOf(this.edgeType);
            if (indx != -1) {
                JLabel l = (JLabel)this.edgeTypeCB.getModel().getElementAt(indx + 1);
                this.edgeTypeCB.getModel().setSelectedItem(l);
                this.edgeTypeCB.setSelectedIndex(indx + 1);
            }
        } else {
            Object l = this.edgeTypeCB.getModel().getElementAt(0);
            this.edgeTypeCB.getModel().setSelectedItem(l);
            this.edgeTypeCB.setSelectedIndex(0);
        }
    }

    public EdType getNodeType() {
        return this.nodeType;
    }

    public EdType getEdgeType() {
        return this.edgeType;
    }

    private JComboBox createNodeTypeComboBox() {
        if (this.nodeTypeCB == null) {
            this.nodeTypeCB = new JComboBox();
            this.nodeTypeCB.setRenderer(new MyCellRenderer(true));
            this.nodeTypeCB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JLabel l;
                    int indx;
                    if (((JComboBox)e.getSource()).getSelectedItem() instanceof JLabel && (indx = ((JComboBox)e.getSource()).getSelectedIndex()) >= 0 && (l = (JLabel)((JComboBox)e.getSource()).getSelectedItem()) != null) {
                        NodeEdgeTypeSelectionDialog.this.nodeType = l.getText().equals("ALL") ? null : NodeEdgeTypeSelectionDialog.this.nodeTypes.get(indx - 1);
                    }
                }
            });
        }
        return this.nodeTypeCB;
    }

    private JComboBox createEdgeTypeComboBox() {
        if (this.edgeTypeCB == null) {
            this.edgeTypeCB = new JComboBox();
            this.edgeTypeCB.setRenderer(new MyCellRenderer(true));
            this.edgeTypeCB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JLabel l;
                    int indx;
                    if (((JComboBox)e.getSource()).getSelectedItem() instanceof JLabel && (indx = ((JComboBox)e.getSource()).getSelectedIndex()) >= 0 && (l = (JLabel)((JComboBox)e.getSource()).getSelectedItem()) != null) {
                        NodeEdgeTypeSelectionDialog.this.edgeType = l.getText().equals("ALL") ? null : NodeEdgeTypeSelectionDialog.this.edgeTypes.get(indx - 1);
                    }
                }
            });
        }
        return this.edgeTypeCB;
    }

    private JComboBox updateNodeTypeComboBox(Vector<EdType> nodetypes) {
        this.nodeTypes = nodetypes;
        if (this.nodeTypeCB != null) {
            this.nodeTypeCB.removeAllItems();
        }
        if (this.nodeTypes == null) {
            return this.nodeTypeCB;
        }
        this.nodeTypeCB.addItem(new JLabel("ALL"));
        int i = 0;
        while (i < this.nodeTypes.size()) {
            EdType t = this.nodeTypes.get(i);
            JLabel l = new JLabel(t.getName());
            l.setIcon(this.getNodeTypeIcon(t));
            l.setForeground(t.getColor());
            this.nodeTypeCB.addItem(l);
            ++i;
        }
        return this.nodeTypeCB;
    }

    private JComboBox updateEdgeTypeComboBox(Vector<EdType> arcTypes) {
        this.edgeTypes = arcTypes;
        if (this.edgeTypeCB != null) {
            this.edgeTypeCB.removeAllItems();
        }
        if (this.edgeTypes == null) {
            return this.edgeTypeCB;
        }
        this.edgeTypeCB.addItem(new JLabel("ALL"));
        int i = 0;
        while (i < this.edgeTypes.size()) {
            EdType t = this.edgeTypes.get(i);
            JLabel l = new JLabel(t.getName());
            l.setIcon(this.getArcTypeIcon(t));
            l.setForeground(t.getColor());
            this.edgeTypeCB.addItem(l);
            ++i;
        }
        return this.edgeTypeCB;
    }

    private Icon getArcTypeIcon(EdType et) {
        Icon icon = null;
        switch (et.shape) {
            case 61: {
                icon = new ColorSolidLineIcon(et.color);
                break;
            }
            case 62: {
                icon = new ColorDashLineIcon(et.color);
                break;
            }
            case 63: {
                icon = new ColorDotLineIcon(et.color);
                break;
            }
        }
        return icon;
    }

    public Icon getNodeTypeIcon(EdType et) {
        Icon icon = null;
        switch (et.shape) {
            case 51: {
                icon = new RectShapeIcon(et.color);
                break;
            }
            case 54: {
                icon = new RoundRectShapeIcon(et.color);
                break;
            }
            case 52: {
                icon = new CircleShapeIcon(et.color);
                break;
            }
            case 53: {
                icon = new OvalShapeIcon(et.color);
                break;
            }
        }
        return icon;
    }

    class MyCellRenderer
    extends JLabel
    implements ListCellRenderer {
        boolean allowSelect;

        public MyCellRenderer(boolean allowSelect) {
            this.allowSelect = allowSelect;
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList listbox, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof JLabel) {
                JLabel l = (JLabel)value;
                this.setForeground(l.getForeground());
                this.setIcon(l.getIcon());
                this.setText(l.getText());
            } else if (value instanceof String) {
                this.setText((String)value);
            } else {
                this.setText("");
            }
            if (this.allowSelect && isSelected) {
                this.setBackground(Color.lightGray);
            } else {
                this.setBackground(Color.white);
            }
            this.setOpaque(true);
            return this;
        }
    }
}

