/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.launch;

import de.uka.ipd.sdq.dsexplore.analysis.IAnalysisQualityAttributeDeclaration;
import de.uka.ipd.sdq.dsexplore.helper.ExtensionHelper;
import de.uka.ipd.sdq.dsexplore.launch.DSEAnalysisMethodTab;
import de.uka.ipd.sdq.dsexplore.launch.DSEConstantsContainer;
import de.uka.ipd.sdq.dsexplore.qml.contracttype.QMLContractType.Dimension;
import de.uka.ipd.sdq.dsexplore.qml.contracttype.QMLContractType.QMLContractType;
import de.uka.ipd.sdq.dsexplore.qml.pcm.datastructures.EvaluationAspectWithContext;
import de.uka.ipd.sdq.dsexplore.qml.pcm.reader.PCMDeclarationsReader;
import de.uka.ipd.sdq.dsexplore.qml.reader.QMLDimensionReader;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.palladiosimulator.pcm.usagemodel.UsageModel;

public class QMLManager {
    private static Logger logger = Logger.getLogger((String)"de.uka.ipd.sdq.dsexplore");
    protected List<DSEAnalysisMethodTab> tabs = new ArrayList<DSEAnalysisMethodTab>();
    protected boolean qmlLoaded = false;
    protected String diagnosis = null;
    protected PCMDeclarationsReader pcmReader;
    protected QMLDimensionReader dimensionReader = new QMLDimensionReader();
    protected String currentQMLPath = "";
    protected String currentUsageModelPath = "";
    protected DSEAnalysisMethodTab costTab = null;
    protected DSEAnalysisMethodTab pofodTab = null;
    protected DSEAnalysisMethodTab performanceTab = null;
    protected DSEAnalysisMethodTab securityTab = null;
    protected DSEAnalysisMethodTab nqrTab = null;
    protected DSEAnalysisMethodTab reasoningTab = null;
    protected DSEAnalysisMethodTab confidentialityTab = null;
    protected Set<EvaluationAspectWithContext> objectives = Collections.synchronizedSet(new HashSet(5));

    public List<EvaluationAspectWithContext> getActivatedObjectives() {
        ArrayList<EvaluationAspectWithContext> returnList = new ArrayList<EvaluationAspectWithContext>(this.objectives);
        return returnList;
    }

    public boolean hasActivatedObjectives() {
        return this.objectives.size() > 0;
    }

    public void addTabs(DSEAnalysisMethodTab ... tabs) {
        DSEAnalysisMethodTab[] dSEAnalysisMethodTabArray = tabs;
        int n = tabs.length;
        int n2 = 0;
        while (n2 < n) {
            DSEAnalysisMethodTab tab = dSEAnalysisMethodTabArray[n2];
            this.tabs.add(tab);
            if (tab.getId().equals(DSEConstantsContainer.QualityAttribute.PERFORMANCE_QUALITY.getName())) {
                this.performanceTab = tab;
            } else if (tab.getId().equals(DSEConstantsContainer.QualityAttribute.COST_QUALITY.getName())) {
                this.costTab = tab;
            } else if (tab.getId().equals(DSEConstantsContainer.QualityAttribute.RELIABILITY_QUALITY.getName())) {
                this.pofodTab = tab;
            } else if (tab.getId().equals(DSEConstantsContainer.QualityAttribute.SECURITY_QUALITY.getName())) {
                this.securityTab = tab;
            } else if (tab.getId().equals(DSEConstantsContainer.QualityAttribute.NQR_QUALITY.getName())) {
                this.nqrTab = tab;
            } else if (tab.getId().equals(DSEConstantsContainer.QualityAttribute.REASONING_QUALITY.getName())) {
                this.reasoningTab = tab;
            } else if (tab.getId().equals(DSEConstantsContainer.QualityAttribute.CONFIDENTIALITY_QUALITY.getName())) {
                this.confidentialityTab = tab;
            }
            ++n2;
        }
    }

    public void processQMLFile(String qmlFilePath, String usageModelFilePath) {
        if (this.currentQMLPath.equals(qmlFilePath) && this.currentUsageModelPath.equals(usageModelFilePath)) {
            return;
        }
        this.currentQMLPath = qmlFilePath;
        this.currentUsageModelPath = usageModelFilePath;
        this.qmlLoaded = false;
        this.objectives.clear();
        this.deactivateAllTabs();
        ResourceSetImpl rs = new ResourceSetImpl();
        UsageModel usageModel = null;
        try {
            URI uri = URI.createURI((String)usageModelFilePath);
            if (!uri.isPlatform() && usageModelFilePath.indexOf("://") < 0) {
                uri = URI.createFileURI((String)usageModelFilePath);
            }
            Resource r = rs.getResource(uri, true);
            EList contents = r.getContents();
            for (Object object : contents) {
                if (!(object instanceof UsageModel)) continue;
                usageModel = (UsageModel)object;
                break;
            }
        }
        catch (Exception e) {
            logger.error((Object)("Could not load usage model from " + usageModelFilePath + ". Error was: " + e.getClass() + " " + e.getMessage()));
            e.printStackTrace();
        }
        if (usageModel == null) {
            this.diagnosis = "Could not load usage model from " + usageModelFilePath + "! Please check the UsageModel file and path!";
            return;
        }
        if (!this.fileExists(qmlFilePath) || !qmlFilePath.endsWith(DSEConstantsContainer.QML_DEFINITION_EXTENSION.substring(DSEConstantsContainer.QML_DEFINITION_EXTENSION.lastIndexOf(46), DSEConstantsContainer.QML_DEFINITION_EXTENSION.length()))) {
            this.diagnosis = "Could not load qml definition model! Please check the path!";
            return;
        }
        this.pcmReader = new PCMDeclarationsReader(qmlFilePath);
        ArrayList<IExtension> exts = new ArrayList<IExtension>();
        List costObjectives = this.pcmReader.getDimensionObjectiveContextsForUsageModel(usageModel, this.dimensionReader.getDimension("pathmap://PCM_MODELS/Dimension_cost.qmlcontracttype").getId());
        costObjectives.addAll(this.pcmReader.getDimensionObjectiveContextsForUsageModel(usageModel, this.dimensionReader.getDimension("pathmap://PCM_MODELS/Dimension_initialcost.qmlcontracttype").getId()));
        costObjectives.addAll(this.pcmReader.getDimensionObjectiveContextsForUsageModel(usageModel, this.dimensionReader.getDimension("pathmap://PCM_MODELS/Dimension_operatingcost.qmlcontracttype").getId()));
        List costConstraints = this.pcmReader.getDimensionConstraintContextsForUsageModel(usageModel, this.dimensionReader.getDimension("pathmap://PCM_MODELS/Dimension_cost.qmlcontracttype").getId());
        costConstraints.addAll(this.pcmReader.getDimensionConstraintContextsForUsageModel(usageModel, this.dimensionReader.getDimension("pathmap://PCM_MODELS/Dimension_initialcost.qmlcontracttype").getId()));
        costConstraints.addAll(this.pcmReader.getDimensionConstraintContextsForUsageModel(usageModel, this.dimensionReader.getDimension("pathmap://PCM_MODELS/Dimension_operatingcost.qmlcontracttype").getId()));
        ArrayList<EvaluationAspectWithContext> costCriteria = new ArrayList<EvaluationAspectWithContext>();
        costCriteria.addAll(costObjectives);
        costCriteria.addAll(costConstraints);
        exts.clear();
        int init = 0;
        this.findExtensionsForAspect(exts, init, costCriteria);
        this.activateTab(exts, costObjectives, this.costTab);
        List pofodObjectives = this.pcmReader.getDimensionObjectiveContextsForUsageModel(usageModel, this.dimensionReader.getDimension("pathmap://PCM_MODELS/Dimension_pofod.qmlcontracttype").getId());
        List pofodConstraints = this.pcmReader.getDimensionConstraintContextsForUsageModel(usageModel, this.dimensionReader.getDimension("pathmap://PCM_MODELS/Dimension_pofod.qmlcontracttype").getId());
        ArrayList<EvaluationAspectWithContext> pofodCriteria = new ArrayList<EvaluationAspectWithContext>();
        pofodCriteria.addAll(pofodObjectives);
        pofodCriteria.addAll(pofodConstraints);
        exts.clear();
        init = 0;
        this.findExtensionsForAspect(exts, init, pofodCriteria);
        this.activateTab(exts, pofodObjectives, this.pofodTab);
        List securityObjectives = null;
        try {
            securityObjectives = this.pcmReader.getDimensionObjectiveContextsForUsageModel(usageModel, this.dimensionReader.getDimension("platform:/plugin/edu.kit.ipd.are.dsexplore.analysis.security/Security.qmlcontracttype").getId());
            List securityConstraints = this.pcmReader.getDimensionConstraintContextsForUsageModel(usageModel, this.dimensionReader.getDimension("platform:/plugin/edu.kit.ipd.are.dsexplore.analysis.security/Security.qmlcontracttype").getId());
            ArrayList<EvaluationAspectWithContext> securityCriteria = new ArrayList<EvaluationAspectWithContext>();
            securityCriteria.addAll(securityObjectives);
            securityCriteria.addAll(securityConstraints);
            exts.clear();
            init = 0;
            this.findExtensionsForAspect(exts, init, securityCriteria);
        }
        catch (Exception e) {
            logger.warn((Object)"Security dimension file could not be loaded. Ignoring it.");
            e.printStackTrace();
            exts.clear();
        }
        this.activateTab(exts, securityObjectives, this.securityTab);
        ArrayList nqrObjectives = new ArrayList();
        ArrayList nqrConstraints = new ArrayList();
        try {
            QMLContractType contractTypeForUsageModel = this.pcmReader.getContractTypeForUsageModel(usageModel);
            for (Dimension dim : contractTypeForUsageModel.getDimensions()) {
                nqrObjectives.addAll(this.pcmReader.getDimensionObjectiveContextsForUsageModel(usageModel, dim.getId()));
                nqrConstraints.addAll(this.pcmReader.getDimensionConstraintContextsForUsageModel(usageModel, dim.getId()));
            }
            ArrayList nqrCriteria = new ArrayList();
            nqrCriteria.addAll(nqrObjectives);
            nqrCriteria.addAll(nqrConstraints);
            exts.clear();
            IExtension[] availExts = Platform.getExtensionRegistry().getExtensionPoint("de.uka.ipd.sdq.dsexplore.analysis").getExtensions();
            int i = 0;
            while (i < availExts.length) {
                IConfigurationElement[] elements;
                IConfigurationElement[] iConfigurationElementArray = elements = availExts[i].getConfigurationElements();
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement element = iConfigurationElementArray[n2];
                    if (element.getName().equals("analysis") && element.getAttribute("qualityAttribute").equals("de.uka.ipd.sdq.dsexplore.nqr")) {
                        exts.add(availExts[i]);
                    }
                    ++n2;
                }
                ++i;
            }
        }
        catch (Exception e) {
            logger.warn((Object)"NQR dimension file could not be loaded. Ignoring it.");
            e.printStackTrace();
            exts.clear();
        }
        boolean extentionIntersection = false;
        for (EvaluationAspectWithContext aspect : nqrObjectives) {
            List<IExtension> tmp_exts = this.getExtensionsThatEvaluateAspect(aspect);
            if (tmp_exts.size() > 0) {
                extentionIntersection = true;
                continue;
            }
            extentionIntersection = false;
            break;
        }
        if (this.nqrTab != null) {
            if (exts.size() == 0 || extentionIntersection) {
                this.nqrTab.deactivate();
            } else {
                this.nqrTab.activate(exts);
                for (EvaluationAspectWithContext eawc : nqrObjectives) {
                    if (this.objectives.contains(eawc)) continue;
                    this.objectives.add(eawc);
                }
            }
        }
        List performanceObjectives = this.pcmReader.getDimensionObjectiveContextsForUsageModel(usageModel, this.dimensionReader.getDimension("pathmap://PCM_MODELS/Dimension_responsetime.qmlcontracttype").getId());
        performanceObjectives.addAll(this.pcmReader.getDimensionObjectiveContextsForUsageModel(usageModel, this.dimensionReader.getDimension("pathmap://PCM_MODELS/Dimension_throughput.qmlcontracttype").getId()));
        List performanceConstraints = this.pcmReader.getDimensionConstraintContextsForUsageModel(usageModel, this.dimensionReader.getDimension("pathmap://PCM_MODELS/Dimension_responsetime.qmlcontracttype").getId());
        performanceConstraints.addAll(this.pcmReader.getDimensionObjectiveContextsForUsageModel(usageModel, this.dimensionReader.getDimension("pathmap://PCM_MODELS/Dimension_throughput.qmlcontracttype").getId()));
        ArrayList<EvaluationAspectWithContext> performanceCriteria = new ArrayList<EvaluationAspectWithContext>(performanceObjectives.size() + performanceConstraints.size());
        performanceCriteria.addAll(performanceObjectives);
        performanceCriteria.addAll(performanceConstraints);
        exts.clear();
        init = 0;
        this.findExtensionsForAspect(exts, init, performanceCriteria);
        this.activateTab(exts, performanceObjectives, this.performanceTab);
        this.confidentialityTab(usageModel);
        this.qmlLoaded = true;
    }

    private void activateTab(List<IExtension> exts, List<EvaluationAspectWithContext> objectives, DSEAnalysisMethodTab tab) {
        if (tab != null) {
            if (exts.size() == 0) {
                tab.deactivate();
            } else {
                tab.activate(exts);
                this.objectives.addAll(objectives);
            }
        }
    }

    private void findExtensionsForAspect(List<IExtension> exts, int init, List<EvaluationAspectWithContext> criteria) {
        for (EvaluationAspectWithContext aspect : criteria) {
            List<IExtension> tmp_exts = this.getExtensionsThatEvaluateAspect(aspect);
            if (init == 0) {
                exts.addAll(tmp_exts);
                ++init;
                continue;
            }
            ArrayList<IExtension> removeList = new ArrayList<IExtension>();
            for (IExtension e : exts) {
                if (tmp_exts.contains(e)) continue;
                removeList.add(e);
            }
            exts.removeAll(removeList);
        }
    }

    protected void deactivateAllTabs() {
        for (DSEAnalysisMethodTab tab : this.tabs) {
            tab.deactivate();
        }
    }

    protected boolean fileExists(String path) {
        if (path.startsWith("platform:")) {
            try {
                URL solvedURL = FileLocator.resolve((URL)new URL(path));
                path = solvedURL.getPath();
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        File f = new File(path);
        return f.exists();
    }

    protected List<IExtension> getExtensionsThatEvaluateAspect(EvaluationAspectWithContext aspect) {
        List<IExtension> exts = ExtensionHelper.loadAnalysisExtensions(aspect.getDimension().getId());
        ArrayList<IExtension> return_list = new ArrayList<IExtension>(exts);
        for (IExtension ex : exts) {
            IConfigurationElement[] elements;
            IConfigurationElement[] iConfigurationElementArray = elements = ex.getConfigurationElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IAnalysisQualityAttributeDeclaration attribute;
                IConfigurationElement e = iConfigurationElementArray[n2];
                try {
                    attribute = (IAnalysisQualityAttributeDeclaration)ExtensionHelper.loadExecutableAttribute(e, "qualityAttributeHandler");
                }
                catch (CoreException coreException) {
                    return_list.clear();
                    return return_list;
                }
                if (!attribute.canEvaluateAspectForDimension(aspect.getEvaluationAspect(), aspect.getDimension())) {
                    return_list.remove(ex);
                }
                ++n2;
            }
        }
        return return_list;
    }

    private void confidentialityTab(UsageModel usageModel) {
        List confidentialityObjectives = this.pcmReader.getDimensionObjectiveContextsForUsageModel(usageModel, this.dimensionReader.getDimension("platform:/plugin/org.palladiosimulator.pcm.dataflow.confidentiality.qml/model/Dimension_Confidentiality.qmlcontracttype").getId());
        List confidentialityConstraints = this.pcmReader.getDimensionConstraintContextsForUsageModel(usageModel, this.dimensionReader.getDimension("platform:/plugin/org.palladiosimulator.pcm.dataflow.confidentiality.qml/model/Dimension_Confidentiality.qmlcontracttype").getId());
        List<EvaluationAspectWithContext> confidentialityCriteria = Stream.concat(confidentialityConstraints.stream(), confidentialityObjectives.stream()).collect(Collectors.toList());
        ArrayList<IExtension> exts = new ArrayList<IExtension>();
        this.findExtensionsForAspect(exts, 0, confidentialityCriteria);
        this.activateTab(exts, confidentialityObjectives, this.confidentialityTab);
    }

    public boolean isQMLLoaded() {
        return this.qmlLoaded;
    }

    public String getDiagnosis() {
        return this.diagnosis;
    }
}

