/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.launch;

import de.uka.ipd.sdq.workflow.launchconfig.LaunchConfigPlugin;
import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.palladiosimulator.analyzer.workflow.runconfig.FileNamesInputTab;

public class TacticsTab
extends FileNamesInputTab {
    static final String TAB_NAME = "Tactics";
    private static final int DEFAULT_MARGIN = 15;
    private static final int DEFAULT_HORIZONTAL_SPACING = 30;
    private ModifyListener modifyListener;
    static final String GENERAL_SETTINGS_GROUP_NAME = "General Settings";
    static final String CONSIDER_QML_BOUNDS = "Consider QML bounds (Makes tactic application dependent of bound violations.)";
    static final String TACTICS_PROBABILITY = "Probability to try applying tactics when mating.";
    private Button considerQMLBoundsButton;
    private Text tacticsProbabilityText;
    static final String REALLOCATION_GROUP_NAME = "Reallocation Tactic";
    static final String USE_REALLOCATION = "Use reallocation tactic";
    static final String REALLOCATION_UTILISATION_DIFFERENCE = "Threshold for utilisation difference";
    static final String REALLOCATION_WEIGHT = "Weight of reallocation tactic";
    private Button useReallocationButton;
    private Text reallocationThresholdUtilisationDifference;
    private Text reallocationWeight;
    private Label reallocationThresholdUtilisationDifferenceLabel;
    private Label reallocationWeightLabel;
    static final boolean USE_REALLOCATION_DEFAULT = false;
    static final double REALLOCATION_UTILISATION_DIFFERENCE_DEFAULT = 0.5;
    static final double REALLOCATION_WEIGHT_DEFAULT = 1.0;
    static final String PROCESSING_RATE_GROUP_NAME = "Processing Rate Heuristic";
    static final String USE_PROCESSING_RATE = "Use processing rate tactic";
    static final String PROCESSING_RATE_THRESHOLD_LOW_UTILISATION = "Threshold for low utilisation";
    static final String PROCESSING_RATE_THRESHOLD_HIGH_UTILISATION = "Threshold for high utilisation";
    static final String PROCESSING_RATE_INCREASE_FACTOR = "Increase processing rate factor";
    static final String PROCESSING_RATE_DECREASE_FACTOR = "Decrease processing rate factor";
    static final String PROCESSING_RATE_WEIGHT = "Weight of processing rate tactic";
    private Button useProcessingRateButton;
    private Text processingRateThresholdLowUtilisation;
    private Text processingRateThresholdHighUtilisation;
    private Text processingRateDecreaseFactor;
    private Text processingRateIncreaseFactor;
    private Text processingRateWeight;
    private Label processingRateThresholdLowUtilisationLabel;
    private Label processingRateThresholdHighUtilisationLabel;
    private Label processingRateDecreaseFactorLabel;
    private Label processingRateIncreaseFactorLabel;
    private Label processingRateWeightLabel;
    static final boolean USE_PROCESSING_RATE_DEFAULT = false;
    static final double PROCESSING_RATE_THRESHOLD_LOW_UTILISATION_DEFAULT = 0.2;
    static final double PROCESSING_RATE_THRESHOLD_HIGH_UTILISATION_DEFAULT = 0.8;
    static final double PROCESSING_RATE_INCREASE_FACTOR_DEFAULT = 0.25;
    static final double PROCESSING_RATE_DECREASE_FACTOR_DEFAULT = 0.25;
    static final double PROCESSING_RATE_WEIGHT_DEFAULT = 0.1;
    static final String SERVER_CONSOLIDATION_GROUP_NAME = "Server Consolidation";
    static final String USE_SERVER_CONSOLIDATION = "Use server consolidation tactic";
    static final String SERVER_CONSOLIDATION_THRESHOLD_LOW_UTILISATION = "Threshold for low utilisation";
    static final String SERVER_CONSOLIDATION_WEIGHT = "Weight of server consolidation tactic";
    private Button useServerConsolidationButton;
    private Text serverConsolidationThresholdLowUtilisation;
    private Text serverConsolidationWeight;
    private Label serverConsolidationThresholdLowUtilisationLabel;
    private Label serverConsolidationWeightLabel;
    static final boolean USE_SERVER_CONSOLIDATION_DEFAULT = false;
    static final double SERVER_CONSOLIDATION_THRESHOLD_LOW_UTILISATION_DEFAULT = 0.3;
    static final double SERVER_CONSOLIDATION_WEIGHT_DEFAULT = 0.5;
    static final String SERVER_EXPANSION_GROUP_NAME = "Server expansion";
    static final String USE_SERVER_EXPANSION = "Use server expansion tactic";
    static final String SERVER_EXPANSION_THRESHOLD_HIGH_UTILISATION = "Threshold for high utilisation";
    static final String SERVER_EXPANSION_MAX_NUMBER_OF_REPLACEMENTS = "Maximum number of reallocations";
    static final String SERVER_EXPANSION_WEIGHT = "Weight of server expansion tactic";
    private Button useServerExpansionButton;
    private Text serverExpansionThresholdHighUtilisation;
    private Text serverExpansionMaxNumberOfReplacements;
    private Text serverExpansionWeight;
    private Label serverExpansionThresholdHighUtilisationLabel;
    private Label serverExpansionMaxNumberOfReplacementsLabel;
    private Label serverExpansionWeightLabel;
    private Button useLinkReallocationButton;
    static final String REALLOCATION_FOR_LINK_USAGE_GROUP_NAME = "Reallocation for link usage tactic";
    static final String REALLOCATION_FOR_LINK_USAGE = "Use link reallocation tactic";
    private Button useAntipatternsButton;
    private static final String USE_ANTIPATTERNS = "Use antipattern knowledge";
    private static final String ANTIPATTERNS_GROUP_NAME = "Antipattern Detection and Solution";
    static final boolean CONSIDER_QML_BOUNDS_DEFAULT = false;
    static final boolean USE_SERVER_EXPANSION_DEFAULT = false;
    static final double SERVER_EXPANSION_THRESHOLD_HIGH_UTILISATION_DEFAULT = 0.7;
    static final int SERVER_EXPANSION_MAX_NUMBER_OF_REPLACEMENTS_DEFAULT = 1;
    static final double SERVER_EXPANSION_WEIGHT_DEFAULT = 0.5;
    static final boolean USE_ANTIPATTERNS_DEFAULT = false;
    static final boolean USE_LINK_REALLOCATION_DEFAULT = false;

    public void createControl(Composite parent) {
        this.modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TacticsTab.this.setDirty(true);
                TacticsTab.this.updateLaunchConfigurationDialog();
            }
        };
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                TacticsTab.this.setDirty(true);
                TacticsTab.this.updateLaunchConfigurationDialog();
            }

            public void widgetSelected(SelectionEvent e) {
                TacticsTab.this.setDirty(true);
                TacticsTab.this.updateLaunchConfigurationDialog();
            }
        };
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout());
        Group generalSettingsGroup = new Group(container, 0);
        GridLayout qmlGroupLayout = new GridLayout();
        qmlGroupLayout.numColumns = 4;
        qmlGroupLayout.horizontalSpacing = 30;
        qmlGroupLayout.marginHeight = 15;
        qmlGroupLayout.marginWidth = 15;
        generalSettingsGroup.setLayout((Layout)qmlGroupLayout);
        generalSettingsGroup.setText(GENERAL_SETTINGS_GROUP_NAME);
        generalSettingsGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.considerQMLBoundsButton = new Button((Composite)generalSettingsGroup, 32);
        this.considerQMLBoundsButton.setEnabled(true);
        this.considerQMLBoundsButton.setSelection(true);
        this.considerQMLBoundsButton.setText(CONSIDER_QML_BOUNDS);
        this.considerQMLBoundsButton.addSelectionListener(selectionListener);
        Label tacticsProbabilityLabel = new Label((Composite)generalSettingsGroup, 0);
        tacticsProbabilityLabel.setText(TACTICS_PROBABILITY);
        this.tacticsProbabilityText = new Text((Composite)generalSettingsGroup, 2052);
        this.tacticsProbabilityText.setText("0.6");
        this.tacticsProbabilityText.addModifyListener(this.modifyListener);
        Group reallocationGroup = new Group(container, 0);
        GridLayout reallocationGroupLayout = new GridLayout();
        reallocationGroupLayout.numColumns = 4;
        reallocationGroupLayout.horizontalSpacing = 30;
        reallocationGroupLayout.marginHeight = 15;
        reallocationGroupLayout.marginWidth = 15;
        reallocationGroup.setLayout((Layout)reallocationGroupLayout);
        reallocationGroup.setText(REALLOCATION_GROUP_NAME);
        reallocationGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.useReallocationButton = new Button((Composite)reallocationGroup, 32);
        this.useReallocationButton.setEnabled(true);
        this.useReallocationButton.setSelection(true);
        this.useReallocationButton.setText(USE_REALLOCATION);
        this.useReallocationButton.addSelectionListener(selectionListener);
        this.useReallocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TacticsTab.this.updateReallocationSelection();
            }
        });
        new Label((Composite)reallocationGroup, 0);
        new Label((Composite)reallocationGroup, 0);
        new Label((Composite)reallocationGroup, 0);
        this.reallocationThresholdUtilisationDifferenceLabel = new Label((Composite)reallocationGroup, 0);
        this.reallocationThresholdUtilisationDifferenceLabel.setText(REALLOCATION_UTILISATION_DIFFERENCE);
        this.reallocationThresholdUtilisationDifference = new Text((Composite)reallocationGroup, 2052);
        this.reallocationThresholdUtilisationDifference.setEnabled(true);
        this.reallocationThresholdUtilisationDifference.addModifyListener(this.modifyListener);
        this.reallocationWeightLabel = new Label((Composite)reallocationGroup, 0);
        this.reallocationWeightLabel.setText(REALLOCATION_WEIGHT);
        this.reallocationWeight = new Text((Composite)reallocationGroup, 2052);
        this.reallocationWeight.setEnabled(true);
        this.reallocationWeight.addModifyListener(this.modifyListener);
        Group processingRateGroup = new Group(container, 0);
        GridLayout processingRateGroupLayout = new GridLayout();
        processingRateGroupLayout.numColumns = 4;
        processingRateGroupLayout.horizontalSpacing = 30;
        processingRateGroupLayout.marginHeight = 15;
        processingRateGroupLayout.marginWidth = 15;
        processingRateGroup.setLayout((Layout)processingRateGroupLayout);
        processingRateGroup.setText(PROCESSING_RATE_GROUP_NAME);
        processingRateGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.useProcessingRateButton = new Button((Composite)processingRateGroup, 32);
        this.useProcessingRateButton.setEnabled(true);
        this.useProcessingRateButton.setSelection(true);
        this.useProcessingRateButton.setText(USE_PROCESSING_RATE);
        this.useProcessingRateButton.addSelectionListener(selectionListener);
        this.useProcessingRateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TacticsTab.this.updateProcessingRateSelection();
            }
        });
        new Label((Composite)processingRateGroup, 0);
        new Label((Composite)processingRateGroup, 0);
        new Label((Composite)processingRateGroup, 0);
        this.processingRateThresholdHighUtilisationLabel = new Label((Composite)processingRateGroup, 0);
        this.processingRateThresholdHighUtilisationLabel.setText("Threshold for high utilisation");
        this.processingRateThresholdHighUtilisation = new Text((Composite)processingRateGroup, 2052);
        this.processingRateThresholdHighUtilisation.setEnabled(true);
        this.processingRateThresholdHighUtilisation.addModifyListener(this.modifyListener);
        this.processingRateThresholdLowUtilisationLabel = new Label((Composite)processingRateGroup, 0);
        this.processingRateThresholdLowUtilisationLabel.setText("Threshold for low utilisation");
        this.processingRateThresholdLowUtilisation = new Text((Composite)processingRateGroup, 2052);
        this.processingRateThresholdLowUtilisation.setEnabled(true);
        this.processingRateThresholdLowUtilisation.addModifyListener(this.modifyListener);
        this.processingRateDecreaseFactorLabel = new Label((Composite)processingRateGroup, 0);
        this.processingRateDecreaseFactorLabel.setText(PROCESSING_RATE_DECREASE_FACTOR);
        this.processingRateDecreaseFactor = new Text((Composite)processingRateGroup, 2052);
        this.processingRateDecreaseFactor.setEnabled(true);
        this.processingRateDecreaseFactor.addModifyListener(this.modifyListener);
        this.processingRateIncreaseFactorLabel = new Label((Composite)processingRateGroup, 0);
        this.processingRateIncreaseFactorLabel.setText(PROCESSING_RATE_INCREASE_FACTOR);
        this.processingRateIncreaseFactor = new Text((Composite)processingRateGroup, 2052);
        this.processingRateIncreaseFactor.setEnabled(true);
        this.processingRateIncreaseFactor.addModifyListener(this.modifyListener);
        this.processingRateWeightLabel = new Label((Composite)processingRateGroup, 0);
        this.processingRateWeightLabel.setText(PROCESSING_RATE_WEIGHT);
        this.processingRateWeight = new Text((Composite)processingRateGroup, 2052);
        this.processingRateWeight.setEnabled(true);
        this.processingRateWeight.addModifyListener(this.modifyListener);
        Group serverConsolidationGroup = new Group(container, 0);
        GridLayout serverConsolidationGroupLayout = new GridLayout();
        serverConsolidationGroupLayout.marginHeight = 15;
        serverConsolidationGroupLayout.marginWidth = 15;
        serverConsolidationGroupLayout.numColumns = 4;
        serverConsolidationGroupLayout.horizontalSpacing = 30;
        serverConsolidationGroup.setLayout((Layout)serverConsolidationGroupLayout);
        serverConsolidationGroup.setText(SERVER_CONSOLIDATION_GROUP_NAME);
        serverConsolidationGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.useServerConsolidationButton = new Button((Composite)serverConsolidationGroup, 32);
        this.useServerConsolidationButton.setEnabled(true);
        this.useServerConsolidationButton.setSelection(true);
        this.useServerConsolidationButton.setText(USE_SERVER_CONSOLIDATION);
        this.useServerConsolidationButton.addSelectionListener(selectionListener);
        this.useServerConsolidationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TacticsTab.this.updateServerConsolidationSelection();
            }
        });
        new Label((Composite)serverConsolidationGroup, 0);
        new Label((Composite)serverConsolidationGroup, 0);
        new Label((Composite)serverConsolidationGroup, 0);
        this.serverConsolidationThresholdLowUtilisationLabel = new Label((Composite)serverConsolidationGroup, 0);
        this.serverConsolidationThresholdLowUtilisationLabel.setText("Threshold for low utilisation");
        this.serverConsolidationThresholdLowUtilisation = new Text((Composite)serverConsolidationGroup, 2052);
        this.serverConsolidationThresholdLowUtilisation.setEnabled(true);
        this.serverConsolidationThresholdLowUtilisation.addModifyListener(this.modifyListener);
        this.serverConsolidationWeightLabel = new Label((Composite)serverConsolidationGroup, 0);
        this.serverConsolidationWeightLabel.setText(SERVER_CONSOLIDATION_WEIGHT);
        this.serverConsolidationWeight = new Text((Composite)serverConsolidationGroup, 2052);
        this.serverConsolidationWeight.setEnabled(true);
        this.serverConsolidationWeight.addModifyListener(this.modifyListener);
        Group serverExpansionGroup = new Group(container, 0);
        GridLayout serverExpansionGroupLayout = new GridLayout();
        serverExpansionGroupLayout.marginHeight = 15;
        serverExpansionGroupLayout.marginWidth = 15;
        serverExpansionGroupLayout.numColumns = 4;
        serverExpansionGroupLayout.horizontalSpacing = 30;
        serverExpansionGroup.setLayout((Layout)serverExpansionGroupLayout);
        serverExpansionGroup.setText(SERVER_EXPANSION_GROUP_NAME);
        serverExpansionGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.useServerExpansionButton = new Button((Composite)serverExpansionGroup, 32);
        this.useServerExpansionButton.setEnabled(true);
        this.useServerExpansionButton.setSelection(true);
        this.useServerExpansionButton.setText(USE_SERVER_EXPANSION);
        this.useServerExpansionButton.addSelectionListener(selectionListener);
        this.useServerExpansionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TacticsTab.this.updateServerExpansionSelection();
            }
        });
        new Label((Composite)serverExpansionGroup, 0);
        new Label((Composite)serverExpansionGroup, 0);
        new Label((Composite)serverExpansionGroup, 0);
        this.serverExpansionThresholdHighUtilisationLabel = new Label((Composite)serverExpansionGroup, 0);
        this.serverExpansionThresholdHighUtilisationLabel.setText("Threshold for high utilisation");
        this.serverExpansionThresholdHighUtilisation = new Text((Composite)serverExpansionGroup, 2052);
        this.serverExpansionThresholdHighUtilisation.setEnabled(true);
        this.serverExpansionThresholdHighUtilisation.addModifyListener(this.modifyListener);
        this.serverExpansionMaxNumberOfReplacementsLabel = new Label((Composite)serverExpansionGroup, 0);
        this.serverExpansionMaxNumberOfReplacementsLabel.setText(SERVER_EXPANSION_MAX_NUMBER_OF_REPLACEMENTS);
        this.serverExpansionMaxNumberOfReplacements = new Text((Composite)serverExpansionGroup, 2052);
        this.serverExpansionMaxNumberOfReplacements.setEnabled(true);
        this.serverExpansionMaxNumberOfReplacements.addModifyListener(this.modifyListener);
        this.serverExpansionWeightLabel = new Label((Composite)serverExpansionGroup, 0);
        this.serverExpansionWeightLabel.setText(SERVER_EXPANSION_WEIGHT);
        this.serverExpansionWeight = new Text((Composite)serverExpansionGroup, 2052);
        this.serverExpansionWeight.setEnabled(true);
        this.serverExpansionWeight.addModifyListener(this.modifyListener);
        Group linkReallocGroup = new Group(container, 0);
        GridLayout linkReallocGroupLayout = new GridLayout();
        linkReallocGroupLayout.marginHeight = 15;
        linkReallocGroupLayout.marginWidth = 15;
        linkReallocGroupLayout.numColumns = 4;
        linkReallocGroupLayout.horizontalSpacing = 30;
        linkReallocGroup.setLayout((Layout)linkReallocGroupLayout);
        linkReallocGroup.setText(REALLOCATION_FOR_LINK_USAGE_GROUP_NAME);
        linkReallocGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.useLinkReallocationButton = new Button((Composite)linkReallocGroup, 32);
        this.useLinkReallocationButton.setEnabled(true);
        this.useLinkReallocationButton.setSelection(true);
        this.useLinkReallocationButton.setText(REALLOCATION_FOR_LINK_USAGE);
        this.useLinkReallocationButton.addSelectionListener(selectionListener);
        Group antipatternsGroup = new Group(container, 0);
        GridLayout antipatternsGroupLayout = new GridLayout();
        antipatternsGroupLayout.marginHeight = 15;
        antipatternsGroupLayout.marginWidth = 15;
        antipatternsGroupLayout.numColumns = 4;
        antipatternsGroupLayout.horizontalSpacing = 30;
        antipatternsGroup.setLayout((Layout)antipatternsGroupLayout);
        antipatternsGroup.setText(ANTIPATTERNS_GROUP_NAME);
        antipatternsGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.useAntipatternsButton = new Button((Composite)antipatternsGroup, 32);
        this.useAntipatternsButton.setEnabled(true);
        this.useAntipatternsButton.setSelection(true);
        this.useAntipatternsButton.setText(USE_ANTIPATTERNS);
        this.useAntipatternsButton.addSelectionListener(selectionListener);
    }

    public String getName() {
        return TAB_NAME;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.considerQMLBoundsButton.setSelection(configuration.getAttribute("Consider QML bounds", false));
        }
        catch (CoreException e) {
            LaunchConfigPlugin.errorLogger((String)this.getName(), (String)CONSIDER_QML_BOUNDS, (String)e.getMessage());
        }
        try {
            this.tacticsProbabilityText.setText(configuration.getAttribute("tactics probability when mating", "0.6"));
        }
        catch (CoreException e) {
            LaunchConfigPlugin.errorLogger((String)this.getName(), (String)TACTICS_PROBABILITY, (String)e.getMessage());
        }
        try {
            this.useReallocationButton.setSelection(configuration.getAttribute("Use reallocation heuristic", false));
        }
        catch (CoreException e) {
            LaunchConfigPlugin.errorLogger((String)this.getName(), (String)USE_REALLOCATION, (String)e.getMessage());
        }
        try {
            this.reallocationThresholdUtilisationDifference.setText(configuration.getAttribute("Reallocation threshold for utilisation difference", ""));
        }
        catch (CoreException e) {
            LaunchConfigPlugin.errorLogger((String)this.getName(), (String)REALLOCATION_UTILISATION_DIFFERENCE, (String)e.getMessage());
        }
        try {
            this.reallocationWeight.setText(configuration.getAttribute("Weight of reallocation heuristic", ""));
        }
        catch (CoreException e) {
            LaunchConfigPlugin.errorLogger((String)this.getName(), (String)REALLOCATION_WEIGHT, (String)e.getMessage());
        }
        try {
            this.useProcessingRateButton.setSelection(configuration.getAttribute("Use processing rate heuristic", false));
        }
        catch (CoreException e) {
            LaunchConfigPlugin.errorLogger((String)this.getName(), (String)USE_PROCESSING_RATE, (String)e.getMessage());
        }
        try {
            this.useLinkReallocationButton.setSelection(configuration.getAttribute("Use Realocation for Link Usage Tactic", false));
        }
        catch (CoreException e) {
            LaunchConfigPlugin.errorLogger((String)this.getName(), (String)REALLOCATION_FOR_LINK_USAGE, (String)e.getMessage());
        }
        try {
            this.useAntipatternsButton.setSelection(configuration.getAttribute(USE_ANTIPATTERNS, false));
        }
        catch (CoreException e) {
            LaunchConfigPlugin.errorLogger((String)this.getName(), (String)USE_ANTIPATTERNS, (String)e.getMessage());
        }
        try {
            this.processingRateDecreaseFactor.setText(configuration.getAttribute(PROCESSING_RATE_DECREASE_FACTOR, ""));
        }
        catch (CoreException e) {
            LaunchConfigPlugin.errorLogger((String)this.getName(), (String)PROCESSING_RATE_DECREASE_FACTOR, (String)e.getMessage());
        }
        try {
            this.processingRateIncreaseFactor.setText(configuration.getAttribute(PROCESSING_RATE_INCREASE_FACTOR, ""));
        }
        catch (CoreException e) {
            LaunchConfigPlugin.errorLogger((String)this.getName(), (String)PROCESSING_RATE_INCREASE_FACTOR, (String)e.getMessage());
        }
        try {
            this.processingRateThresholdHighUtilisation.setText(configuration.getAttribute("Processing rate threshold for high utilisation", ""));
        }
        catch (CoreException e) {
            LaunchConfigPlugin.errorLogger((String)this.getName(), (String)"Threshold for high utilisation", (String)e.getMessage());
        }
        try {
            this.processingRateThresholdLowUtilisation.setText(configuration.getAttribute("Proceesing rate threshold for low utilisation", ""));
        }
        catch (CoreException e) {
            LaunchConfigPlugin.errorLogger((String)this.getName(), (String)"Threshold for low utilisation", (String)e.getMessage());
        }
        try {
            this.processingRateWeight.setText(configuration.getAttribute("Weight of processing rate heuristic", ""));
        }
        catch (CoreException e) {
            LaunchConfigPlugin.errorLogger((String)this.getName(), (String)PROCESSING_RATE_WEIGHT, (String)e.getMessage());
        }
        try {
            this.useServerConsolidationButton.setSelection(configuration.getAttribute("Use server consolidation heuristic", false));
        }
        catch (CoreException e) {
            LaunchConfigPlugin.errorLogger((String)this.getName(), (String)USE_SERVER_CONSOLIDATION, (String)e.getMessage());
        }
        try {
            this.serverConsolidationThresholdLowUtilisation.setText(configuration.getAttribute("Server consolidation threshold for low utilisation", ""));
        }
        catch (CoreException e) {
            LaunchConfigPlugin.errorLogger((String)this.getName(), (String)"Threshold for low utilisation", (String)e.getMessage());
        }
        try {
            this.serverConsolidationWeight.setText(configuration.getAttribute("Weight of server consolidation heuristic", ""));
        }
        catch (CoreException e) {
            LaunchConfigPlugin.errorLogger((String)this.getName(), (String)SERVER_CONSOLIDATION_WEIGHT, (String)e.getMessage());
        }
        try {
            this.useServerExpansionButton.setSelection(configuration.getAttribute("Use server expansion heuristic", false));
        }
        catch (CoreException e) {
            LaunchConfigPlugin.errorLogger((String)this.getName(), (String)USE_SERVER_EXPANSION, (String)e.getMessage());
        }
        try {
            this.serverExpansionMaxNumberOfReplacements.setText(configuration.getAttribute("Server expansion maximum number of reallocations", ""));
        }
        catch (CoreException e) {
            LaunchConfigPlugin.errorLogger((String)this.getName(), (String)SERVER_EXPANSION_MAX_NUMBER_OF_REPLACEMENTS, (String)e.getMessage());
        }
        try {
            this.serverExpansionThresholdHighUtilisation.setText(configuration.getAttribute("Server expansion threshold for high utilisation", ""));
        }
        catch (CoreException e) {
            LaunchConfigPlugin.errorLogger((String)this.getName(), (String)"Threshold for high utilisation", (String)e.getMessage());
        }
        try {
            this.serverExpansionWeight.setText(configuration.getAttribute("Weight of server expansion heuristic", ""));
        }
        catch (CoreException e) {
            LaunchConfigPlugin.errorLogger((String)this.getName(), (String)SERVER_EXPANSION_WEIGHT, (String)e.getMessage());
        }
        this.updateSelections();
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("Consider QML bounds", this.considerQMLBoundsButton.getSelection());
        configuration.setAttribute("tactics probability when mating", this.tacticsProbabilityText.getText());
        configuration.setAttribute("Use reallocation heuristic", this.useReallocationButton.getSelection());
        configuration.setAttribute("Reallocation threshold for utilisation difference", this.reallocationThresholdUtilisationDifference.getText());
        configuration.setAttribute("Weight of reallocation heuristic", this.reallocationWeight.getText());
        configuration.setAttribute("Use processing rate heuristic", this.useProcessingRateButton.getSelection());
        configuration.setAttribute(PROCESSING_RATE_DECREASE_FACTOR, this.processingRateDecreaseFactor.getText());
        configuration.setAttribute(PROCESSING_RATE_INCREASE_FACTOR, this.processingRateIncreaseFactor.getText());
        configuration.setAttribute("Processing rate threshold for high utilisation", this.processingRateThresholdHighUtilisation.getText());
        configuration.setAttribute("Proceesing rate threshold for low utilisation", this.processingRateThresholdLowUtilisation.getText());
        configuration.setAttribute("Weight of processing rate heuristic", this.processingRateWeight.getText());
        configuration.setAttribute("Use server consolidation heuristic", this.useServerConsolidationButton.getSelection());
        configuration.setAttribute("Server consolidation threshold for low utilisation", this.serverConsolidationThresholdLowUtilisation.getText());
        configuration.setAttribute("Weight of server consolidation heuristic", this.serverConsolidationWeight.getText());
        configuration.setAttribute("Use server expansion heuristic", this.useServerExpansionButton.getSelection());
        configuration.setAttribute("Server expansion maximum number of reallocations", this.serverExpansionMaxNumberOfReplacements.getText());
        configuration.setAttribute("Server expansion threshold for high utilisation", this.serverExpansionThresholdHighUtilisation.getText());
        configuration.setAttribute("Weight of server expansion heuristic", this.serverExpansionWeight.getText());
        configuration.setAttribute("Use Realocation for Link Usage Tactic", this.useLinkReallocationButton.getSelection());
        configuration.setAttribute(USE_ANTIPATTERNS, this.useAntipatternsButton.getSelection());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("Use reallocation heuristic", false);
        configuration.setAttribute("Reallocation threshold for utilisation difference", Double.toString(0.5));
        configuration.setAttribute("Weight of reallocation heuristic", Double.toString(1.0));
        configuration.setAttribute("Use processing rate heuristic", false);
        configuration.setAttribute(PROCESSING_RATE_DECREASE_FACTOR, Double.toString(0.25));
        configuration.setAttribute(PROCESSING_RATE_INCREASE_FACTOR, Double.toString(0.25));
        configuration.setAttribute("Processing rate threshold for high utilisation", Double.toString(0.8));
        configuration.setAttribute("Proceesing rate threshold for low utilisation", Double.toString(0.2));
        configuration.setAttribute("Weight of processing rate heuristic", Double.toString(0.1));
        configuration.setAttribute("Use server consolidation heuristic", false);
        configuration.setAttribute("Server consolidation threshold for low utilisation", Double.toString(0.3));
        configuration.setAttribute("Weight of server consolidation heuristic", Double.toString(0.5));
        configuration.setAttribute("Use server expansion heuristic", false);
        configuration.setAttribute("Server expansion maximum number of reallocations", Integer.toString(1));
        configuration.setAttribute("Server expansion threshold for high utilisation", Double.toString(0.7));
        configuration.setAttribute("Weight of server expansion heuristic", Double.toString(0.5));
        configuration.setAttribute(USE_ANTIPATTERNS, false);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        Hashtable<Text, String> valuesToCheck = new Hashtable<Text, String>();
        if (this.useProcessingRateButton.getSelection()) {
            valuesToCheck.put(this.processingRateDecreaseFactor, "Processing rate: Decrease factor");
            valuesToCheck.put(this.processingRateIncreaseFactor, "Processing rate: Increase factor");
        }
        for (Text text : valuesToCheck.keySet()) {
            try {
                Double.parseDouble(text.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.setErrorMessage(String.valueOf((String)valuesToCheck.get(text)) + " (" + text.getText() + ") must be a double value or empty.");
                return false;
            }
        }
        valuesToCheck = new Hashtable();
        if (this.useServerExpansionButton.getSelection()) {
            valuesToCheck.put(this.serverExpansionMaxNumberOfReplacements, "Server expansion: Maximum number of reallocations");
        }
        for (Text text : valuesToCheck.keySet()) {
            try {
                Integer.parseInt(text.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.setErrorMessage(String.valueOf((String)valuesToCheck.get(text)) + " (" + text.getText() + ") must be an integer value or empty.");
                return false;
            }
        }
        valuesToCheck = new Hashtable();
        valuesToCheck.put(this.tacticsProbabilityText, TACTICS_PROBABILITY);
        if (this.useProcessingRateButton.getSelection()) {
            valuesToCheck.put(this.processingRateWeight, "Processing rate: Weight");
            valuesToCheck.put(this.processingRateThresholdLowUtilisation, "Processing rate: Threshold for low utilisation");
            valuesToCheck.put(this.processingRateThresholdHighUtilisation, "Processing rate: Threshold for high utilisation");
        }
        if (this.useReallocationButton.getSelection()) {
            valuesToCheck.put(this.reallocationWeight, "Reallocation: Weight");
            valuesToCheck.put(this.reallocationThresholdUtilisationDifference, "Reallocation: Threshold for utilisation difference");
        }
        if (this.useServerConsolidationButton.getSelection()) {
            valuesToCheck.put(this.serverConsolidationWeight, SERVER_CONSOLIDATION_WEIGHT);
            valuesToCheck.put(this.serverConsolidationThresholdLowUtilisation, "Server consolidation: Threshold for low utilisation");
        }
        if (this.useServerExpansionButton.getSelection()) {
            valuesToCheck.put(this.serverExpansionWeight, "Server expansion: Weight");
            valuesToCheck.put(this.serverExpansionThresholdHighUtilisation, "Server expansion: Threshold for high utilisation");
        }
        for (Text text : valuesToCheck.keySet()) {
            try {
                if (!(Double.parseDouble(text.getText()) < 0.0) && !(Double.parseDouble(text.getText()) > 1.0)) continue;
                throw new NumberFormatException();
            }
            catch (NumberFormatException numberFormatException) {
                this.setErrorMessage(String.valueOf((String)valuesToCheck.get(text)) + " (" + text.getText() + ") must be a double value between 0.0 and 1.0 or empty.");
                return false;
            }
        }
        return true;
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    private void updateSelections() {
        this.updateProcessingRateSelection();
        this.updateReallocationSelection();
        this.updateServerConsolidationSelection();
        this.updateServerExpansionSelection();
    }

    private void updateServerConsolidationSelection() {
        boolean selected = this.useServerConsolidationButton.getSelection();
        this.serverConsolidationThresholdLowUtilisationLabel.setEnabled(selected);
        this.serverConsolidationThresholdLowUtilisation.setEnabled(selected);
        this.serverConsolidationWeightLabel.setEnabled(selected);
        this.serverConsolidationWeight.setEnabled(selected);
        this.updateLaunchConfigurationDialog();
    }

    private void updateServerExpansionSelection() {
        boolean selected = this.useServerExpansionButton.getSelection();
        this.serverExpansionThresholdHighUtilisationLabel.setEnabled(selected);
        this.serverExpansionThresholdHighUtilisation.setEnabled(selected);
        this.serverExpansionMaxNumberOfReplacementsLabel.setEnabled(selected);
        this.serverExpansionMaxNumberOfReplacements.setEnabled(selected);
        this.serverExpansionWeightLabel.setEnabled(selected);
        this.serverExpansionWeight.setEnabled(selected);
        this.updateLaunchConfigurationDialog();
    }

    private void updateReallocationSelection() {
        boolean selected = this.useReallocationButton.getSelection();
        this.reallocationThresholdUtilisationDifferenceLabel.setEnabled(selected);
        this.reallocationThresholdUtilisationDifference.setEnabled(selected);
        this.reallocationWeightLabel.setEnabled(selected);
        this.reallocationWeight.setEnabled(selected);
        this.updateLaunchConfigurationDialog();
    }

    private void updateProcessingRateSelection() {
        boolean selected = this.useProcessingRateButton.getSelection();
        this.processingRateThresholdHighUtilisationLabel.setEnabled(selected);
        this.processingRateThresholdHighUtilisation.setEnabled(selected);
        this.processingRateThresholdLowUtilisationLabel.setEnabled(selected);
        this.processingRateThresholdLowUtilisation.setEnabled(selected);
        this.processingRateDecreaseFactorLabel.setEnabled(selected);
        this.processingRateDecreaseFactor.setEnabled(selected);
        this.processingRateIncreaseFactorLabel.setEnabled(selected);
        this.processingRateIncreaseFactor.setEnabled(selected);
        this.processingRateWeightLabel.setEnabled(selected);
        this.processingRateWeight.setEnabled(selected);
        this.updateLaunchConfigurationDialog();
    }
}

