/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators;

import com.google.inject.Inject;
import de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators.ITactic;
import de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators.TacticOperatorsManager;
import de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators.TacticsResultCandidate;
import de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators.UtilisationResultCacheAndHelper;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEIndividual;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEIndividualFactory;
import de.uka.ipd.sdq.dsexplore.qml.pcm.reader.PCMDeclarationsReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.opt4j.core.Constraint;
import org.opt4j.core.Criterion;
import org.opt4j.core.Genotype;
import org.opt4j.core.InfeasibilityConstraint;
import org.opt4j.core.SatisfactionConstraint;
import org.opt4j.core.Value;
import org.opt4j.operator.copy.Copy;

public class QMLBoundDependentTacticOperatorsManager
extends TacticOperatorsManager {
    @Inject
    public QMLBoundDependentTacticOperatorsManager(Copy<Genotype> copy, DSEIndividualFactory individualFactory) {
        super(copy, individualFactory);
    }

    @Override
    public List<TacticsResultCandidate> getAllCandidates(DSEIndividual individual) {
        UtilisationResultCacheAndHelper resultsCache = new UtilisationResultCacheAndHelper();
        ArrayList<TacticsResultCandidate> result = new ArrayList<TacticsResultCandidate>();
        HashSet<ITactic> applicableHeuristics = new HashSet<ITactic>();
        ConstraintViolationInformation cvi = this.analyzeConstraints(individual);
        if (cvi.getViolatedInfeasibilityConstraints().size() > 0) {
            for (InfeasibilityConstraint infeasibilityConstraint : cvi.getViolatedInfeasibilityConstraints()) {
                pivotAspectContext = PCMDeclarationsReader.retranslateCriterionToEvaluationAspect((Criterion)infeasibilityConstraint);
                for (ITactic h : this.heuristics) {
                    if (!h.improves(pivotAspectContext.getDimension(), pivotAspectContext.getEvaluationAspect())) continue;
                    applicableHeuristics.add(h);
                }
            }
        } else if (cvi.getViolatedSatisfactionConstraints().size() > 0) {
            for (SatisfactionConstraint satisfactionConstraint : cvi.getViolatedSatisfactionConstraints()) {
                pivotAspectContext = PCMDeclarationsReader.retranslateCriterionToEvaluationAspect((Criterion)satisfactionConstraint);
                for (ITactic h : this.heuristics) {
                    if (!h.improves(pivotAspectContext.getDimension(), pivotAspectContext.getEvaluationAspect())) continue;
                    applicableHeuristics.add(h);
                }
            }
        } else {
            applicableHeuristics.addAll(this.heuristics);
        }
        if (applicableHeuristics.size() == 0) {
            applicableHeuristics.addAll(this.heuristics);
        }
        for (ITactic iTactic : applicableHeuristics) {
            List<TacticsResultCandidate> candidatesFromCurrentHeuristic = iTactic.getHeuristicCandidates(individual, resultsCache);
            if (candidatesFromCurrentHeuristic.size() > 0) {
                this.writer.writeTacticCandidateInfo(iTactic, candidatesFromCurrentHeuristic);
            }
            result.addAll(candidatesFromCurrentHeuristic);
        }
        return result;
    }

    protected boolean isViolated(Map.Entry<Constraint, Value<?>> constraintAndValue) {
        boolean violated = false;
        Constraint c = constraintAndValue.getKey();
        Value<?> v = constraintAndValue.getValue();
        switch (c.getDirection()) {
            case less: {
                if (v.getDouble() < c.getLimit()) break;
                violated = true;
                break;
            }
            case lessOrEqual: {
                if (v.getDouble() <= c.getLimit()) break;
                violated = true;
                break;
            }
            case equal: {
                if (v.getDouble().doubleValue() == c.getLimit()) break;
                violated = true;
                break;
            }
            case greater: {
                if (v.getDouble() > c.getLimit()) break;
                violated = true;
                break;
            }
            case greaterOrEqual: {
                if (v.getDouble() >= c.getLimit()) break;
                violated = true;
                break;
            }
            default: {
                throw new RuntimeException("Unexpected case in switch statement!");
            }
        }
        return violated;
    }

    protected boolean isFulfilled(Map.Entry<Constraint, Value<?>> constraintAndValue) {
        boolean fulfilled = false;
        Constraint c = constraintAndValue.getKey();
        Value<?> v = constraintAndValue.getValue();
        switch (c.getDirection()) {
            case less: {
                if (!(v.getDouble() < c.getLimit())) break;
                fulfilled = true;
                break;
            }
            case lessOrEqual: {
                if (!(v.getDouble() <= c.getLimit())) break;
                fulfilled = true;
                break;
            }
            case equal: {
                if (v.getDouble().doubleValue() != c.getLimit()) break;
                fulfilled = true;
                break;
            }
            case greater: {
                if (!(v.getDouble() > c.getLimit())) break;
                fulfilled = true;
                break;
            }
            case greaterOrEqual: {
                if (!(v.getDouble() >= c.getLimit())) break;
                fulfilled = true;
                break;
            }
            default: {
                throw new RuntimeException("Unexpected case in switch statement!");
            }
        }
        return fulfilled;
    }

    protected ConstraintViolationInformation analyzeConstraints(DSEIndividual individual) {
        ConstraintViolationInformation cvi = new ConstraintViolationInformation();
        for (Map.Entry constraintAndValue : individual.getObjectives().getConstraints()) {
            if (this.isViolated(constraintAndValue)) {
                if (constraintAndValue.getKey() instanceof InfeasibilityConstraint) {
                    cvi.addViolatedInfeasibilityConstraint((InfeasibilityConstraint)constraintAndValue.getKey());
                    continue;
                }
                cvi.addViolatedSatisfactionConstraint((SatisfactionConstraint)constraintAndValue.getKey());
                continue;
            }
            if (!this.isFulfilled(constraintAndValue)) continue;
            if (constraintAndValue.getKey() instanceof InfeasibilityConstraint) {
                cvi.addFulfilledInfeasibilityConstraint((InfeasibilityConstraint)constraintAndValue.getKey());
                continue;
            }
            cvi.addFulfilledSatisfactionConstraint((SatisfactionConstraint)constraintAndValue.getKey());
        }
        return cvi;
    }

    protected class ConstraintViolationInformation {
        protected List<InfeasibilityConstraint> violatedInfeasibilityConstraints = new ArrayList<InfeasibilityConstraint>();
        protected List<InfeasibilityConstraint> fulfilledInfeasibilityConstraints = new ArrayList<InfeasibilityConstraint>();
        protected List<SatisfactionConstraint> violatedSatisfactionConstraints = new ArrayList<SatisfactionConstraint>();
        protected List<SatisfactionConstraint> fulfilledSatisfactionConstraints = new ArrayList<SatisfactionConstraint>();

        protected ConstraintViolationInformation() {
        }

        public List<InfeasibilityConstraint> getViolatedInfeasibilityConstraints() {
            return this.violatedInfeasibilityConstraints;
        }

        public void addViolatedInfeasibilityConstraint(InfeasibilityConstraint violoatedInfeasibilityConstraint) {
            this.violatedInfeasibilityConstraints.add(violoatedInfeasibilityConstraint);
        }

        public List<InfeasibilityConstraint> getFulfilledInfeasibilityConstraints() {
            return this.fulfilledInfeasibilityConstraints;
        }

        public void addFulfilledInfeasibilityConstraint(InfeasibilityConstraint fulfilledInfeasibilityConstraint) {
            this.fulfilledInfeasibilityConstraints.add(fulfilledInfeasibilityConstraint);
        }

        public List<SatisfactionConstraint> getViolatedSatisfactionConstraints() {
            return this.violatedSatisfactionConstraints;
        }

        public void addViolatedSatisfactionConstraint(SatisfactionConstraint violoatedSatisfactionConstraint) {
            this.violatedSatisfactionConstraints.add(violoatedSatisfactionConstraint);
        }

        public List<SatisfactionConstraint> getFulfilledSatisfactionConstraints() {
            return this.fulfilledSatisfactionConstraints;
        }

        public void addFulfilledSatisfactionConstraint(SatisfactionConstraint fulfilledSatisfactionConstraint) {
            this.fulfilledSatisfactionConstraints.add(fulfilledSatisfactionConstraint);
        }
    }
}

