/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators;

import de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators.ITactic;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEIndividual;
import de.uka.ipd.sdq.pcm.designdecision.DecisionSpace;
import org.apache.log4j.Logger;

public class TacticsResultCandidate
extends DSEIndividual {
    protected static Logger logger = Logger.getLogger((String)TacticsResultCandidate.class.getName());
    private double candidateWeight;
    private ITactic heuristic;
    private DSEIndividual parent;

    public TacticsResultCandidate(DecisionSpace problem, DSEIndividual parent) {
        super(problem);
        this.parent = parent;
    }

    public double getCandidateWeight() {
        return this.candidateWeight;
    }

    public void setCandidateWeight(double candidateWeight) {
        if (candidateWeight < 0.0 || candidateWeight > 1.0) {
            logger.warn((Object)("Candidate weight value (" + candidateWeight + ") was not in [0,1], I will round it."));
            candidateWeight = Math.max(0.0, candidateWeight);
            candidateWeight = Math.min(1.0, candidateWeight);
        }
        this.candidateWeight = candidateWeight;
    }

    public ITactic getHeuristic() {
        return this.heuristic;
    }

    public void setHeuristic(ITactic heuristic) {
        this.heuristic = heuristic;
    }

    public double getFinalWeight() {
        return this.getHeuristic().getHeuristicWeight() * this.getCandidateWeight();
    }

    public DSEIndividual getParent() {
        return this.parent;
    }
}

