/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.stoex.analyser.visitors;

import de.uka.ipd.sdq.errorhandling.core.IIssue;
import de.uka.ipd.sdq.stoex.BooleanOperatorExpression;
import de.uka.ipd.sdq.stoex.Expression;
import de.uka.ipd.sdq.stoex.IfElseExpression;
import de.uka.ipd.sdq.stoex.NegativeExpression;
import de.uka.ipd.sdq.stoex.NotExpression;
import de.uka.ipd.sdq.stoex.ProductExpression;
import de.uka.ipd.sdq.stoex.StoexPackage;
import de.uka.ipd.sdq.stoex.TermExpression;
import de.uka.ipd.sdq.stoex.analyser.exceptions.ExpectedTypeMismatchIssue;
import de.uka.ipd.sdq.stoex.analyser.visitors.ExpressionInferTypeVisitor;
import de.uka.ipd.sdq.stoex.analyser.visitors.NonProbabilisticExpressionInferTypeVisitor;
import de.uka.ipd.sdq.stoex.analyser.visitors.TypeEnum;
import de.uka.ipd.sdq.stoex.util.StoexSwitch;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class TypeCheckVisitor
extends StoexSwitch<Object> {
    private ExpressionInferTypeVisitor typeVisitor;
    private ArrayList<IIssue> issues = new ArrayList();

    public TypeCheckVisitor(NonProbabilisticExpressionInferTypeVisitor typeVisitor) {
        this.typeVisitor = typeVisitor;
    }

    public Object caseNegativeExpression(NegativeExpression object) {
        if (!this.isNummericType(this.typeVisitor.getType((Expression)object.getInner()))) {
            this.issues.add(new ExpectedTypeMismatchIssue("Numeric", this.typeVisitor.getType((Expression)object.getInner()), (EObject)object, (EStructuralFeature)StoexPackage.eINSTANCE.getNegativeExpression_Inner()));
        }
        return super.caseNegativeExpression(object);
    }

    public Object caseBooleanOperatorExpression(BooleanOperatorExpression object) {
        if (!TypeCheckVisitor.typesCompatible(this.typeVisitor.getType((Expression)object.getLeft()), TypeEnum.BOOL)) {
            this.issues.add(new ExpectedTypeMismatchIssue(TypeEnum.BOOL, this.typeVisitor.getType((Expression)object.getLeft()), (EObject)object, (EStructuralFeature)StoexPackage.eINSTANCE.getBooleanOperatorExpression_Left()));
        }
        if (!TypeCheckVisitor.typesCompatible(this.typeVisitor.getType((Expression)object.getRight()), TypeEnum.BOOL)) {
            this.issues.add(new ExpectedTypeMismatchIssue(TypeEnum.BOOL, this.typeVisitor.getType((Expression)object.getRight()), (EObject)object, (EStructuralFeature)StoexPackage.eINSTANCE.getBooleanOperatorExpression_Right()));
        }
        return super.caseBooleanOperatorExpression(object);
    }

    public Object caseIfElseExpression(IfElseExpression object) {
        if (!TypeCheckVisitor.typesCompatible(this.typeVisitor.getType((Expression)object.getConditionExpression()), TypeEnum.BOOL)) {
            this.issues.add(new ExpectedTypeMismatchIssue(TypeEnum.BOOL, this.typeVisitor.getType((Expression)object.getConditionExpression()), (EObject)object, (EStructuralFeature)StoexPackage.eINSTANCE.getIfElseExpression_ConditionExpression()));
        }
        return super.caseIfElseExpression(object);
    }

    public Object caseNotExpression(NotExpression object) {
        if (!TypeCheckVisitor.typesCompatible(this.typeVisitor.getType((Expression)object.getInner()), TypeEnum.BOOL)) {
            this.issues.add(new ExpectedTypeMismatchIssue(TypeEnum.BOOL, this.typeVisitor.getType((Expression)object.getInner()), (EObject)object, (EStructuralFeature)StoexPackage.eINSTANCE.getNotExpression_Inner()));
        }
        return super.caseNotExpression(object);
    }

    public Object caseProductExpression(ProductExpression object) {
        if (!this.isNummericType(this.typeVisitor.getType((Expression)object.getLeft()))) {
            this.issues.add(new ExpectedTypeMismatchIssue("Numeric", this.typeVisitor.getType((Expression)object.getLeft()), (EObject)object, (EStructuralFeature)StoexPackage.eINSTANCE.getProductExpression_Left()));
        }
        if (!this.isNummericType(this.typeVisitor.getType((Expression)object.getRight()))) {
            this.issues.add(new ExpectedTypeMismatchIssue("Numeric", this.typeVisitor.getType((Expression)object.getRight()), (EObject)object, (EStructuralFeature)StoexPackage.eINSTANCE.getProductExpression_Right()));
        }
        return super.caseProductExpression(object);
    }

    public Object caseTermExpression(TermExpression object) {
        if (!this.isNummericType(this.typeVisitor.getType((Expression)object.getLeft()))) {
            this.issues.add(new ExpectedTypeMismatchIssue("Numeric", this.typeVisitor.getType((Expression)object.getLeft()), (EObject)object, (EStructuralFeature)StoexPackage.eINSTANCE.getTermExpression_Left()));
        }
        if (!this.isNummericType(this.typeVisitor.getType((Expression)object.getRight()))) {
            this.issues.add(new ExpectedTypeMismatchIssue("Numeric", this.typeVisitor.getType((Expression)object.getRight()), (EObject)object, (EStructuralFeature)StoexPackage.eINSTANCE.getTermExpression_Right()));
        }
        return super.caseTermExpression(object);
    }

    public static boolean typesCompatible(TypeEnum expectedType, TypeEnum foundType) {
        if (expectedType == TypeEnum.ANY) {
            return true;
        }
        if (expectedType == foundType) {
            return true;
        }
        if (foundType == TypeEnum.ANY) {
            return true;
        }
        return expectedType == TypeEnum.DOUBLE && (foundType == TypeEnum.INT || foundType == TypeEnum.DOUBLE);
    }

    private boolean isNummericType(TypeEnum type) {
        return type == TypeEnum.INT || type == TypeEnum.DOUBLE || type == TypeEnum.ANY;
    }

    public Collection<IIssue> getIssues() {
        return this.issues;
    }
}

