/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.tcfmoop.terminationcriteria;

import de.uka.ipd.sdq.tcfmoop.config.GivenParetoFrontIsReachedConfig;
import de.uka.ipd.sdq.tcfmoop.config.IConfiguration;
import de.uka.ipd.sdq.tcfmoop.outputtree.Node;
import de.uka.ipd.sdq.tcfmoop.terminationcriteria.AbstractTerminationCriterion;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.opt4j.core.Individual;
import org.opt4j.core.Objectives;
import org.opt4j.core.optimizer.Archive;
import org.opt4j.core.optimizer.Population;

public class GivenParetoFrontIsReachedCriterion
extends AbstractTerminationCriterion {
    private List<Objectives> paretoFront;
    private int initialParetoFrontSize;
    private double requiredPercentagesCovered;
    private double currentPercentagesCovered;
    private Node frontCoverageNode;

    public GivenParetoFrontIsReachedCriterion(IConfiguration conf, Population population, Archive archive) {
        super(conf, population, archive);
        if (!(conf instanceof GivenParetoFrontIsReachedConfig) || !conf.validateConfiguration()) {
            throw new RuntimeException("GivenParetoFrontIsReachedCriterion.initialize: wrong or invalid configuration object");
        }
        this.paretoFront = ((GivenParetoFrontIsReachedConfig)conf).getParetoFront();
        this.requiredPercentagesCovered = ((GivenParetoFrontIsReachedConfig)conf).getPercentagesToCover();
        this.initialParetoFrontSize = this.paretoFront.size();
        this.initializeOutputTree();
    }

    private void initializeOutputTree() {
        this.outputInformation.updateValue("Given Pareto Front Is Reached");
        this.outputInformation.getChildren().clear();
        this.frontCoverageNode = this.outputInformation.addChild("Front Coverage: " + this.currentPercentagesCovered + "/" + this.requiredPercentagesCovered, Node.NodeType.PARAMETER);
        this.outputInformation.getChildren().add(this.suggestedStop);
    }

    @Override
    public void evaluateImpl(int iteration, long currentTime) {
        this.currentPercentagesCovered = this.calcuteCoverage((Collection<Individual>)this.archive, this.paretoFront);
        this.evaluationResult = this.currentPercentagesCovered >= this.requiredPercentagesCovered;
    }

    private double calcuteCoverage(Collection<Individual> coveringFront, Collection<Objectives> toBeCoveredFront) {
        LinkedList<Objectives> indisToRemove = new LinkedList<Objectives>();
        block0: for (Objectives indiToBeDominated : toBeCoveredFront) {
            for (Individual coveringIndi : coveringFront) {
                if (!coveringIndi.getObjectives().weaklyDominates(indiToBeDominated)) continue;
                indisToRemove.add(indiToBeDominated);
                continue block0;
            }
        }
        toBeCoveredFront.removeAll(indisToRemove);
        return 1.0 - (double)toBeCoveredFront.size() / (double)this.initialParetoFrontSize;
    }

    @Override
    public void updateOutputInformation() {
        this.frontCoverageNode.updateValue("Front Coverage: " + this.currentPercentagesCovered + "/" + this.requiredPercentagesCovered);
    }
}

