/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.tcfmoop.terminationcriteria;

import de.uka.ipd.sdq.tcfmoop.config.IConfiguration;
import de.uka.ipd.sdq.tcfmoop.config.MaxGenerationNumberConfig;
import de.uka.ipd.sdq.tcfmoop.outputtree.Node;
import de.uka.ipd.sdq.tcfmoop.terminationcriteria.AbstractTerminationCriterion;
import org.opt4j.core.optimizer.Archive;
import org.opt4j.core.optimizer.Population;

public class MaxGenerationNumber
extends AbstractTerminationCriterion {
    private int maximumNumberOfGenerations;
    private int generationsSoFar;
    private Node currentMaxGenNode;

    public MaxGenerationNumber(IConfiguration conf, Population population, Archive archive) {
        super(conf, population, archive);
        if (!(conf instanceof MaxGenerationNumberConfig) || !conf.validateConfiguration()) {
            throw new RuntimeException("MaxGenerationNumber.initialize: wrong or invalid configuration object");
        }
        this.maximumNumberOfGenerations = ((MaxGenerationNumberConfig)conf).getMaximumNumberOfIterations();
        this.initializeOutputTree();
    }

    private void initializeOutputTree() {
        this.outputInformation.updateValue("Maximum Number of Generations");
        this.outputInformation.getChildren().clear();
        this.currentMaxGenNode = this.outputInformation.addChild("Current/Maximum: " + this.generationsSoFar + "/" + this.maximumNumberOfGenerations, Node.NodeType.PARAMETER);
        this.outputInformation.getChildren().add(this.suggestedStop);
    }

    @Override
    public void evaluateImpl(int iteration, long currentTime) {
        this.generationsSoFar = iteration;
        this.evaluationResult = this.generationsSoFar >= this.maximumNumberOfGenerations;
    }

    @Override
    public void updateOutputInformation() {
        this.currentMaxGenNode.updateValue("Current/Maximum Generation Number: " + this.generationsSoFar + "/" + this.maximumNumberOfGenerations);
    }
}

