/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.workflow.jobs;

import de.uka.ipd.sdq.workflow.blackboard.Blackboard;
import de.uka.ipd.sdq.workflow.jobs.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.jobs.JobProxy;
import java.util.Optional;
import java.util.function.Supplier;

public class BlackboardAwareJobProxy<BlackboardType extends Blackboard<?>>
extends JobProxy
implements IBlackboardInteractingJob<BlackboardType> {
    private Optional<BlackboardType> blackboard;

    public BlackboardAwareJobProxy(String name, Supplier<IJob> jobSupplier) {
        super(name, jobSupplier);
    }

    @Override
    public void setBlackboard(BlackboardType blackboard) {
        this.blackboard = Optional.of(blackboard);
    }

    @Override
    protected IJob supplyJob() {
        IJob job = super.supplyJob();
        if (job instanceof IBlackboardInteractingJob) {
            this.blackboard.ifPresent(bb -> ((IBlackboardInteractingJob)job).setBlackboard(bb));
        }
        return job;
    }
}

