/*
 * Decompiled with CFR 0.152.
 */
package de.upb.swt.core.ui.properties.sections;

import de.upb.swt.core.ui.properties.sections.AbstractFeaturePropertySection;
import de.upb.swt.core.ui.properties.util.State;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public abstract class AbstractCheckboxSection
extends AbstractFeaturePropertySection {
    private Button button;
    private Label icon;

    @Override
    public void refresh() {
        if (this.isReady() && this.hasChanged()) {
            this.button.setSelection(this.getValue().booleanValue());
            this.validate();
        }
    }

    private boolean isReady() {
        return this.button != null && !this.button.isDisposed();
    }

    private boolean hasChanged() {
        boolean oldValue = this.button.getSelection();
        Boolean newValue = this.getValue();
        if (newValue == null) {
            return false;
        }
        return !newValue.equals(oldValue);
    }

    private void validate() {
        this.decorateImage(this.icon, this.validate(this.getValue()));
    }

    @Override
    protected Boolean getValue() {
        return (Boolean)super.getValue();
    }

    protected State validate(Boolean value) {
        return State.NONE;
    }

    @Override
    protected void createWidgets(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        this.button = factory.createButton(parent, this.getLabelText(), 32);
        this.icon = factory.createLabel(parent, "");
        this.icon.setToolTipText(this.getHelpText());
    }

    protected abstract String getLabelText();

    protected String getHelpText() {
        return null;
    }

    @Override
    protected void hookWidgetListeners() {
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractCheckboxSection.this.set(AbstractCheckboxSection.this.button.getSelection());
                AbstractCheckboxSection.this.validate();
            }
        });
    }

    @Override
    protected void layoutWidgets() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 120);
        data.right = new FormAttachment(100, -34);
        data.top = new FormAttachment(0);
        data.bottom = new FormAttachment(100);
        this.button.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)this.button, 12, 131072);
        data.right = new FormAttachment(100, -6);
        data.top = new FormAttachment((Control)this.button, 0, 128);
        data.bottom = new FormAttachment((Control)this.button, 0, 1024);
        this.icon.setLayoutData((Object)data);
    }
}

