/*
 * Decompiled with CFR 0.152.
 */
package de.upb.swt.core.ui.properties.sections;

import de.upb.swt.core.ui.properties.sections.AbstractFeaturePropertySection;
import de.upb.swt.core.ui.properties.sections.AbstractPropertySection;
import de.upb.swt.core.ui.properties.util.State;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public abstract class AbstractGroupSection
extends AbstractFeaturePropertySection {
    private List<AbstractFeaturePropertySection> sections = new ArrayList<AbstractFeaturePropertySection>();
    protected boolean useCheckbox = this.getFeature().getLowerBound() == 0;
    protected Label label;
    protected Button checkbox;
    protected Group group;
    protected int offset = 6;

    public void addSection(AbstractFeaturePropertySection section) {
        this.sections.add(section);
    }

    public void removeSection(AbstractFeaturePropertySection section) {
        this.sections.remove(section);
    }

    @Override
    public void refresh() {
        if (!this.isReady()) {
            return;
        }
        Object object = this.getValue();
        if (this.hasChanged()) {
            this.setSelection(object);
            this.validate();
        }
        this.group.setVisible((object = this.getValue()) != null);
        this.layoutWidgets();
        if (object != null) {
            StructuredSelection selection = new StructuredSelection(object);
            for (AbstractPropertySection abstractPropertySection : this.sections) {
                abstractPropertySection.setInput(null, (ISelection)selection);
                abstractPropertySection.refresh();
            }
        }
        AbstractGroupSection.revalidateLayout((Control)this.group);
    }

    private void setSelection(Object value) {
        if (this.checkbox != null) {
            this.checkbox.setSelection(value != null);
        }
    }

    private boolean isReady() {
        return this.group != null && !this.group.isDisposed();
    }

    private boolean hasChanged() {
        boolean oldValue = true;
        if (this.checkbox != null) {
            oldValue = this.checkbox.getSelection();
        }
        boolean newValue = this.getValue() != null;
        return oldValue ^ newValue;
    }

    private void validate() {
        boolean isSet;
        Object object = this.getValue();
        boolean bl = isSet = this.checkbox == null || this.checkbox.getSelection();
        if (object == null && isSet) {
            EClassifier classifier = this.getFeature().getEType();
            object = EcoreUtil.create((EClass)((EClass)classifier));
        }
        if (object != null && !isSet) {
            object = null;
        }
        this.set(object);
    }

    protected State validate(Object value) {
        return State.NONE;
    }

    protected String getCheckboxText() {
        return this.toHumanReadable(this.getFeature().getEType().getName());
    }

    private String toHumanReadable(String camelCased) {
        StringBuffer buffer = new StringBuffer();
        boolean newWord = true;
        boolean oldWord = true;
        int p = 0;
        while (p < camelCased.length()) {
            char c = camelCased.charAt(p);
            newWord = Character.isUpperCase(c);
            if (newWord && !oldWord) {
                buffer.append(' ');
            }
            oldWord = newWord;
            buffer.append(c);
            ++p;
        }
        return buffer.toString();
    }

    @Override
    protected void createWidgets(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        if (this.useCheckbox) {
            String checkboxText = this.getCheckboxText();
            this.checkbox = factory.createButton(parent, checkboxText, 32);
        }
        this.group = factory.createGroup(parent, "");
        String labelText = String.valueOf(this.getLabelText()) + ':';
        this.label = factory.createLabel(parent, labelText, 131072);
        GridLayout layout = new GridLayout(1, true);
        layout.marginRight = 0;
        layout.marginLeft = 0;
        layout.marginBottom = 0;
        layout.marginTop = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.group.setLayout((Layout)layout);
        for (AbstractPropertySection abstractPropertySection : this.sections) {
            abstractPropertySection.createControls((Composite)this.group, this.getPage());
        }
        Control[] controlArray = this.group.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.setLayoutData((Object)new GridData(4, 128, true, false));
            ++n2;
        }
        if (this.useCheckbox) {
            this.group.setVisible(false);
        }
    }

    protected abstract String getLabelText();

    protected String getHelpText() {
        return null;
    }

    @Override
    protected void hookWidgetListeners() {
        if (this.checkbox != null) {
            this.checkbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractGroupSection.this.validate();
                }
            });
        }
    }

    @Override
    protected void layoutWidgets() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 120);
        data.right = new FormAttachment(100, -34);
        data.top = new FormAttachment(0, 2 * this.offset);
        data.bottom = this.group.isVisible() ? new FormAttachment(100) : new FormAttachment(0);
        this.group.setLayoutData((Object)data);
        if (this.useCheckbox) {
            data = new FormData();
            data.left = new FormAttachment(0, 136);
            data.top = new FormAttachment(0, this.offset);
            this.checkbox.setLayoutData((Object)data);
        }
        data = new FormData();
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(0, 120);
        data.top = new FormAttachment(0, this.offset);
        data.bottom = new FormAttachment(100);
        this.label.setLayoutData((Object)data);
    }

    public static void revalidateLayout(Control control) {
        Control c = control;
        do {
            if (!(c instanceof ExpandBar)) continue;
            ExpandBar expandBar = (ExpandBar)c;
            ExpandItem[] expandItemArray = expandBar.getItems();
            int n = expandItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                ExpandItem expandItem = expandItemArray[n2];
                expandItem.setHeight(expandItem.getControl().computeSize((int)expandBar.getSize().x, (int)-1, (boolean)true).y);
                ++n2;
            }
        } while ((c = c.getParent()) != null && c.getParent() != null && !(c instanceof ScrolledComposite));
        if (c instanceof ScrolledComposite) {
            ScrolledComposite scrolledComposite = (ScrolledComposite)c;
            if (scrolledComposite.getExpandHorizontal() || scrolledComposite.getExpandVertical()) {
                scrolledComposite.setMinSize(scrolledComposite.getContent().computeSize(-1, -1, true));
            } else {
                scrolledComposite.getContent().pack(true);
            }
        }
        if (c instanceof Composite) {
            Composite composite = (Composite)c;
            composite.layout(true, true);
        }
    }
}

