/*
 * Decompiled with CFR 0.152.
 */
package de.upb.swt.core.ui.properties.sections;

import de.upb.swt.core.ui.properties.sections.AbstractFeaturePropertySection;
import de.upb.swt.core.ui.properties.util.State;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public abstract class AbstractRadioGroupSection<T extends Enumerator>
extends AbstractFeaturePropertySection {
    private final Map<T, Button> buttons = new LinkedHashMap<T, Button>();
    private Label label;
    private Composite composite;
    private Label icon;

    @Override
    public void refresh() {
        if (this.isReady() && this.hasChanged()) {
            Button button2;
            for (Button button2 : this.buttons.values()) {
                if (button2.isDisposed()) continue;
                button2.setSelection(false);
            }
            button2 = this.buttons.get(this.getValue());
            if (!button2.isDisposed()) {
                button2.setSelection(true);
            }
            this.checkEnabled();
            this.validate();
        }
    }

    private void validate() {
        this.decorateImage(this.icon, this.validate(this.getValue()));
    }

    protected T getValue() {
        return (T)((Enumerator)super.getValue());
    }

    protected void checkEnabled() {
        for (Enumerator literal : this.buttons.keySet()) {
            Button button = this.buttons.get(literal);
            if (button == null || button.isDisposed()) continue;
            button.setEnabled(this.isEnabled(literal));
        }
    }

    @Override
    protected void createWidgets(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        this.label = factory.createLabel(parent, String.valueOf(this.getLabelText()) + ':', 131072);
        this.composite = factory.createFlatFormComposite(parent);
        for (Enumerator literal : this.getValues()) {
            Button button = factory.createButton(this.composite, this.getText(literal), 16);
            button.setToolTipText(this.getToolTipText(literal));
            this.buttons.put(literal, button);
        }
        this.icon = factory.createLabel(parent, "");
    }

    protected abstract String getLabelText();

    protected State validate(T literal) {
        return State.NONE;
    }

    protected String getText(T literal) {
        return literal.getName();
    }

    protected String getToolTipText(T literal) {
        return null;
    }

    protected abstract List<T> getValues();

    @Override
    protected void hookWidgetListeners() {
        for (final Enumerator literal : this.buttons.keySet()) {
            Button button = this.buttons.get(literal);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractRadioGroupSection.this.set(literal);
                    AbstractRadioGroupSection.this.validate();
                }
            });
        }
    }

    protected boolean isEnabled(T literal) {
        return true;
    }

    protected boolean isVertical() {
        return false;
    }

    @Override
    protected void layoutWidgets() {
        if (this.isVertical()) {
            GridLayoutFactory.fillDefaults().applyTo(this.composite);
        } else {
            GridLayoutFactory.fillDefaults().numColumns(this.buttons.size()).applyTo(this.composite);
        }
        for (Button button : this.buttons.values()) {
            GridDataFactory.fillDefaults().grab(false, true).applyTo((Control)button);
        }
        FormData data = new FormData();
        data.left = new FormAttachment(0, 120);
        data.right = new FormAttachment(100, -34);
        data.top = new FormAttachment(0);
        data.bottom = new FormAttachment(100);
        this.composite.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)this.composite, 12, 131072);
        data.right = new FormAttachment(100, -6);
        data.top = new FormAttachment((Control)this.composite, 0, 128);
        data.bottom = new FormAttachment((Control)this.composite, 0, 1024);
        this.icon.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0);
        data.right = new FormAttachment((Control)this.composite, -6);
        data.top = new FormAttachment((Control)this.composite, 2, 128);
        data.bottom = new FormAttachment((Control)this.composite, 0, 1024);
        this.label.setLayoutData((Object)data);
    }

    private boolean hasChanged() {
        return !this.buttons.get(this.getValue()).getSelection();
    }

    private boolean isReady() {
        return this.composite != null && !this.composite.isDisposed();
    }
}

