/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.behaviour;

import FeatureCompletionModel.CompletionComponent;
import de.uka.ipd.sdq.dsexplore.tools.primitives.Pair;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.ErrorMessage;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.FCCUtil;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.port.FCCModule;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.port.FCCWeaverException;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.behaviour.IBehaviourWeaving;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.behaviour.IWeavingInstruction;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.behaviour.IWeavingLocation;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.handler.FCCStructureHandler;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.handler.RoleHandler;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.handler.RoleHandlerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.core.composition.AssemblyConnector;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.Connector;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.repository.RequiredRole;
import org.palladiosimulator.pcm.repository.Role;

public class AssemblyWeaving {
    protected final IBehaviourWeaving parent;
    private FCCStructureHandler fccHandler;

    public AssemblyWeaving(IBehaviourWeaving parent) {
        this.parent = parent;
    }

    public void weave(IWeavingInstruction instruction) {
        FCCModule.LOGGER.debug((Object)"Assembly Behaviour Weaving");
        CompletionComponent perimeterProvidingFCC = (CompletionComponent)instruction.getFccWithProvidedRole().first;
        List providedSigs = (List)instruction.getFccWithProvidedRole().getSecond();
        this.fccHandler = new FCCStructureHandler(perimeterProvidingFCC, this.parent.getMergedRepoManager());
        List<CompletionComponent> allFCCs = this.determineAllFCCs(perimeterProvidingFCC);
        List<RepositoryComponent> realizingComponents = this.parent.getMergedRepoManager().getRealizingComponentsByFCCList(allFCCs, providedSigs, this.parent.getSelectedCVs());
        realizingComponents.addAll(this.determineAdditionalComplementaComponents(realizingComponents));
        for (IWeavingLocation iWeavingLocation : instruction.getWeavingLocations()) {
            List<AssemblyContext> createdAssemblyContexts = this.createAssemblyContexts(instruction, realizingComponents);
            List<Connector> createdConnectors = this.createAssemblyConnectors(instruction, createdAssemblyContexts);
            List<Connector> connectors = this.createAssemblyConnectorToFC(providedSigs, iWeavingLocation, createdAssemblyContexts, perimeterProvidingFCC);
            if (this.parent.getPCMSystemManager().existConnectors(connectors)) continue;
            this.parent.getPCMSystemManager().addAssemblyContexts(createdAssemblyContexts);
            this.parent.getPCMSystemManager().addConnectors(createdConnectors);
            this.parent.getPCMSystemManager().addConnectors((Connector[])connectors.toArray(new AssemblyConnector[connectors.size()]));
        }
    }

    private List<Connector> createAssemblyConnectorToFC(List<OperationSignature> providedSigs, IWeavingLocation location, List<AssemblyContext> createdAssemblyContexts, CompletionComponent fcc) {
        AssemblyContext providedAssemblyContext = null;
        providedAssemblyContext = createdAssemblyContexts.isEmpty() ? this.fccHandler.getComponentsIntantiatingFCC(fcc, this.parent.getPCMSystemManager().getAssemblyContextsBy(context -> true)) : this.fccHandler.getComponentsIntantiatingFCC(fcc, createdAssemblyContexts);
        ArrayList<Connector> connectors = new ArrayList<Connector>();
        for (OperationSignature providedSig : providedSigs) {
            AssemblyContext requiredAssemblyContext = location.getAffectedContext();
            ProvidedRole providedRole = (ProvidedRole)providedAssemblyContext.getEncapsulatedComponent__AssemblyContext().getProvidedRoles_InterfaceProvidingEntity().stream().filter(role -> ((OperationProvidedRole)role).getProvidedInterface__OperationProvidedRole().getSignatures__OperationInterface().contains((Object)providedSig)).collect(Collectors.toList()).get(0);
            RequiredRole requiredRole = (RequiredRole)requiredAssemblyContext.getEncapsulatedComponent__AssemblyContext().getRequiredRoles_InterfaceRequiringEntity().stream().filter(role -> ((OperationRequiredRole)role).getRequiredInterface__OperationRequiredRole().getSignatures__OperationInterface().contains((Object)providedSig)).collect(Collectors.toList()).get(0);
            AssemblyConnector connector = this.parent.getPCMSystemManager().createAssemblyConnectorBy((Pair<OperationRequiredRole, AssemblyContext>)Pair.of((Object)((OperationRequiredRole)requiredRole), (Object)requiredAssemblyContext), (Pair<OperationProvidedRole, AssemblyContext>)Pair.of((Object)((OperationProvidedRole)providedRole), (Object)providedAssemblyContext));
            connectors.add((Connector)connector);
        }
        return connectors;
    }

    private List<Connector> createAssemblyConnectors(IWeavingInstruction instruction, List<AssemblyContext> createdAssemblyContexts) {
        ArrayList<Connector> createdConnectors = new ArrayList<Connector>();
        for (AssemblyContext assemblyContext : createdAssemblyContexts) {
            for (RequiredRole requiredRole : assemblyContext.getEncapsulatedComponent__AssemblyContext().getRequiredRoles_InterfaceRequiringEntity()) {
                ProvidedRole compProvidedRole = (ProvidedRole)this.getComplimentaryRoleOf((Role)requiredRole, this.getAllProvidedRolesOf(createdAssemblyContexts));
                AssemblyContext providedAssemblyContext = this.getAssemblyContextProviding(compProvidedRole, createdAssemblyContexts);
                AssemblyConnector connector = this.parent.getPCMSystemManager().createAssemblyConnectorBy((Pair<OperationRequiredRole, AssemblyContext>)Pair.of((Object)((OperationRequiredRole)requiredRole), (Object)assemblyContext), (Pair<OperationProvidedRole, AssemblyContext>)Pair.of((Object)((OperationProvidedRole)compProvidedRole), (Object)providedAssemblyContext));
                if (instruction.getInclusionMechanism().isMultiple()) {
                    createdConnectors.add((Connector)connector);
                    continue;
                }
                if (this.parent.getPCMSystemManager().existConnector((Connector)connector)) continue;
                createdConnectors.add((Connector)connector);
            }
        }
        return createdConnectors;
    }

    private List<AssemblyContext> createAssemblyContexts(IWeavingInstruction instruction, List<RepositoryComponent> realizingComponents) {
        ArrayList<AssemblyContext> createdAssemblyContexts = new ArrayList<AssemblyContext>();
        for (RepositoryComponent repositoryComponent : realizingComponents) {
            AssemblyContext newAssemblyContext;
            if (instruction.getInclusionMechanism().isMultiple()) {
                newAssemblyContext = this.parent.getPCMSystemManager().createAssemblyContextOf(repositoryComponent);
                createdAssemblyContexts.add(newAssemblyContext);
                continue;
            }
            if (!this.parent.getPCMSystemManager().getAssemblyContextsInstantiating(repositoryComponent).isEmpty()) continue;
            newAssemblyContext = this.parent.getPCMSystemManager().createAssemblyContextOf(repositoryComponent);
            createdAssemblyContexts.add(newAssemblyContext);
        }
        return createdAssemblyContexts;
    }

    private Collection<? extends RepositoryComponent> determineAdditionalComplementaComponents(List<RepositoryComponent> realizingComponents) {
        ArrayList<RepositoryComponent> additionalComplementaComponents = new ArrayList<RepositoryComponent>();
        if (this.fccHandler.requiresComplementa(realizingComponents)) {
            additionalComplementaComponents.addAll(this.fccHandler.getRequiredComplementa(realizingComponents));
        }
        return additionalComplementaComponents;
    }

    private List<CompletionComponent> determineAllFCCs(CompletionComponent perimeterProvidingFCC) {
        List<CompletionComponent> allFCCs = this.fccHandler.getFCCsRequiredBy(perimeterProvidingFCC);
        allFCCs.add(perimeterProvidingFCC);
        return allFCCs;
    }

    private List<ProvidedRole> getAllProvidedRolesOf(List<AssemblyContext> createdAssemblyContexts) {
        return createdAssemblyContexts.stream().flatMap(ac -> ac.getEncapsulatedComponent__AssemblyContext().getProvidedRoles_InterfaceProvidingEntity().stream()).collect(Collectors.toList());
    }

    protected <T extends Role> Role getComplimentaryRoleOf(Role role, List<T> complimentaryRoleSpace) throws FCCWeaverException {
        return this.getRoleHandlerBy(role).getComplimentaryRoleOf(role, complimentaryRoleSpace).orElseThrow(() -> new FCCWeaverException(ErrorMessage.missingComplimentaryRole((RepositoryComponent)role.eContainer(), role)));
    }

    private RoleHandler getRoleHandlerBy(Role role) throws FCCWeaverException {
        return RoleHandlerFactory.getBy(role, this.parent.getMergedRepoManager()).orElseThrow(() -> new FCCWeaverException(ErrorMessage.unsupportedRole()));
    }

    protected Predicate<AssemblyContext> getAssemblyContextInstantiating(RepositoryComponent component) {
        return assemblyContext -> FCCUtil.areEqual((EObject)assemblyContext.getEncapsulatedComponent__AssemblyContext(), (EObject)component);
    }

    private AssemblyContext getAssemblyContextProviding(ProvidedRole providedRole, List<AssemblyContext> assemblyContexts) {
        for (AssemblyContext ac : assemblyContexts) {
            if (!ac.getEncapsulatedComponent__AssemblyContext().getProvidedRoles_InterfaceProvidingEntity().stream().anyMatch(role -> role.getId().equals(providedRole.getId()))) continue;
            return ac;
        }
        return null;
    }
}

