/*
 * Decompiled with CFR 0.152.
 */
package featureObjective;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum LogicalOperation implements Enumerator
{
    OR(1, "OR", "OR"),
    XOR(2, "XOR", "XOR");

    public static final int OR_VALUE = 1;
    public static final int XOR_VALUE = 2;
    private static final LogicalOperation[] VALUES_ARRAY;
    public static final List<LogicalOperation> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new LogicalOperation[]{OR, XOR};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static LogicalOperation get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LogicalOperation result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LogicalOperation getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LogicalOperation result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LogicalOperation get(int value) {
        switch (value) {
            case 1: {
                return OR;
            }
            case 2: {
                return XOR;
            }
        }
        return null;
    }

    private LogicalOperation(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

